/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.client.internal.ContainsKeyOp;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.InternalLogWriter;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.security.NotAuthorizedException;
import java.io.IOException;

public class ContainsKey66
extends BaseCommand {
    private static final ContainsKey66 singleton = new ContainsKey66();

    public static Command getCommand() {
        return singleton;
    }

    private ContainsKey66() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        Part regionNamePart = null;
        Part keyPart = null;
        String regionName = null;
        Object key = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadContainsKeyRequestTime(start - oldStart);
        regionNamePart = msg.getPart(0);
        keyPart = msg.getPart(1);
        ContainsKeyOp.MODE mode = ContainsKeyOp.MODE.values()[msg.getPart(2).getInt()];
        regionName = regionNamePart.getString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            ContainsKey66.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received containsKey request ({} bytes) from {} for region {} key {}", new Object[]{servConn.getName(), msg.getPayloadLength(), servConn.getSocketString(), regionName, key});
        }
        if (key == null || regionName == null) {
            String errMessage = "";
            if (key == null) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ContainsKey_0_THE_INPUT_KEY_FOR_THE_CONTAINSKEY_REQUEST_IS_NULL, servConn.getName()));
                errMessage = LocalizedStrings.ContainsKey_THE_INPUT_KEY_FOR_THE_CONTAINSKEY_REQUEST_IS_NULL.toLocalizedString();
            }
            if (regionName == null) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ContainsKey_0_THE_INPUT_REGION_NAME_FOR_THE_CONTAINSKEY_REQUEST_IS_NULL, servConn.getName()));
                errMessage = LocalizedStrings.ContainsKey_THE_INPUT_REGION_NAME_FOR_THE_CONTAINSKEY_REQUEST_IS_NULL.toLocalizedString();
            }
            ContainsKey66.writeErrorResponse(msg, 39, errMessage, servConn);
            servConn.setAsTrue(1);
        } else {
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = LocalizedStrings.ContainsKey_WAS_NOT_FOUND_DURING_CONTAINSKEY_REQUEST.toLocalizedString();
                ContainsKey66.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else {
                boolean containsKey;
                AuthorizeRequest authzRequest = servConn.getAuthzRequest();
                if (authzRequest != null) {
                    try {
                        authzRequest.containsKeyAuthorize(regionName, key);
                    }
                    catch (NotAuthorizedException ex) {
                        ContainsKey66.writeException(msg, ex, false, servConn);
                        servConn.setAsTrue(1);
                        return;
                    }
                }
                switch (mode) {
                    case KEY: {
                        containsKey = region.containsKey(key);
                        break;
                    }
                    case VALUE: {
                        containsKey = region.containsValue(key);
                        break;
                    }
                    case VALUE_FOR_KEY: {
                        containsKey = region.containsValueForKey(key);
                        break;
                    }
                    default: {
                        containsKey = false;
                    }
                }
                long oldStart2 = start;
                start = DistributionStats.getStatTime();
                stats.incProcessContainsKeyTime(start - oldStart2);
                ContainsKey66.writeContainsKeyResponse(containsKey, msg, servConn);
                servConn.setAsTrue(1);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Sent containsKey response for region {} key {}", new Object[]{servConn.getName(), regionName, key});
                }
                stats.incWriteContainsKeyResponseTime(DistributionStats.getStatTime() - start);
            }
        }
    }

    private static void writeContainsKeyResponse(boolean containsKey, Message origMsg, ServerConnection servConn) throws IOException {
        InternalLogWriter logger = servConn.getLogWriter();
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setNumberOfParts(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        responseMsg.addObjPart(containsKey ? Boolean.TRUE : Boolean.FALSE);
        responseMsg.send(servConn);
    }
}

