/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.operations.RegionClearOperationContext;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ClearRegion
extends BaseCommand {
    private static final ClearRegion singleton = new ClearRegion();

    public static Command getCommand() {
        return singleton;
    }

    private ClearRegion() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part callbackArgPart = null;
        String regionName = null;
        Object callbackArg = null;
        Part eventPart = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadClearRegionRequestTime(start - oldStart);
        regionNamePart = msg.getPart(0);
        eventPart = msg.getPart(1);
        if (msg.getNumberOfParts() > 2) {
            callbackArgPart = msg.getPart(2);
            try {
                callbackArg = callbackArgPart.getObject();
            }
            catch (Exception e) {
                ClearRegion.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getString();
        if (logger.isDebugEnabled()) {
            logger.debug(servConn.getName() + ": Received clear region request (" + msg.getPayloadLength() + " bytes) from " + servConn.getSocketString() + " for region " + regionName);
        }
        if (regionName == null) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ClearRegion_0_THE_INPUT_REGION_NAME_FOR_THE_CLEAR_REGION_REQUEST_IS_NULL, servConn.getName()));
            String errMessage = LocalizedStrings.ClearRegion_THE_INPUT_REGION_NAME_FOR_THE_CLEAR_REGION_REQUEST_IS_NULL.toLocalizedString();
            ClearRegion.writeErrorResponse(msg, 37, errMessage, servConn);
            servConn.setAsTrue(1);
        } else {
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = LocalizedStrings.ClearRegion_WAS_NOT_FOUND_DURING_CLEAR_REGION_REGUEST.toLocalizedString();
                ClearRegion.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else {
                ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
                long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
                long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
                EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
                try {
                    AuthorizeRequest authzRequest = servConn.getAuthzRequest();
                    if (authzRequest != null) {
                        RegionClearOperationContext clearContext = authzRequest.clearAuthorize(regionName, callbackArg);
                        callbackArg = clearContext.getCallbackArg();
                    }
                    region.basicBridgeClear(callbackArg, servConn.getProxyID(), true, eventId);
                }
                catch (Exception e) {
                    ClearRegion.checkForInterrupt(servConn, e);
                    ClearRegion.writeException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                long oldStart2 = start;
                start = DistributionStats.getStatTime();
                stats.incProcessClearRegionTime(start - oldStart2);
                this.writeReply(msg, servConn);
                servConn.setAsTrue(1);
                if (logger.isDebugEnabled()) {
                    logger.debug(servConn.getName() + ": Sent clear region response for region " + regionName);
                }
                stats.incWriteClearRegionResponseTime(DistributionStats.getStatTime() - start);
            }
        }
    }
}

