/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.pdx.internal.EnumInfo;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public class AddPdxEnum
extends BaseCommand {
    private static final Logger logger = LogService.getLogger();
    private static final AddPdxEnum singleton = new AddPdxEnum();

    public static Command getCommand() {
        return singleton;
    }

    private AddPdxEnum() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException {
        servConn.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received get pdx id for enum request ({} parts) from {}", new Object[]{servConn.getName(), msg.getNumberOfParts(), servConn.getSocketString()});
        }
        int noOfParts = msg.getNumberOfParts();
        EnumInfo enumInfo = (EnumInfo)msg.getPart(0).getObject();
        int enumId = msg.getPart(1).getInt();
        try {
            GemFireCacheImpl cache = (GemFireCacheImpl)servConn.getCache();
            TypeRegistry registry = cache.getPdxRegistry();
            registry.addRemoteEnum(enumId, enumInfo);
        }
        catch (Exception e) {
            AddPdxEnum.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        this.writeReply(msg, servConn);
        servConn.setAsTrue(1);
    }
}

