/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.internal.cache.CacheServerImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ClientBlacklistProcessor
extends ReplyProcessor21 {
    public static void sendBlacklistedClient(ClientProxyMembershipID proxyId, DM dm, Set members) {
        ClientBlacklistProcessor processor = new ClientBlacklistProcessor(dm, members);
        ClientBlacklistMessage.send(proxyId, dm, processor, members);
        try {
            processor.waitForRepliesUninterruptibly();
        }
        catch (ReplyException e) {
            e.handleAsUnexpected();
        }
    }

    @Override
    public void process(DistributionMessage msg) {
        super.process(msg);
    }

    private ClientBlacklistProcessor(DM dm, Set members) {
        super(dm, (Collection)members);
    }

    public static class ClientBlacklistReply
    extends ReplyMessage {
    }

    public static class ClientBlacklistMessage
    extends PooledDistributionMessage
    implements MessageWithReply {
        private int processorId;
        private ClientProxyMembershipID proxyId;

        protected static void send(ClientProxyMembershipID proxyId, DM dm, ClientBlacklistProcessor proc, Set members) {
            ClientBlacklistMessage msg = new ClientBlacklistMessage();
            msg.processorId = proc.getProcessorId();
            msg.proxyId = proxyId;
            msg.setRecipients(members);
            dm.putOutgoing(msg);
        }

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        public ClientProxyMembershipID getProxyId() {
            return this.proxyId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(DistributionManager dm) {
            try {
                List<CacheServer> l;
                GemFireCacheImpl c = GemFireCacheImpl.getInstance();
                if (c != null && (l = c.getCacheServers()) != null) {
                    for (CacheServerImpl cacheServerImpl : l) {
                        CacheClientNotifier ccn = cacheServerImpl.getAcceptor().getCacheClientNotifier();
                        ccn.addToBlacklistedClient(this.proxyId);
                        CacheClientProxy proxy = ccn.getClientProxy(this.proxyId);
                        if (proxy == null) continue;
                        proxy.close(false, false);
                        ccn.removeClientProxy(proxy);
                    }
                }
            }
            finally {
                ClientBlacklistReply reply = new ClientBlacklistReply();
                reply.setProcessorId(this.getProcessorId());
                reply.setRecipient(this.getSender());
                if (dm.getId().equals(this.getSender())) {
                    reply.setSender(this.getSender());
                    reply.dmProcess(dm);
                } else {
                    dm.putOutgoing(reply);
                }
            }
        }

        @Override
        public int getDSFID() {
            return -45;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            this.proxyId = ClientProxyMembershipID.readCanonicalized(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            DataSerializer.writeObject(this.proxyId, out);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("ClientBlacklistMessage (proxyId='").append(this.proxyId).append("' processorId=").append(this.processorId).append(")");
            return buff.toString();
        }
    }
}

