/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.cache.server.ServerLoad;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.PoolStatHelper;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.tier.sockets.MessageStats;

public class CacheServerStats
implements MessageStats {
    private static final String typeName = "CacheServerStats";
    protected Statistics stats;
    int getRequestsId;
    int readGetRequestTimeId;
    int processGetTimeId;
    int getResponsesId;
    int writeGetResponseTimeId;
    int putAllRequestsId;
    int readPutAllRequestTimeId;
    int processPutAllTimeId;
    int putAllResponsesId;
    int writePutAllResponseTimeId;
    int removeAllRequestsId;
    int readRemoveAllRequestTimeId;
    int processRemoveAllTimeId;
    int removeAllResponsesId;
    int writeRemoveAllResponseTimeId;
    int getAllRequestsId;
    int readGetAllRequestTimeId;
    int processGetAllTimeId;
    int getAllResponsesId;
    int writeGetAllResponseTimeId;
    int putRequestsId;
    int readPutRequestTimeId;
    int processPutTimeId;
    int putResponsesId;
    int writePutResponseTimeId;
    int destroyRequestsId;
    int readDestroyRequestTimeId;
    int processDestroyTimeId;
    int destroyResponsesId;
    int writeDestroyResponseTimeId;
    int queryRequestsId;
    int readQueryRequestTimeId;
    int processQueryTimeId;
    int queryResponsesId;
    int writeQueryResponseTimeId;
    int destroyRegionRequestsId;
    int readDestroyRegionRequestTimeId;
    int processDestroyRegionTimeId;
    int destroyRegionResponsesId;
    int writeDestroyRegionResponseTimeId;
    int containsKeyRequestsId;
    int readContainsKeyRequestTimeId;
    int processContainsKeyTimeId;
    int containsKeyResponsesId;
    int writeContainsKeyResponseTimeId;
    int clearRegionRequestsId;
    int readClearRegionRequestTimeId;
    int processClearRegionTimeId;
    int clearRegionResponsesId;
    int writeClearRegionResponseTimeId;
    int processBatchRequestsId;
    int readProcessBatchRequestTimeId;
    int processBatchTimeId;
    int processBatchResponsesId;
    int writeProcessBatchResponseTimeId;
    int batchSizeId;
    int clientNotificationRequestsId;
    int readClientNotificationRequestTimeId;
    int processClientNotificationTimeId;
    int updateClientNotificationRequestsId;
    int readUpdateClientNotificationRequestTimeId;
    int processUpdateClientNotificationTimeId;
    int closeConnectionRequestsId;
    int readCloseConnectionRequestTimeId;
    int processCloseConnectionTimeId;
    int clientReadyRequestsId;
    int readClientReadyRequestTimeId;
    int processClientReadyTimeId;
    int clientReadyResponsesId;
    int writeClientReadyResponseTimeId;
    int currentClientConnectionsId;
    int currentQueueConnectionsId;
    int currentClientsId;
    int failedConnectionAttemptsId;
    int receivedBytesId;
    int sentBytesId;
    int outOfOrderBatchIdsId;
    int abandonedWriteRequestsId;
    int abandonedReadRequestsId;
    int messagesBeingReceivedId;
    int messageBytesBeingReceivedId;
    int connectionsTimedOutId;
    int threadQueueSizeId;
    int acceptsInProgressId;
    int acceptThreadStartsId;
    int connectionThreadStartsId;
    int connectionThreadsId;
    int connectionLoadId;
    int queueLoadId;
    int loadPerConnectionId;
    int loadPerQueueId;
    protected StatisticsType statType;

    public CacheServerStats(String ownerName) {
        this(InternalDistributedSystem.getAnyInstance(), ownerName, typeName, null);
    }

    public CacheServerStats(StatisticsFactory f, String ownerName, String typeName, StatisticDescriptor[] descriptiors) {
        StatisticDescriptor[] serverStatDescriptors;
        if (f == null) {
            return;
        }
        StatisticDescriptor[] alldescriptors = serverStatDescriptors = new StatisticDescriptor[]{f.createIntCounter("getRequests", "Number of cache client get requests.", "operations"), f.createLongCounter("readGetRequestTime", "Total time spent in reading get requests.", "nanoseconds"), f.createLongCounter("processGetTime", "Total time spent in processing a cache client get request, including the time to get an object from the cache.", "nanoseconds"), f.createIntCounter("getResponses", "Number of get responses written to the cache client.", "operations"), f.createLongCounter("writeGetResponseTime", "Total time spent in writing get responses.", "nanoseconds"), f.createIntCounter("putRequests", "Number of cache client put requests.", "operations"), f.createLongCounter("readPutRequestTime", "Total time spent in reading put requests.", "nanoseconds"), f.createLongCounter("processPutTime", "Total time spent in processing a cache client put request, including the time to put an object into the cache.", "nanoseconds"), f.createIntCounter("putResponses", "Number of put responses written to the cache client.", "operations"), f.createLongCounter("writePutResponseTime", "Total time spent in writing put responses.", "nanoseconds"), f.createIntCounter("putAllRequests", "Number of cache client putAll requests.", "operations"), f.createLongCounter("readPutAllRequestTime", "Total time spent in reading putAll requests.", "nanoseconds"), f.createLongCounter("processPutAllTime", "Total time spent in processing a cache client putAll request, including the time to put all objects into the cache.", "nanoseconds"), f.createIntCounter("putAllResponses", "Number of putAll responses written to the cache client.", "operations"), f.createLongCounter("writePutAllResponseTime", "Total time spent in writing putAll responses.", "nanoseconds"), f.createIntCounter("removeAllRequests", "Number of cache client removeAll requests.", "operations"), f.createLongCounter("readRemoveAllRequestTime", "Total time spent in reading removeAll requests.", "nanoseconds"), f.createLongCounter("processRemoveAllTime", "Total time spent in processing a cache client removeAll request, including the time to remove all objects from the cache.", "nanoseconds"), f.createIntCounter("removeAllResponses", "Number of removeAll responses written to the cache client.", "operations"), f.createLongCounter("writeRemoveAllResponseTime", "Total time spent in writing removeAll responses.", "nanoseconds"), f.createIntCounter("getAllRequests", "Number of cache client getAll requests.", "operations"), f.createLongCounter("readGetAllRequestTime", "Total time spent in reading getAll requests.", "nanoseconds"), f.createLongCounter("processGetAllTime", "Total time spent in processing a cache client getAll request.", "nanoseconds"), f.createIntCounter("getAllResponses", "Number of getAll responses written to the cache client.", "operations"), f.createLongCounter("writeGetAllResponseTime", "Total time spent in writing getAll responses.", "nanoseconds"), f.createIntCounter("destroyRequests", "Number of cache client destroy requests.", "operations"), f.createLongCounter("readDestroyRequestTime", "Total time spent in reading destroy requests.", "nanoseconds"), f.createLongCounter("processDestroyTime", "Total time spent in processing a cache client destroy request, including the time to destroy an object from the cache.", "nanoseconds"), f.createIntCounter("destroyResponses", "Number of destroy responses written to the cache client.", "operations"), f.createLongCounter("writeDestroyResponseTime", "Total time spent in writing destroy responses.", "nanoseconds"), f.createIntCounter("invalidateRequests", "Number of cache client invalidate requests.", "operations"), f.createLongCounter("readInvalidateRequestTime", "Total time spent in reading invalidate requests.", "nanoseconds"), f.createLongCounter("processInvalidateTime", "Total time spent in processing a cache client invalidate request, including the time to invalidate an object from the cache.", "nanoseconds"), f.createIntCounter("invalidateResponses", "Number of invalidate responses written to the cache client.", "operations"), f.createLongCounter("writeInvalidateResponseTime", "Total time spent in writing invalidate responses.", "nanoseconds"), f.createIntCounter("sizeRequests", "Number of cache client size requests.", "operations"), f.createLongCounter("readSizeRequestTime", "Total time spent in reading size requests.", "nanoseconds"), f.createLongCounter("processSizeTime", "Total time spent in processing a cache client size request, including the time to size an object from the cache.", "nanoseconds"), f.createIntCounter("sizeResponses", "Number of size responses written to the cache client.", "operations"), f.createLongCounter("writeSizeResponseTime", "Total time spent in writing size responses.", "nanoseconds"), f.createIntCounter("queryRequests", "Number of cache client query requests.", "operations"), f.createLongCounter("readQueryRequestTime", "Total time spent in reading query requests.", "nanoseconds"), f.createLongCounter("processQueryTime", "Total time spent in processing a cache client query request, including the time to destroy an object from the cache.", "nanoseconds"), f.createIntCounter("queryResponses", "Number of query responses written to the cache client.", "operations"), f.createLongCounter("writeQueryResponseTime", "Total time spent in writing query responses.", "nanoseconds"), f.createIntCounter("destroyRegionRequests", "Number of cache client destroyRegion requests.", "operations"), f.createLongCounter("readDestroyRegionRequestTime", "Total time spent in reading destroyRegion requests.", "nanoseconds"), f.createLongCounter("processDestroyRegionTime", "Total time spent in processing a cache client destroyRegion request, including the time to destroy the region from the cache.", "nanoseconds"), f.createIntCounter("destroyRegionResponses", "Number of destroyRegion responses written to the cache client.", "operations"), f.createLongCounter("writeDestroyRegionResponseTime", "Total time spent in writing destroyRegion responses.", "nanoseconds"), f.createIntCounter("containsKeyRequests", "Number of cache client containsKey requests.", "operations"), f.createLongCounter("readContainsKeyRequestTime", "Total time spent reading containsKey requests.", "nanoseconds"), f.createLongCounter("processContainsKeyTime", "Total time spent processing a containsKey request.", "nanoseconds"), f.createIntCounter("containsKeyResponses", "Number of containsKey responses written to the cache client.", "operations"), f.createLongCounter("writeContainsKeyResponseTime", "Total time spent writing containsKey responses.", "nanoseconds"), f.createIntCounter("processBatchRequests", "Number of cache client processBatch requests.", "operations"), f.createLongCounter("readProcessBatchRequestTime", "Total time spent in reading processBatch requests.", "nanoseconds"), f.createLongCounter("processBatchTime", "Total time spent in processing a cache client processBatch request.", "nanoseconds"), f.createIntCounter("processBatchResponses", "Number of processBatch responses written to the cache client.", "operations"), f.createLongCounter("writeProcessBatchResponseTime", "Total time spent in writing processBatch responses.", "nanoseconds"), f.createLongCounter("batchSize", "The size of the batches received.", "bytes"), f.createIntCounter("clearRegionRequests", "Number of cache client clearRegion requests.", "operations"), f.createLongCounter("readClearRegionRequestTime", "Total time spent in reading clearRegion requests.", "nanoseconds"), f.createLongCounter("processClearRegionTime", "Total time spent in processing a cache client clearRegion request, including the time to clear the region from the cache.", "nanoseconds"), f.createIntCounter("clearRegionResponses", "Number of clearRegion responses written to the cache client.", "operations"), f.createLongCounter("writeClearRegionResponseTime", "Total time spent in writing clearRegion responses.", "nanoseconds"), f.createIntCounter("clientNotificationRequests", "Number of cache client notification requests.", "operations"), f.createLongCounter("readClientNotificationRequestTime", "Total time spent in reading client notification requests.", "nanoseconds"), f.createLongCounter("processClientNotificationTime", "Total time spent in processing a cache client notification request.", "nanoseconds"), f.createIntCounter("updateClientNotificationRequests", "Number of cache client notification update requests.", "operations"), f.createLongCounter("readUpdateClientNotificationRequestTime", "Total time spent in reading client notification update requests.", "nanoseconds"), f.createLongCounter("processUpdateClientNotificationTime", "Total time spent in processing a client notification update request.", "nanoseconds"), f.createIntCounter("clientReadyRequests", "Number of cache client ready requests.", "operations"), f.createLongCounter("readClientReadyRequestTime", "Total time spent in reading cache client ready requests.", "nanoseconds"), f.createLongCounter("processClientReadyTime", "Total time spent in processing a cache client ready request, including the time to destroy an object from the cache.", "nanoseconds"), f.createIntCounter("clientReadyResponses", "Number of client ready responses written to the cache client.", "operations"), f.createLongCounter("writeClientReadyResponseTime", "Total time spent in writing client ready responses.", "nanoseconds"), f.createIntCounter("closeConnectionRequests", "Number of cache client close connection requests.", "operations"), f.createLongCounter("readCloseConnectionRequestTime", "Total time spent in reading close connection requests.", "nanoseconds"), f.createLongCounter("processCloseConnectionTime", "Total time spent in processing a cache client close connection request.", "nanoseconds"), f.createIntCounter("failedConnectionAttempts", "Number of failed connection attempts.", "attempts"), f.createIntGauge("currentClientConnections", "Number of sockets accepted and used for client to server messaging.", "sockets"), f.createIntGauge("currentQueueConnections", "Number of sockets accepted and used for server to client messaging.", "sockets"), f.createIntGauge("currentClients", "Number of client virtual machines connected.", "clients"), f.createIntCounter("outOfOrderGatewayBatchIds", "Number of Out of order batch IDs.", "batches"), f.createIntCounter("abandonedWriteRequests", "Number of write opertations abandond by clients", "requests"), f.createIntCounter("abandonedReadRequests", "Number of read opertations abandond by clients", "requests"), f.createLongCounter("receivedBytes", "Total number of bytes received from clients.", "bytes"), f.createLongCounter("sentBytes", "Total number of bytes sent to clients.", "bytes"), f.createIntGauge("messagesBeingReceived", "Current number of message being received off the network or being processed after reception.", "messages"), f.createLongGauge("messageBytesBeingReceived", "Current number of bytes consumed by messages being received or processed.", "bytes"), f.createIntCounter("connectionsTimedOut", "Total number of connections that have been timed out by the server because of client inactivity", "connections"), f.createIntGauge("threadQueueSize", "Current number of connections waiting for a thread to start processing their message.", "connections"), f.createIntGauge("acceptsInProgress", "Current number of server accepts that are attempting to do the initial handshake with the client.", "accepts"), f.createIntCounter("acceptThreadStarts", "Total number of threads created to deal with an accepted socket. Note that this is not the current number of threads.", "starts"), f.createIntCounter("connectionThreadStarts", "Total number of threads created to deal with a client connection. Note that this is not the current number of threads.", "starts"), f.createIntGauge("connectionThreads", "Current number of threads dealing with a client connection.", "threads"), f.createDoubleGauge("connectionLoad", "The load from client to server connections as reported by the load probe installed in this server", "load"), f.createDoubleGauge("loadPerConnection", "The estimate of how much load is added for each new connection as reported by the load probe installed in this server", "load"), f.createDoubleGauge("queueLoad", "The load from queues as reported by the load probe installed in this server", "load"), f.createDoubleGauge("loadPerQueue", "The estimate of how much load is added for each new connection as reported by the load probe installed in this server", "load")};
        if (descriptiors != null) {
            alldescriptors = new StatisticDescriptor[descriptiors.length + serverStatDescriptors.length];
            System.arraycopy(descriptiors, 0, alldescriptors, 0, descriptiors.length);
            System.arraycopy(serverStatDescriptors, 0, alldescriptors, descriptiors.length, serverStatDescriptors.length);
        }
        this.statType = f.createType(typeName, typeName, alldescriptors);
        try {
            ownerName = SocketCreator.getLocalHost().getCanonicalHostName() + "-" + ownerName;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stats = f.createAtomicStatistics(this.statType, ownerName);
        this.getRequestsId = this.stats.nameToId("getRequests");
        this.readGetRequestTimeId = this.stats.nameToId("readGetRequestTime");
        this.processGetTimeId = this.stats.nameToId("processGetTime");
        this.getResponsesId = this.stats.nameToId("getResponses");
        this.writeGetResponseTimeId = this.stats.nameToId("writeGetResponseTime");
        this.putRequestsId = this.stats.nameToId("putRequests");
        this.readPutRequestTimeId = this.stats.nameToId("readPutRequestTime");
        this.processPutTimeId = this.stats.nameToId("processPutTime");
        this.putResponsesId = this.stats.nameToId("putResponses");
        this.writePutResponseTimeId = this.stats.nameToId("writePutResponseTime");
        this.putAllRequestsId = this.stats.nameToId("putAllRequests");
        this.readPutAllRequestTimeId = this.stats.nameToId("readPutAllRequestTime");
        this.processPutAllTimeId = this.stats.nameToId("processPutAllTime");
        this.putAllResponsesId = this.stats.nameToId("putAllResponses");
        this.writePutAllResponseTimeId = this.stats.nameToId("writePutAllResponseTime");
        this.removeAllRequestsId = this.stats.nameToId("removeAllRequests");
        this.readRemoveAllRequestTimeId = this.stats.nameToId("readRemoveAllRequestTime");
        this.processRemoveAllTimeId = this.stats.nameToId("processRemoveAllTime");
        this.removeAllResponsesId = this.stats.nameToId("removeAllResponses");
        this.writeRemoveAllResponseTimeId = this.stats.nameToId("writeRemoveAllResponseTime");
        this.getAllRequestsId = this.stats.nameToId("getAllRequests");
        this.readGetAllRequestTimeId = this.stats.nameToId("readGetAllRequestTime");
        this.processGetAllTimeId = this.stats.nameToId("processGetAllTime");
        this.getAllResponsesId = this.stats.nameToId("getAllResponses");
        this.writeGetAllResponseTimeId = this.stats.nameToId("writeGetAllResponseTime");
        this.destroyRequestsId = this.stats.nameToId("destroyRequests");
        this.readDestroyRequestTimeId = this.stats.nameToId("readDestroyRequestTime");
        this.processDestroyTimeId = this.stats.nameToId("processDestroyTime");
        this.destroyResponsesId = this.stats.nameToId("destroyResponses");
        this.writeDestroyResponseTimeId = this.stats.nameToId("writeDestroyResponseTime");
        this.queryRequestsId = this.stats.nameToId("queryRequests");
        this.readQueryRequestTimeId = this.stats.nameToId("readQueryRequestTime");
        this.processQueryTimeId = this.stats.nameToId("processQueryTime");
        this.queryResponsesId = this.stats.nameToId("queryResponses");
        this.writeQueryResponseTimeId = this.stats.nameToId("writeQueryResponseTime");
        this.destroyRegionRequestsId = this.stats.nameToId("destroyRegionRequests");
        this.readDestroyRegionRequestTimeId = this.stats.nameToId("readDestroyRegionRequestTime");
        this.processDestroyRegionTimeId = this.stats.nameToId("processDestroyRegionTime");
        this.destroyRegionResponsesId = this.stats.nameToId("destroyRegionResponses");
        this.writeDestroyRegionResponseTimeId = this.stats.nameToId("writeDestroyRegionResponseTime");
        this.clearRegionRequestsId = this.stats.nameToId("clearRegionRequests");
        this.readClearRegionRequestTimeId = this.stats.nameToId("readClearRegionRequestTime");
        this.processClearRegionTimeId = this.stats.nameToId("processClearRegionTime");
        this.clearRegionResponsesId = this.stats.nameToId("clearRegionResponses");
        this.writeClearRegionResponseTimeId = this.stats.nameToId("writeClearRegionResponseTime");
        this.containsKeyRequestsId = this.stats.nameToId("containsKeyRequests");
        this.readContainsKeyRequestTimeId = this.stats.nameToId("readContainsKeyRequestTime");
        this.processContainsKeyTimeId = this.stats.nameToId("processContainsKeyTime");
        this.containsKeyResponsesId = this.stats.nameToId("containsKeyResponses");
        this.writeContainsKeyResponseTimeId = this.stats.nameToId("writeContainsKeyResponseTime");
        this.processBatchRequestsId = this.stats.nameToId("processBatchRequests");
        this.readProcessBatchRequestTimeId = this.stats.nameToId("readProcessBatchRequestTime");
        this.processBatchTimeId = this.stats.nameToId("processBatchTime");
        this.processBatchResponsesId = this.stats.nameToId("processBatchResponses");
        this.writeProcessBatchResponseTimeId = this.stats.nameToId("writeProcessBatchResponseTime");
        this.batchSizeId = this.stats.nameToId("batchSize");
        this.clientNotificationRequestsId = this.stats.nameToId("clientNotificationRequests");
        this.readClientNotificationRequestTimeId = this.stats.nameToId("readClientNotificationRequestTime");
        this.processClientNotificationTimeId = this.stats.nameToId("processClientNotificationTime");
        this.updateClientNotificationRequestsId = this.stats.nameToId("updateClientNotificationRequests");
        this.readUpdateClientNotificationRequestTimeId = this.stats.nameToId("readUpdateClientNotificationRequestTime");
        this.processUpdateClientNotificationTimeId = this.stats.nameToId("processUpdateClientNotificationTime");
        this.clientReadyRequestsId = this.stats.nameToId("clientReadyRequests");
        this.readClientReadyRequestTimeId = this.stats.nameToId("readClientReadyRequestTime");
        this.processClientReadyTimeId = this.stats.nameToId("processClientReadyTime");
        this.clientReadyResponsesId = this.stats.nameToId("clientReadyResponses");
        this.writeClientReadyResponseTimeId = this.stats.nameToId("writeClientReadyResponseTime");
        this.closeConnectionRequestsId = this.stats.nameToId("closeConnectionRequests");
        this.readCloseConnectionRequestTimeId = this.stats.nameToId("readCloseConnectionRequestTime");
        this.processCloseConnectionTimeId = this.stats.nameToId("processCloseConnectionTime");
        this.currentClientConnectionsId = this.stats.nameToId("currentClientConnections");
        this.currentQueueConnectionsId = this.stats.nameToId("currentQueueConnections");
        this.currentClientsId = this.stats.nameToId("currentClients");
        this.failedConnectionAttemptsId = this.stats.nameToId("failedConnectionAttempts");
        this.outOfOrderBatchIdsId = this.stats.nameToId("outOfOrderGatewayBatchIds");
        this.abandonedWriteRequestsId = this.stats.nameToId("abandonedWriteRequests");
        this.abandonedReadRequestsId = this.stats.nameToId("abandonedReadRequests");
        this.receivedBytesId = this.stats.nameToId("receivedBytes");
        this.sentBytesId = this.stats.nameToId("sentBytes");
        this.messagesBeingReceivedId = this.stats.nameToId("messagesBeingReceived");
        this.messageBytesBeingReceivedId = this.stats.nameToId("messageBytesBeingReceived");
        this.connectionsTimedOutId = this.stats.nameToId("connectionsTimedOut");
        this.threadQueueSizeId = this.stats.nameToId("threadQueueSize");
        this.acceptsInProgressId = this.stats.nameToId("acceptsInProgress");
        this.acceptThreadStartsId = this.stats.nameToId("acceptThreadStarts");
        this.connectionThreadStartsId = this.stats.nameToId("connectionThreadStarts");
        this.connectionThreadsId = this.stats.nameToId("connectionThreads");
        this.connectionLoadId = this.stats.nameToId("connectionLoad");
        this.queueLoadId = this.stats.nameToId("queueLoad");
        this.loadPerConnectionId = this.stats.nameToId("loadPerConnection");
        this.loadPerQueueId = this.stats.nameToId("loadPerQueue");
    }

    public final void incAcceptThreadsCreated() {
        this.stats.incInt(this.acceptThreadStartsId, 1);
    }

    public final void incConnectionThreadsCreated() {
        this.stats.incInt(this.connectionThreadStartsId, 1);
    }

    public final void incAcceptsInProgress() {
        this.stats.incInt(this.acceptsInProgressId, 1);
    }

    public final void decAcceptsInProgress() {
        this.stats.incInt(this.acceptsInProgressId, -1);
    }

    public final void incConnectionThreads() {
        this.stats.incInt(this.connectionThreadsId, 1);
    }

    public final void decConnectionThreads() {
        this.stats.incInt(this.connectionThreadsId, -1);
    }

    public final void incAbandonedWriteRequests() {
        this.stats.incInt(this.abandonedWriteRequestsId, 1);
    }

    public final void incAbandonedReadRequests() {
        this.stats.incInt(this.abandonedReadRequestsId, 1);
    }

    public final void incFailedConnectionAttempts() {
        this.stats.incInt(this.failedConnectionAttemptsId, 1);
    }

    public final void incConnectionsTimedOut() {
        this.stats.incInt(this.connectionsTimedOutId, 1);
    }

    public final void incCurrentClientConnections() {
        this.stats.incInt(this.currentClientConnectionsId, 1);
    }

    public final void decCurrentClientConnections() {
        this.stats.incInt(this.currentClientConnectionsId, -1);
    }

    public final int getCurrentClientConnections() {
        return this.stats.getInt(this.currentClientConnectionsId);
    }

    public final void incCurrentQueueConnections() {
        this.stats.incInt(this.currentQueueConnectionsId, 1);
    }

    public final void decCurrentQueueConnections() {
        this.stats.incInt(this.currentQueueConnectionsId, -1);
    }

    public final int getCurrentQueueConnections() {
        return this.stats.getInt(this.currentQueueConnectionsId);
    }

    public final void incCurrentClients() {
        this.stats.incInt(this.currentClientsId, 1);
    }

    public final void decCurrentClients() {
        this.stats.incInt(this.currentClientsId, -1);
    }

    public final void incThreadQueueSize() {
        this.stats.incInt(this.threadQueueSizeId, 1);
    }

    public final void decThreadQueueSize() {
        this.stats.incInt(this.threadQueueSizeId, -1);
    }

    public final void incReadGetRequestTime(long delta) {
        this.stats.incLong(this.readGetRequestTimeId, delta);
        this.stats.incInt(this.getRequestsId, 1);
    }

    public final void incProcessGetTime(long delta) {
        this.stats.incLong(this.processGetTimeId, delta);
    }

    public final void incWriteGetResponseTime(long delta) {
        this.stats.incLong(this.writeGetResponseTimeId, delta);
        this.stats.incInt(this.getResponsesId, 1);
    }

    public final void incReadPutAllRequestTime(long delta) {
        this.stats.incLong(this.readPutAllRequestTimeId, delta);
        this.stats.incInt(this.putAllRequestsId, 1);
    }

    public final void incProcessPutAllTime(long delta) {
        this.stats.incLong(this.processPutAllTimeId, delta);
    }

    public final void incWritePutAllResponseTime(long delta) {
        this.stats.incLong(this.writePutAllResponseTimeId, delta);
        this.stats.incInt(this.putAllResponsesId, 1);
    }

    public final void incReadRemoveAllRequestTime(long delta) {
        this.stats.incLong(this.readRemoveAllRequestTimeId, delta);
        this.stats.incInt(this.removeAllRequestsId, 1);
    }

    public final void incProcessRemoveAllTime(long delta) {
        this.stats.incLong(this.processRemoveAllTimeId, delta);
    }

    public final void incWriteRemoveAllResponseTime(long delta) {
        this.stats.incLong(this.writeRemoveAllResponseTimeId, delta);
        this.stats.incInt(this.removeAllResponsesId, 1);
    }

    public final void incReadGetAllRequestTime(long delta) {
        this.stats.incLong(this.readGetAllRequestTimeId, delta);
        this.stats.incInt(this.getAllRequestsId, 1);
    }

    public final void incProcessGetAllTime(long delta) {
        this.stats.incLong(this.processGetAllTimeId, delta);
    }

    public final void incWriteGetAllResponseTime(long delta) {
        this.stats.incLong(this.writeGetAllResponseTimeId, delta);
        this.stats.incInt(this.getAllResponsesId, 1);
    }

    public final void incReadPutRequestTime(long delta) {
        this.stats.incLong(this.readPutRequestTimeId, delta);
        this.stats.incInt(this.putRequestsId, 1);
    }

    public final void incProcessPutTime(long delta) {
        this.stats.incLong(this.processPutTimeId, delta);
    }

    public final void incWritePutResponseTime(long delta) {
        this.stats.incLong(this.writePutResponseTimeId, delta);
        this.stats.incInt(this.putResponsesId, 1);
    }

    public final void incReadDestroyRequestTime(long delta) {
        this.stats.incLong(this.readDestroyRequestTimeId, delta);
        this.stats.incInt(this.destroyRequestsId, 1);
    }

    public final void incProcessDestroyTime(long delta) {
        this.stats.incLong(this.processDestroyTimeId, delta);
    }

    public final void incWriteDestroyResponseTime(long delta) {
        this.stats.incLong(this.writeDestroyResponseTimeId, delta);
        this.stats.incInt(this.destroyResponsesId, 1);
    }

    public final void incReadInvalidateRequestTime(long delta) {
    }

    public final void incProcessInvalidateTime(long delta) {
    }

    public final void incWriteInvalidateResponseTime(long delta) {
    }

    public final void incReadSizeRequestTime(long delta) {
    }

    public final void incProcessSizeTime(long delta) {
    }

    public final void incWriteSizeResponseTime(long delta) {
    }

    public final void incReadQueryRequestTime(long delta) {
        this.stats.incLong(this.readQueryRequestTimeId, delta);
        this.stats.incInt(this.queryRequestsId, 1);
    }

    public final void incProcessQueryTime(long delta) {
        this.stats.incLong(this.processQueryTimeId, delta);
    }

    public final void incWriteQueryResponseTime(long delta) {
        this.stats.incLong(this.writeQueryResponseTimeId, delta);
        this.stats.incInt(this.queryResponsesId, 1);
    }

    public final void incProcessCreateCqTime(long delta) {
    }

    public final void incProcessCloseCqTime(long delta) {
    }

    public final void incProcessExecuteCqWithIRTime(long delta) {
    }

    public final void incProcessStopCqTime(long delta) {
    }

    public final void incProcessCloseClientCqsTime(long delta) {
    }

    public final void incProcessGetCqStatsTime(long delta) {
    }

    public final void incReadDestroyRegionRequestTime(long delta) {
        this.stats.incLong(this.readDestroyRegionRequestTimeId, delta);
        this.stats.incInt(this.destroyRegionRequestsId, 1);
    }

    public final void incProcessDestroyRegionTime(long delta) {
        this.stats.incLong(this.processDestroyRegionTimeId, delta);
    }

    public final void incWriteDestroyRegionResponseTime(long delta) {
        this.stats.incLong(this.writeDestroyRegionResponseTimeId, delta);
        this.stats.incInt(this.destroyRegionResponsesId, 1);
    }

    public final void incReadContainsKeyRequestTime(long delta) {
        this.stats.incLong(this.readContainsKeyRequestTimeId, delta);
        this.stats.incInt(this.containsKeyRequestsId, 1);
    }

    public final void incProcessContainsKeyTime(long delta) {
        this.stats.incLong(this.processContainsKeyTimeId, delta);
    }

    public final void incWriteContainsKeyResponseTime(long delta) {
        this.stats.incLong(this.writeContainsKeyResponseTimeId, delta);
        this.stats.incInt(this.containsKeyResponsesId, 1);
    }

    public final void incReadClearRegionRequestTime(long delta) {
        this.stats.incLong(this.readClearRegionRequestTimeId, delta);
        this.stats.incInt(this.clearRegionRequestsId, 1);
    }

    public final void incProcessClearRegionTime(long delta) {
        this.stats.incLong(this.processClearRegionTimeId, delta);
    }

    public final void incWriteClearRegionResponseTime(long delta) {
        this.stats.incLong(this.writeClearRegionResponseTimeId, delta);
        this.stats.incInt(this.clearRegionResponsesId, 1);
    }

    public final void incReadProcessBatchRequestTime(long delta) {
        this.stats.incLong(this.readProcessBatchRequestTimeId, delta);
        this.stats.incInt(this.processBatchRequestsId, 1);
    }

    public final void incWriteProcessBatchResponseTime(long delta) {
        this.stats.incLong(this.writeProcessBatchResponseTimeId, delta);
        this.stats.incInt(this.processBatchResponsesId, 1);
    }

    public final void incProcessBatchTime(long delta) {
        this.stats.incLong(this.processBatchTimeId, delta);
    }

    public final void incBatchSize(long size) {
        this.stats.incLong(this.batchSizeId, size);
    }

    public final void incReadClientNotificationRequestTime(long delta) {
        this.stats.incLong(this.readClientNotificationRequestTimeId, delta);
        this.stats.incInt(this.clientNotificationRequestsId, 1);
    }

    public final void incProcessClientNotificationTime(long delta) {
        this.stats.incLong(this.processClientNotificationTimeId, delta);
    }

    public final void incReadUpdateClientNotificationRequestTime(long delta) {
        this.stats.incLong(this.readUpdateClientNotificationRequestTimeId, delta);
        this.stats.incInt(this.updateClientNotificationRequestsId, 1);
    }

    public final void incProcessUpdateClientNotificationTime(long delta) {
        this.stats.incLong(this.processUpdateClientNotificationTimeId, delta);
    }

    public final void incReadCloseConnectionRequestTime(long delta) {
        this.stats.incLong(this.readCloseConnectionRequestTimeId, delta);
        this.stats.incInt(this.closeConnectionRequestsId, 1);
    }

    public final void incProcessCloseConnectionTime(long delta) {
        this.stats.incLong(this.processCloseConnectionTimeId, delta);
    }

    public final void incOutOfOrderBatchIds() {
        this.stats.incInt(this.outOfOrderBatchIdsId, 1);
    }

    @Override
    public final void incReceivedBytes(long v) {
        this.stats.incLong(this.receivedBytesId, v);
    }

    @Override
    public final void incSentBytes(long v) {
        this.stats.incLong(this.sentBytesId, v);
    }

    @Override
    public void incMessagesBeingReceived(int bytes) {
        this.stats.incInt(this.messagesBeingReceivedId, 1);
        if (bytes > 0) {
            this.stats.incLong(this.messageBytesBeingReceivedId, (long)bytes);
        }
    }

    @Override
    public void decMessagesBeingReceived(int bytes) {
        this.stats.incInt(this.messagesBeingReceivedId, -1);
        if (bytes > 0) {
            this.stats.incLong(this.messageBytesBeingReceivedId, (long)(-bytes));
        }
    }

    public final void incReadClientReadyRequestTime(long delta) {
        this.stats.incLong(this.readClientReadyRequestTimeId, delta);
        this.stats.incInt(this.clientReadyRequestsId, 1);
    }

    public final void incProcessClientReadyTime(long delta) {
        this.stats.incLong(this.processClientReadyTimeId, delta);
    }

    public final void incWriteClientReadyResponseTime(long delta) {
        this.stats.incLong(this.writeClientReadyResponseTimeId, delta);
        this.stats.incInt(this.clientReadyResponsesId, 1);
    }

    public final void setLoad(ServerLoad load) {
        this.stats.setDouble(this.connectionLoadId, (double)load.getConnectionLoad());
        this.stats.setDouble(this.queueLoadId, (double)load.getSubscriptionConnectionLoad());
        this.stats.setDouble(this.loadPerConnectionId, (double)load.getLoadPerConnection());
        this.stats.setDouble(this.loadPerQueueId, (double)load.getLoadPerSubscriptionConnection());
    }

    public final double getQueueLoad() {
        return this.stats.getDouble(this.queueLoadId);
    }

    public final double getLoadPerQueue() {
        return this.stats.getDouble(this.loadPerQueueId);
    }

    public final double getConnectionLoad() {
        return this.stats.getDouble(this.connectionLoadId);
    }

    public final double getLoadPerConnection() {
        return this.stats.getDouble(this.loadPerConnectionId);
    }

    public final int getProcessBatchRequests() {
        return this.stats.getInt(this.processBatchRequestsId);
    }

    public final void close() {
        this.stats.close();
    }

    public PoolStatHelper getCnxPoolHelper() {
        return new PoolStatHelper(){

            @Override
            public void startJob() {
                CacheServerStats.this.incConnectionThreads();
            }

            @Override
            public void endJob() {
                CacheServerStats.this.decConnectionThreads();
            }
        };
    }

    public Statistics getStats() {
        return this.stats;
    }
}

