/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class TrackedReference<T> {
    private final T ref;
    private final AtomicInteger uses;
    final ConcurrentHashMap<String, AtomicInteger> users;

    public static <T> void decrementAll(Iterable<TrackedReference<T>> refs) {
        for (TrackedReference<T> tr : refs) {
            tr.decrement();
        }
    }

    public TrackedReference(T ref) {
        this.ref = ref;
        this.uses = new AtomicInteger(0);
        this.users = new ConcurrentHashMap();
    }

    public final T get() {
        return this.ref;
    }

    public int uses() {
        return this.uses.get();
    }

    public boolean inUse() {
        return this.uses() > 0;
    }

    public T getAndIncrement() {
        this.increment();
        return this.ref;
    }

    public int increment() {
        return this.increment(null);
    }

    public int increment(String user) {
        int val = this.uses.incrementAndGet();
        if (user != null) {
            AtomicInteger counter = this.users.get(user);
            if (counter == null) {
                counter = new AtomicInteger();
                this.users.putIfAbsent(user, counter);
                counter = this.users.get(user);
            }
            counter.incrementAndGet();
        }
        assert (val >= 1);
        return val;
    }

    public int decrement() {
        return this.decrement(null);
    }

    public int decrement(String user) {
        AtomicInteger counter;
        int val = this.uses.decrementAndGet();
        assert (val >= 0);
        if (user != null && (counter = this.users.get(user)) != null) {
            counter.decrementAndGet();
        }
        return val;
    }

    public String toString() {
        if (this.users != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.ref.toString()).append(": ").append(this.uses());
            for (Map.Entry<String, AtomicInteger> user : this.users.entrySet()) {
                sb.append(" ").append(user.getKey()).append(":").append(user.getValue().intValue());
            }
            return sb.toString();
        }
        return this.uses() + ": " + this.ref.toString();
    }
}

