/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.DummyStatisticsFactory;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;

public class HFileStoreStatistics {
    private final Statistics stats;
    private final CacheOperation blockCache;

    public HFileStoreStatistics(String typeName, String name) {
        this(new DummyStatisticsFactory(), typeName, name);
    }

    public HFileStoreStatistics(StatisticsFactory factory, String typeName, String name) {
        StatisticsTypeFactory tf = StatisticsTypeFactoryImpl.singleton();
        StatisticDescriptor bcMisses = tf.createLongCounter("blockCacheMisses", "The total number of block cache misses", "misses");
        StatisticDescriptor bcHits = tf.createLongCounter("blockCacheHits", "The total number of block cache hits", "hits");
        StatisticDescriptor bcCached = tf.createLongGauge("blocksCached", "The current number of cached blocks", "blocks");
        StatisticDescriptor bcBytesCached = tf.createLongGauge("blockBytesCached", "The current number of bytes cached", "bytes");
        StatisticDescriptor bcBytesEvicted = tf.createLongCounter("blockBytesEvicted", "The total number of bytes cached", "bytes");
        StatisticsType type = tf.createType(typeName, "Statistics about structured I/O operations for a region", new StatisticDescriptor[]{bcMisses, bcHits, bcCached, bcBytesCached, bcBytesEvicted});
        this.blockCache = new CacheOperation(bcMisses.getId(), bcHits.getId(), bcCached.getId(), bcBytesCached.getId(), bcBytesEvicted.getId());
        this.stats = factory.createAtomicStatistics(type, name);
    }

    public void close() {
        this.stats.close();
    }

    public Statistics getStats() {
        return this.stats;
    }

    public CacheOperation getBlockCache() {
        return this.blockCache;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("blockCache = {").append(this.blockCache).append("}\n");
        return sb.toString();
    }

    public class CacheOperation {
        private final int missesId;
        private final int hitsId;
        private final int cachedId;
        private final int bytesCachedId;
        private final int bytesEvictedId;

        public CacheOperation(int missesId, int hitsId, int cachedId, int bytesCachedId, int bytesEvictedId) {
            this.missesId = missesId;
            this.hitsId = hitsId;
            this.cachedId = cachedId;
            this.bytesCachedId = bytesCachedId;
            this.bytesEvictedId = bytesEvictedId;
        }

        public void store(long bytes) {
            HFileStoreStatistics.this.stats.incLong(this.cachedId, 1L);
            HFileStoreStatistics.this.stats.incLong(this.bytesCachedId, bytes);
        }

        public void evict(long bytes) {
            HFileStoreStatistics.this.stats.incLong(this.cachedId, -1L);
            HFileStoreStatistics.this.stats.incLong(this.bytesCachedId, -bytes);
            HFileStoreStatistics.this.stats.incLong(this.bytesEvictedId, bytes);
        }

        public void hit() {
            HFileStoreStatistics.this.stats.incLong(this.hitsId, 1L);
        }

        public void miss() {
            HFileStoreStatistics.this.stats.incLong(this.missesId, 1L);
        }

        public long getMisses() {
            return HFileStoreStatistics.this.stats.getLong(this.missesId);
        }

        public long getHits() {
            return HFileStoreStatistics.this.stats.getLong(this.hitsId);
        }

        public long getCached() {
            return HFileStoreStatistics.this.stats.getLong(this.cachedId);
        }

        public long getBytesCached() {
            return HFileStoreStatistics.this.stats.getLong(this.bytesCachedId);
        }

        public long getBytesEvicted() {
            return HFileStoreStatistics.this.stats.getLong(this.bytesEvictedId);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("misses=").append(this.getMisses());
            sb.append(";hits=").append(this.getHits());
            sb.append(";cached=").append(this.getCached());
            sb.append(";bytesCached=").append(this.getBytesCached());
            sb.append(";bytesEvicted=").append(this.getBytesEvicted());
            return sb.toString();
        }
    }

    public class TimedOperation {
        protected final int countId;
        protected final int inProgressId;
        protected final int timeId;
        private final int errorsId;

        public TimedOperation(int count, int inProgress, int time, int errors) {
            this.countId = count;
            this.inProgressId = inProgress;
            this.timeId = time;
            this.errorsId = errors;
        }

        public long begin() {
            HFileStoreStatistics.this.stats.incLong(this.inProgressId, 1L);
            return DistributionStats.getStatTime();
        }

        public long end(long start) {
            HFileStoreStatistics.this.stats.incLong(this.inProgressId, -1L);
            HFileStoreStatistics.this.stats.incLong(this.countId, 1L);
            HFileStoreStatistics.this.stats.incLong(this.timeId, DistributionStats.getStatTime() - start);
            return DistributionStats.getStatTime();
        }

        public void error(long start) {
            this.end(start);
            HFileStoreStatistics.this.stats.incLong(this.errorsId, 1L);
        }

        public long getCount() {
            return HFileStoreStatistics.this.stats.getLong(this.countId);
        }

        public long getInProgress() {
            return HFileStoreStatistics.this.stats.getLong(this.inProgressId);
        }

        public long getTime() {
            return HFileStoreStatistics.this.stats.getLong(this.timeId);
        }

        public long getErrors() {
            return HFileStoreStatistics.this.stats.getLong(this.errorsId);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("count=").append(this.getCount());
            sb.append(";inProgress=").append(this.getInProgress());
            sb.append(";errors=").append(this.getErrors());
            sb.append(";time=").append(this.getTime());
            return sb.toString();
        }
    }
}

