/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence;

import com.gemstone.gemfire.internal.cache.persistence.BackupInspector;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;

class UnixBackupInspector
extends BackupInspector {
    private static final String INCREMENTAL_MARKER = "#Incremental backup";
    static final String RESTORE_FILE = "restore.sh";

    UnixBackupInspector(File backupDir) throws IOException {
        super(backupDir);
    }

    @Override
    public String getCopyFromForOplogFile(String oplogFileName) {
        String copyFrom = null;
        String line = (String)this.oplogLineMap.get(oplogFileName);
        if (null != line) {
            String[] parts = line.split("\\s");
            copyFrom = parts[2].substring(1, parts[2].length() - 1);
        }
        return copyFrom;
    }

    @Override
    public String getCopyToForOplogFile(String oplogFileName) {
        String copyTo = null;
        String line = (String)this.oplogLineMap.get(oplogFileName);
        if (null != line) {
            String[] parts = line.split("\\s");
            copyTo = parts[3].substring(1, parts[3].length() - 1);
        }
        return copyTo;
    }

    @Override
    protected void parseOplogLines(BufferedReader reader) throws IOException {
        String line = null;
        while (null != (line = reader.readLine())) {
            int beginIndex = line.lastIndexOf(File.separator) + 1;
            int endIndex = line.length() - 1;
            String oplogName = line.substring(beginIndex, endIndex);
            this.oplogFileNames.add(oplogName);
            this.oplogLineMap.put(oplogName, line);
        }
    }

    @Override
    protected String getIncrementalMarker() {
        return INCREMENTAL_MARKER;
    }

    @Override
    protected File getRestoreFile(File backupDir) {
        return new File(backupDir, RESTORE_FILE);
    }
}

