/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.partitioned.Bucket;
import com.gemstone.gemfire.internal.cache.persistence.PersistenceAdvisor;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class PrepareNewPersistentMemberMessage
extends HighPriorityDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private String regionPath;
    private PersistentMemberID oldId;
    private PersistentMemberID newId;
    private int processorId;

    public PrepareNewPersistentMemberMessage() {
    }

    public PrepareNewPersistentMemberMessage(String regionPath, PersistentMemberID oldId, PersistentMemberID newId, int processorId) {
        this.regionPath = regionPath;
        this.newId = newId;
        this.oldId = oldId;
        this.processorId = processorId;
    }

    public static void send(Set<InternalDistributedMember> members, DM dm, String regionPath, PersistentMemberID oldId, PersistentMemberID newId) throws ReplyException {
        ReplyProcessor21 processor = new ReplyProcessor21(dm, members);
        PrepareNewPersistentMemberMessage msg = new PrepareNewPersistentMemberMessage(regionPath, oldId, newId, processor.getProcessorId());
        msg.setRecipients(members);
        dm.putOutgoing(msg);
        processor.waitForRepliesUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
        Object state = null;
        Object myId = null;
        ReplyException exception = null;
        try {
            Bucket proxy;
            Cache cache = CacheFactory.getInstance(dm.getSystem());
            Region region = cache.getRegion(this.regionPath);
            PersistenceAdvisor persistenceAdvisor = null;
            if (region instanceof DistributedRegion) {
                persistenceAdvisor = ((DistributedRegion)region).getPersistenceAdvisor();
            } else if (region == null && (proxy = PartitionedRegionHelper.getProxyBucketRegion(GemFireCacheImpl.getInstance(), this.regionPath, false)) != null) {
                persistenceAdvisor = proxy.getPersistenceAdvisor();
            }
            if (persistenceAdvisor != null) {
                persistenceAdvisor.prepareNewMember(this.getSender(), this.oldId, this.newId);
            }
        }
        catch (RegionDestroyedException e) {
            logger.debug("<RegionDestroyed> {}", new Object[]{this});
        }
        catch (CancelException e) {
            logger.debug("<CancelException> {}", new Object[]{this});
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            exception = new ReplyException(t);
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
            ReplyMessage replyMsg = new ReplyMessage();
            replyMsg.setRecipient(this.getSender());
            replyMsg.setProcessorId(this.processorId);
            if (exception != null) {
                replyMsg.setException(exception);
            }
            dm.putOutgoing(replyMsg);
        }
    }

    @Override
    public int getDSFID() {
        return 2104;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.regionPath = DataSerializer.readString(in);
        this.processorId = in.readInt();
        boolean hasOldId = in.readBoolean();
        if (hasOldId) {
            this.oldId = new PersistentMemberID();
            InternalDataSerializer.invokeFromData(this.oldId, in);
        }
        this.newId = new PersistentMemberID();
        InternalDataSerializer.invokeFromData(this.newId, in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.regionPath, out);
        out.writeInt(this.processorId);
        out.writeBoolean(this.oldId != null);
        if (this.oldId != null) {
            InternalDataSerializer.invokeToData(this.oldId, out);
        }
        InternalDataSerializer.invokeToData(this.newId, out);
    }
}

