/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.UnsupportedVersionException;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.CountingDataInputStream;
import com.gemstone.gemfire.internal.cache.DiskInitFile;
import com.gemstone.gemfire.internal.cache.Oplog;
import com.gemstone.gemfire.internal.cache.persistence.DiskInitFileInterpreter;
import com.gemstone.gemfire.internal.cache.persistence.DiskStoreID;
import com.gemstone.gemfire.internal.cache.persistence.PRPersistentConfig;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberPattern;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionHolder;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;

public class DiskInitFileParser {
    private static final Logger logger = LogService.getLogger();
    private final CountingDataInputStream dis;
    private DiskInitFileInterpreter interpreter;
    private transient boolean gotEOF;

    public DiskInitFileParser(CountingDataInputStream dis, DiskInitFileInterpreter interpreter) {
        this.dis = dis;
        this.interpreter = logger.isDebugEnabled() ? DiskInitFileParser.createPrintingInterpreter(interpreter) : interpreter;
    }

    public DiskStoreID parse() throws IOException, ClassNotFoundException {
        Version gfversion = Version.GFE_662;
        DiskStoreID result = null;
        boolean endOfFile = false;
        while (!endOfFile) {
            if (this.dis.atEndOfFile()) {
                endOfFile = true;
                break;
            }
            byte opCode = this.dis.readByte();
            if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                logger.trace(LogMarker.PERSIST_RECOVERY, "DiskInitFile opcode={}", new Object[]{opCode});
            }
            switch (opCode) {
                case 0: {
                    endOfFile = true;
                    this.gotEOF = true;
                    break;
                }
                case 57: {
                    int id = this.dis.readInt();
                    String cn = DiskInitFileParser.readClassName(this.dis);
                    String icn = DiskInitFileParser.readClassName(this.dis);
                    this.readEndOfRecord(this.dis);
                    this.interpreter.cmnInstantiatorId(id, cn, icn);
                    break;
                }
                case 58: {
                    Class<?> dsc = DiskInitFileParser.readClass(this.dis);
                    this.readEndOfRecord(this.dis);
                    this.interpreter.cmnDataSerializerId(dsc);
                    break;
                }
                case 59: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    PersistentMemberID pmid = this.readPMID(this.dis, gfversion);
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_ONLINE_MEMBER_ID drId={} omid={}", new Object[]{drId, pmid});
                    }
                    this.interpreter.cmnOnlineMemberId(drId, pmid);
                    break;
                }
                case 60: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    PersistentMemberID pmid = this.readPMID(this.dis, gfversion);
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_OFFLINE_MEMBER_ID drId={} pmid={}", new Object[]{drId, pmid});
                    }
                    this.interpreter.cmnOfflineMemberId(drId, pmid);
                    break;
                }
                case 61: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    PersistentMemberID pmid = this.readPMID(this.dis, gfversion);
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_RM_MEMBER_ID drId={} pmid={}", new Object[]{drId, pmid});
                    }
                    this.interpreter.cmnRmMemberId(drId, pmid);
                    break;
                }
                case 62: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    PersistentMemberID pmid = this.readPMID(this.dis, gfversion);
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_MY_MEMBER_INITIALIZING_ID drId={} pmid={}", new Object[]{drId, pmid});
                    }
                    this.interpreter.cmnAddMyInitializingPMID(drId, pmid);
                    break;
                }
                case 63: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_MY_MEMBER_INITIALIZED_ID drId={}", new Object[]{drId});
                    }
                    this.interpreter.cmnMarkInitialized(drId);
                    break;
                }
                case 64: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    String regName = this.dis.readUTF();
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_CREATE_REGION_ID drId= name={}", new Object[]{drId, regName});
                    }
                    this.interpreter.cmnCreateRegion(drId, regName);
                    break;
                }
                case 65: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_BEGIN_DESTROY_REGION_ID drId={}", new Object[]{drId});
                    }
                    this.interpreter.cmnBeginDestroyRegion(drId);
                    break;
                }
                case 67: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_END_DESTROY_REGION_ID drId={}", new Object[]{drId});
                    }
                    this.interpreter.cmnEndDestroyRegion(drId);
                    break;
                }
                case 68: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_BEGIN_PARTIAL_DESTROY_REGION_ID drId={}", new Object[]{drId});
                    }
                    this.interpreter.cmnBeginPartialDestroyRegion(drId);
                    break;
                }
                case 69: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_END_PARTIAL_DESTROY_REGION_ID drId={}", new Object[]{drId});
                    }
                    this.interpreter.cmnEndPartialDestroyRegion(drId);
                    break;
                }
                case 66: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    long clearOplogEntryId = this.dis.readLong();
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_CLEAR_REGION_ID drId={} oplogEntryId={}", new Object[]{drId, clearOplogEntryId});
                    }
                    this.interpreter.cmnClearRegion(drId, clearOplogEntryId);
                    break;
                }
                case 83: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    int size = this.dis.readInt();
                    ConcurrentHashMap<DiskStoreID, RegionVersionHolder<DiskStoreID>> memberToVersion = new ConcurrentHashMap<DiskStoreID, RegionVersionHolder<DiskStoreID>>(size);
                    for (int i = 0; i < size; ++i) {
                        DiskStoreID id = new DiskStoreID();
                        InternalDataSerializer.invokeFromData(id, this.dis);
                        RegionVersionHolder holder = new RegionVersionHolder(this.dis);
                        memberToVersion.put(id, holder);
                    }
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_CLEAR_REGION_WITH_RVV_ID drId={} memberToVersion={}", new Object[]{drId, memberToVersion});
                    }
                    this.interpreter.cmnClearRegion(drId, memberToVersion);
                    break;
                }
                case 70: {
                    long oplogId = this.dis.readLong();
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_CRF_CREATE oplogId={}", new Object[]{oplogId});
                    }
                    this.interpreter.cmnCrfCreate(oplogId);
                    break;
                }
                case 71: {
                    long oplogId = this.dis.readLong();
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_DRF_CREATE oplogId={}", new Object[]{oplogId});
                    }
                    this.interpreter.cmnDrfCreate(oplogId);
                    break;
                }
                case 77: {
                    long oplogId = this.dis.readLong();
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_KRF_CREATE oplogId={}", new Object[]{oplogId});
                    }
                    this.interpreter.cmnKrfCreate(oplogId);
                    break;
                }
                case 72: {
                    long oplogId = this.dis.readLong();
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_CRF_DELETE oplogId={}", new Object[]{oplogId});
                    }
                    this.interpreter.cmnCrfDelete(oplogId);
                    break;
                }
                case 73: {
                    long oplogId = this.dis.readLong();
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_DRF_DELETE oplogId={}", new Object[]{oplogId});
                    }
                    this.interpreter.cmnDrfDelete(oplogId);
                    break;
                }
                case 74: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    byte lruAlgorithm = this.dis.readByte();
                    byte lruAction = this.dis.readByte();
                    int lruLimit = this.dis.readInt();
                    int concurrencyLevel = this.dis.readInt();
                    int initialCapacity = this.dis.readInt();
                    float loadFactor = this.dis.readFloat();
                    boolean statisticsEnabled = this.dis.readBoolean();
                    boolean isBucket = this.dis.readBoolean();
                    EnumSet<DiskInitFile.DiskRegionFlag> flags = EnumSet.noneOf(DiskInitFile.DiskRegionFlag.class);
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_REGION_CONFIG_ID drId={}", new Object[]{drId});
                    }
                    this.interpreter.cmnRegionConfig(drId, lruAlgorithm, lruAction, lruLimit, concurrencyLevel, initialCapacity, loadFactor, statisticsEnabled, isBucket, flags, "NO_PARTITION", -1, null, false);
                    break;
                }
                case 76: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    byte lruAlgorithm = this.dis.readByte();
                    byte lruAction = this.dis.readByte();
                    int lruLimit = this.dis.readInt();
                    int concurrencyLevel = this.dis.readInt();
                    int initialCapacity = this.dis.readInt();
                    float loadFactor = this.dis.readFloat();
                    boolean statisticsEnabled = this.dis.readBoolean();
                    boolean isBucket = this.dis.readBoolean();
                    EnumSet<DiskInitFile.DiskRegionFlag> flags = EnumSet.noneOf(DiskInitFile.DiskRegionFlag.class);
                    String partitionName = this.dis.readUTF();
                    int startingBucketId = this.dis.readInt();
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_REGION_CONFIG_ID drId={}", new Object[]{drId});
                    }
                    this.interpreter.cmnRegionConfig(drId, lruAlgorithm, lruAction, lruLimit, concurrencyLevel, initialCapacity, loadFactor, statisticsEnabled, isBucket, flags, partitionName, startingBucketId, null, false);
                    break;
                }
                case 88: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    byte lruAlgorithm = this.dis.readByte();
                    byte lruAction = this.dis.readByte();
                    int lruLimit = this.dis.readInt();
                    int concurrencyLevel = this.dis.readInt();
                    int initialCapacity = this.dis.readInt();
                    float loadFactor = this.dis.readFloat();
                    boolean statisticsEnabled = this.dis.readBoolean();
                    boolean isBucket = this.dis.readBoolean();
                    EnumSet<DiskInitFile.DiskRegionFlag> flags = EnumSet.noneOf(DiskInitFile.DiskRegionFlag.class);
                    String partitionName = this.dis.readUTF();
                    int startingBucketId = this.dis.readInt();
                    String compressorClassName = this.dis.readUTF();
                    if ("".equals(compressorClassName)) {
                        compressorClassName = null;
                    }
                    if (this.dis.readBoolean()) {
                        flags.add(DiskInitFile.DiskRegionFlag.IS_WITH_VERSIONING);
                    }
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_REGION_CONFIG_ID drId={}", new Object[]{drId});
                    }
                    this.interpreter.cmnRegionConfig(drId, lruAlgorithm, lruAction, lruLimit, concurrencyLevel, initialCapacity, loadFactor, statisticsEnabled, isBucket, flags, partitionName, startingBucketId, compressorClassName, false);
                    break;
                }
                case 90: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    byte lruAlgorithm = this.dis.readByte();
                    byte lruAction = this.dis.readByte();
                    int lruLimit = this.dis.readInt();
                    int concurrencyLevel = this.dis.readInt();
                    int initialCapacity = this.dis.readInt();
                    float loadFactor = this.dis.readFloat();
                    boolean statisticsEnabled = this.dis.readBoolean();
                    boolean isBucket = this.dis.readBoolean();
                    EnumSet<DiskInitFile.DiskRegionFlag> flags = EnumSet.noneOf(DiskInitFile.DiskRegionFlag.class);
                    String partitionName = this.dis.readUTF();
                    int startingBucketId = this.dis.readInt();
                    String compressorClassName = this.dis.readUTF();
                    if ("".equals(compressorClassName)) {
                        compressorClassName = null;
                    }
                    if (this.dis.readBoolean()) {
                        flags.add(DiskInitFile.DiskRegionFlag.IS_WITH_VERSIONING);
                    }
                    boolean offHeap = this.dis.readBoolean();
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_REGION_CONFIG_ID drId={}", new Object[]{drId});
                    }
                    this.interpreter.cmnRegionConfig(drId, lruAlgorithm, lruAction, lruLimit, concurrencyLevel, initialCapacity, loadFactor, statisticsEnabled, isBucket, flags, partitionName, startingBucketId, compressorClassName, offHeap);
                    break;
                }
                case 75: {
                    long drId = DiskInitFileParser.readDiskRegionID(this.dis);
                    PersistentMemberID pmid = this.readPMID(this.dis, gfversion);
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_OFFLINE_AND_EQUAL_MEMBER_ID drId={} pmid={}", new Object[]{drId, pmid});
                    }
                    this.interpreter.cmdOfflineAndEqualMemberId(drId, pmid);
                    break;
                }
                case 56: {
                    long leastSigBits = this.dis.readLong();
                    long mostSigBits = this.dis.readLong();
                    this.readEndOfRecord(this.dis);
                    result = new DiskStoreID(mostSigBits, leastSigBits);
                    this.interpreter.cmnDiskStoreID(result);
                    break;
                }
                case 89: {
                    this.readOplogMagicSeqRecord(this.dis, Oplog.OPLOG_TYPE.IF);
                    break;
                }
                case 78: {
                    String name = this.dis.readUTF();
                    int numBuckets = this.dis.readInt();
                    String colocatedWith = this.dis.readUTF();
                    this.readEndOfRecord(this.dis);
                    PRPersistentConfig config = new PRPersistentConfig(numBuckets, colocatedWith);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_PR_CREATE name={}, config={}", new Object[]{name, config});
                    }
                    this.interpreter.cmnPRCreate(name, config);
                    break;
                }
                case 82: {
                    short ver = Version.readOrdinal(this.dis);
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_GEMFIRE_VERSION version={}", new Object[]{ver});
                    }
                    try {
                        gfversion = Version.fromOrdinal(ver, false);
                    }
                    catch (UnsupportedVersionException e) {
                        throw new DiskAccessException(LocalizedStrings.Oplog_UNEXPECTED_PRODUCT_VERSION_0.toLocalizedString(ver), (Throwable)e, this.interpreter.getNameForError());
                    }
                    this.interpreter.cmnGemfireVersion(gfversion);
                    break;
                }
                case 79: {
                    String name = this.dis.readUTF();
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_PR_DESTROY name={}", new Object[]{name});
                    }
                    this.interpreter.cmnPRDestroy(name);
                    break;
                }
                case 80: {
                    int id = this.dis.readInt();
                    Object object = DataSerializer.readObject(this.dis);
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_ADD_CANONICAL_MEMBER_ID id={} name={}", new Object[]{id, object});
                    }
                    this.interpreter.cmnAddCanonicalMemberId(id, object);
                    break;
                }
                case 81: {
                    PersistentMemberPattern pattern = new PersistentMemberPattern();
                    InternalDataSerializer.invokeFromData(pattern, this.dis);
                    this.readEndOfRecord(this.dis);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "IFREC_REVOKE_DISK_STORE_ID id={}" + pattern);
                    }
                    this.interpreter.cmnRevokeDiskStoreId(pattern);
                    break;
                }
                default: {
                    throw new DiskAccessException(LocalizedStrings.DiskInitFile_UNKNOWN_OPCODE_0_FOUND.toLocalizedString(opCode), this.interpreter.getNameForError());
                }
            }
            if (!this.interpreter.isClosing()) continue;
            break;
        }
        return result;
    }

    private void readOplogMagicSeqRecord(DataInput dis, Oplog.OPLOG_TYPE type) throws IOException {
        byte[] seq = new byte[Oplog.OPLOG_TYPE.getLen()];
        dis.readFully(seq);
        for (int i = 0; i < Oplog.OPLOG_TYPE.getLen(); ++i) {
            if (seq[i] == type.getBytes()[i]) continue;
            if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                logger.trace(LogMarker.PERSIST_RECOVERY, "oplog magic code mismatched at byte:{}, value:{}", new Object[]{i + 1, seq[i]});
            }
            throw new DiskAccessException("Invalid oplog (" + type.name() + ") file provided.", this.interpreter.getNameForError());
        }
        if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < Oplog.OPLOG_TYPE.getLen(); ++i) {
                sb.append(" " + seq[i]);
            }
            logger.trace(LogMarker.PERSIST_RECOVERY, "oplog magic code: {}", new Object[]{sb});
        }
        this.readEndOfRecord(dis);
    }

    private static Class<?> readClass(DataInput di) throws IOException {
        int len = di.readInt();
        byte[] bytes = new byte[len];
        di.readFully(bytes);
        String className = new String(bytes);
        Class<?> result = null;
        try {
            result = InternalDataSerializer.getCachedClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }

    private static String readClassName(DataInput di) throws IOException {
        int len = di.readInt();
        byte[] bytes = new byte[len];
        di.readFully(bytes);
        return new String(bytes);
    }

    static long readDiskRegionID(CountingDataInputStream dis) throws IOException {
        int bytesToRead = dis.readUnsignedByte();
        if ((long)bytesToRead <= 8L && (long)bytesToRead >= 1L) {
            long result = dis.readByte();
            --bytesToRead;
            while (bytesToRead > 0) {
                result <<= 8;
                result |= (long)dis.readUnsignedByte();
                --bytesToRead;
            }
            return result;
        }
        return bytesToRead;
    }

    private void readEndOfRecord(DataInput di) throws IOException {
        byte b = di.readByte();
        if (b != 21) {
            if (b == 0) {
                throw new EOFException("found partial last record");
            }
            throw new IllegalStateException("expected end of record (byte==21) or zero but found " + b);
        }
    }

    private PersistentMemberID readPMID(CountingDataInputStream dis, Version gfversion) throws IOException, ClassNotFoundException {
        int len = dis.readInt();
        byte[] buf = new byte[len];
        dis.readFully(buf);
        return this.bytesToPMID(buf, gfversion);
    }

    private PersistentMemberID bytesToPMID(byte[] bytes, Version gfversion) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bais);
        PersistentMemberID result = new PersistentMemberID();
        if (Version.GFE_70.compareTo(gfversion) > 0) {
            result.fromData662(dis);
        } else {
            InternalDataSerializer.invokeFromData(result, dis);
        }
        return result;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        if (args.length != 1) {
            System.err.println("Usage: parse filename");
            System.exit(1);
        }
        DiskInitFileParser.dump(new File(args[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(File file) throws IOException, ClassNotFoundException {
        FileInputStream is = new FileInputStream(file);
        CountingDataInputStream dis = new CountingDataInputStream(is, file.length());
        try {
            DiskInitFileInterpreter interpreter = DiskInitFileParser.createPrintingInterpreter(null);
            DiskInitFileParser parser = new DiskInitFileParser(dis, interpreter);
            parser.parse();
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private static DiskInitFileInterpreter createPrintingInterpreter(DiskInitFileInterpreter wrapped) {
        DiskInitFileInterpreter interpreter = (DiskInitFileInterpreter)Proxy.newProxyInstance(DiskInitFileInterpreter.class.getClassLoader(), new Class[]{DiskInitFileInterpreter.class}, (InvocationHandler)new PrintingInterpreter(wrapped));
        return interpreter;
    }

    public boolean gotEOF() {
        return this.gotEOF;
    }

    private static class PrintingInterpreter
    implements InvocationHandler {
        private final DiskInitFileInterpreter delegate;

        public PrintingInterpreter(DiskInitFileInterpreter wrapped) {
            this.delegate = wrapped;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("isClosing")) {
                if (this.delegate == null) {
                    return Boolean.FALSE;
                }
                return this.delegate.isClosing();
            }
            Boolean result = null;
            if (method.getReturnType().equals(Boolean.TYPE)) {
                result = Boolean.TRUE;
            }
            StringBuilder out = new StringBuilder();
            out.append(method.getName()).append("(");
            for (Object arg : args) {
                out.append(arg);
                out.append(",");
            }
            out.replace(out.length() - 1, out.length(), ")");
            System.out.println(out.toString());
            if (this.delegate == null) {
                return result;
            }
            return method.invoke((Object)this.delegate, args);
        }
    }
}

