/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned.rebalance;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.BucketOperator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class ParallelBucketOperator
implements BucketOperator {
    private final BucketOperator delegate;
    private final ExecutorService executor;
    private final Semaphore operationSemaphore;
    private final int maxParallelOperations;
    private final ConcurrentLinkedQueue<BucketOperator.Completion> pendingSuccess = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<BucketOperator.Completion> pendingFailure = new ConcurrentLinkedQueue();

    public ParallelBucketOperator(int maxParallelOperations, ExecutorService executor, BucketOperator operator) {
        this.maxParallelOperations = maxParallelOperations;
        this.operationSemaphore = new Semaphore(maxParallelOperations);
        this.delegate = operator;
        this.executor = executor;
    }

    @Override
    public void createRedundantBucket(final InternalDistributedMember targetMember, final int bucketId, final Map<String, Long> colocatedRegionBytes, final BucketOperator.Completion completion) {
        this.drainCompletions();
        this.operationSemaphore.acquireUninterruptibly();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ParallelBucketOperator.this.delegate.createRedundantBucket(targetMember, bucketId, colocatedRegionBytes, new BucketOperator.Completion(){

                        @Override
                        public void onSuccess() {
                            ParallelBucketOperator.this.pendingSuccess.add(completion);
                        }

                        @Override
                        public void onFailure() {
                            ParallelBucketOperator.this.pendingFailure.add(completion);
                        }
                    });
                }
                catch (CancelException cancelException) {
                }
                catch (RegionDestroyedException regionDestroyedException) {
                }
                finally {
                    ParallelBucketOperator.this.operationSemaphore.release();
                }
            }
        });
    }

    @Override
    public boolean removeBucket(InternalDistributedMember memberId, int id, Map<String, Long> colocatedRegionSizes) {
        return this.delegate.removeBucket(memberId, id, colocatedRegionSizes);
    }

    @Override
    public boolean moveBucket(InternalDistributedMember sourceMember, InternalDistributedMember targetMember, int bucketId, Map<String, Long> colocatedRegionBytes) {
        return this.delegate.moveBucket(sourceMember, targetMember, bucketId, colocatedRegionBytes);
    }

    @Override
    public boolean movePrimary(InternalDistributedMember source, InternalDistributedMember target, int bucketId) {
        return this.delegate.movePrimary(source, target, bucketId);
    }

    public void drainCompletions() {
        BucketOperator.Completion next = null;
        while ((next = this.pendingSuccess.poll()) != null) {
            next.onSuccess();
        }
        while ((next = this.pendingFailure.poll()) != null) {
            next.onFailure();
        }
    }

    @Override
    public void waitForOperations() {
        boolean interrupted = false;
        while (!this.executor.isShutdown()) {
            try {
                if (!this.operationSemaphore.tryAcquire(this.maxParallelOperations, 1L, TimeUnit.SECONDS)) continue;
                this.operationSemaphore.release(this.maxParallelOperations);
                this.drainCompletions();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
    }
}

