/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.LowMemoryException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.ProfileListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.BucketAdvisor;
import com.gemstone.gemfire.internal.cache.BucketPersistenceAdvisor;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.BucketServerLocation66;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.FixedPartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.Node;
import com.gemstone.gemfire.internal.cache.PRHARedundancyProvider;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionStats;
import com.gemstone.gemfire.internal.cache.ProxyBucketRegion;
import com.gemstone.gemfire.internal.cache.control.MemoryThresholds;
import com.gemstone.gemfire.internal.cache.control.ResourceAdvisor;
import com.gemstone.gemfire.internal.cache.partitioned.Bucket;
import com.gemstone.gemfire.internal.cache.persistence.PersistentStateListener;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class RegionAdvisor
extends CacheDistributionAdvisor {
    private static final Logger logger = LogService.getLogger();
    public static final short VOLUNTEERING_THREAD_COUNT = Integer.getInteger("gemfire.RegionAdvisor.volunteeringThreadCount", 1).shortValue();
    private final Queue volunteeringQueue = new ConcurrentLinkedQueue();
    private final Semaphore volunteeringSemaphore = new Semaphore(VOLUNTEERING_THREAD_COUNT);
    private volatile int lastActiveProfiles = 0;
    private volatile int numDataStores = 0;
    protected volatile ProxyBucketRegion[] buckets;
    private Queue preInitQueue;
    private final Object preInitQueueMonitor = new Object();
    private final boolean[] lowRedundancyFlags = new boolean[2];
    private ConcurrentHashMap<Integer, Set<BucketAdvisor.ServerBucketProfile>> clientBucketProfilesMap;

    public boolean[] getLowRedundancyFlags() {
        return this.lowRedundancyFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionAdvisor(PartitionedRegion region) {
        super(region);
        Object object = this.preInitQueueMonitor;
        synchronized (object) {
            this.preInitQueue = new ConcurrentLinkedQueue();
        }
        this.clientBucketProfilesMap = new ConcurrentHashMap();
    }

    public static RegionAdvisor createRegionAdvisor(PartitionedRegion region) {
        RegionAdvisor advisor = new RegionAdvisor(region);
        advisor.initialize();
        return advisor;
    }

    public PartitionedRegionStats getPartitionedRegionStats() {
        return this.getPartitionedRegion().getPrStats();
    }

    public synchronized void initializeRegionAdvisor() {
        if (this.buckets != null) {
            return;
        }
        PartitionedRegion p = this.getPartitionedRegion();
        int numBuckets = p.getAttributes().getPartitionAttributes().getTotalNumBuckets();
        ProxyBucketRegion[] bucs = new ProxyBucketRegion[numBuckets];
        InternalRegionArguments args = new InternalRegionArguments();
        args.setPartitionedRegionAdvisor(this);
        for (int i = 0; i < bucs.length; ++i) {
            bucs[i] = new ProxyBucketRegion(i, p, args);
            bucs[i].initialize();
        }
        this.buckets = bucs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processProfilesQueuedDuringInitialization() {
        var1_1 = this.preInitQueueMonitor;
        synchronized (var1_1) {
            pi = this.preInitQueue.iterator();
            finishedInitQueue = false;
lbl6:
            // 3 sources

            try {
                while (pi.hasNext()) {
                    block17: {
                        o = pi.next();
                        qbp = (QueuedBucketProfile)o;
                        if (!qbp.isRemoval) {
                            if (RegionAdvisor.logger.isTraceEnabled(LogMarker.DA)) {
                                RegionAdvisor.logger.trace(LogMarker.DA, "applying queued profile addition for bucket {}", new Object[]{qbp.bucketId});
                            }
                            this.getBucket(qbp.bucketId).getBucketAdvisor().putProfile(qbp.bucketProfile);
                            continue;
                        }
                        if (!qbp.memberDeparted && this.getDistributionManager().isCurrentMember(qbp.memberId)) break block17;
                        if (qbp.memberDeparted) {
                            crashed = qbp.crashed;
                        } else {
                            v0 = crashed = this.stillInView(qbp.memberId) == false;
                        }
                        if (RegionAdvisor.logger.isTraceEnabled(LogMarker.DA)) {
                            RegionAdvisor.logger.trace(LogMarker.DA, "applying queued member departure for all buckets for {}", new Object[]{qbp.memberId});
                        }
                        for (i = 0; i < this.buckets.length; ++i) {
                            ba = this.buckets[i].getBucketAdvisor();
                            ba.removeId(qbp.memberId, crashed, qbp.destroyed, qbp.fromMembershipListener);
                        }
                        ** GOTO lbl6
                    }
                    if (RegionAdvisor.logger.isTraceEnabled(LogMarker.DA)) {
                        RegionAdvisor.logger.trace(LogMarker.DA, "applying queued profile removal for all buckets for {}", new Object[]{qbp.memberId});
                    }
                    for (i = 0; i < this.buckets.length; ++i) {
                        ba = this.buckets[i].getBucketAdvisor();
                        serial = qbp.serials[i];
                        if (serial == -1) continue;
                        ba.removeIdWithSerial(qbp.memberId, serial, qbp.destroyed);
                    }
                    ** GOTO lbl6
                }
                finishedInitQueue = true;
            }
            finally {
                this.preInitQueue = null;
                this.preInitQueueMonitor.notifyAll();
                if (!finishedInitQueue && this.getAdvisee().getCancelCriterion().cancelInProgress() == null) {
                    RegionAdvisor.logger.error((Message)LocalizedMessage.create(LocalizedStrings.RegionAdvisor_FAILED_TO_PROCESS_ALL_QUEUED_BUCKETPROFILES_FOR_0, this.getAdvisee()));
                }
            }
        }
    }

    @Override
    protected DistributionAdvisor.Profile instantiateProfile(InternalDistributedMember memberId, int version) {
        return new PartitionProfile(memberId, version);
    }

    public Queue getVolunteeringQueue() {
        return this.volunteeringQueue;
    }

    public Semaphore getVolunteeringSemaphore() {
        return this.volunteeringSemaphore;
    }

    public Map<Integer, List<BucketServerLocation66>> getAllClientBucketProfiles() {
        HashMap<Integer, List<BucketServerLocation66>> bucketToServerLocations = new HashMap<Integer, List<BucketServerLocation66>>();
        for (Integer bucketId : this.clientBucketProfilesMap.keySet()) {
            ArrayList<BucketServerLocation66> clientBucketProfiles = new ArrayList<BucketServerLocation66>();
            for (BucketAdvisor.BucketProfile bucketProfile : this.clientBucketProfilesMap.get(bucketId)) {
                if (!bucketProfile.isHosting) continue;
                BucketAdvisor.ServerBucketProfile cProfile = (BucketAdvisor.ServerBucketProfile)bucketProfile;
                Set<BucketServerLocation66> bucketServerLocations = cProfile.getBucketServerLocations();
                clientBucketProfiles.addAll(bucketServerLocations);
            }
            bucketToServerLocations.put(bucketId, clientBucketProfiles);
        }
        if (this.getPartitionedRegion().isDataStore()) {
            for (Integer bucketId : this.getPartitionedRegion().getDataStore().getAllLocalBucketIds()) {
                BucketAdvisor.BucketProfile profile = this.getBucketAdvisor(bucketId).getLocalProfile();
                if (logger.isDebugEnabled()) {
                    logger.debug("The local profile is : {}", new Object[]{profile});
                }
                if (profile == null) continue;
                ArrayList<BucketServerLocation66> clientBucketProfiles = (ArrayList<BucketServerLocation66>)bucketToServerLocations.get(bucketId);
                if (clientBucketProfiles == null) {
                    clientBucketProfiles = new ArrayList<BucketServerLocation66>();
                    bucketToServerLocations.put(bucketId, clientBucketProfiles);
                }
                if (!(profile instanceof BucketAdvisor.ServerBucketProfile) || !profile.isHosting) continue;
                BucketAdvisor.ServerBucketProfile serverBucketProfile = (BucketAdvisor.ServerBucketProfile)profile;
                Set<BucketServerLocation66> bucketServerLocations = serverBucketProfile.getBucketServerLocations();
                clientBucketProfiles.removeAll(bucketServerLocations);
                clientBucketProfiles.addAll(bucketServerLocations);
            }
        }
        return bucketToServerLocations;
    }

    public ConcurrentHashMap<Integer, Set<BucketAdvisor.ServerBucketProfile>> getAllClientBucketProfilesTest() {
        ConcurrentHashMap<Integer, Set<BucketAdvisor.ServerBucketProfile>> map = new ConcurrentHashMap<Integer, Set<BucketAdvisor.ServerBucketProfile>>();
        Map<Integer, List<BucketServerLocation66>> testMap = this.getAllClientBucketProfiles();
        for (Integer bucketId : testMap.keySet()) {
            Set<BucketAdvisor.ServerBucketProfile> parr = this.clientBucketProfilesMap.get(bucketId);
            map.put(bucketId, parr);
        }
        if (this.getPartitionedRegion().isDataStore()) {
            for (Integer bucketId : this.getPartitionedRegion().getDataStore().getAllLocalBucketIds()) {
                BucketAdvisor.BucketProfile profile = this.getBucketAdvisor(bucketId).getLocalProfile();
                if (!(profile instanceof BucketAdvisor.ServerBucketProfile) || !profile.isHosting) continue;
                map.get(bucketId).add((BucketAdvisor.ServerBucketProfile)profile);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("This maps is sksk {} and size is {}", new Object[]{map, ((ConcurrentHashMap.CollectionView)((Object)map.keySet())).size()});
        }
        return map;
    }

    public Set<BucketAdvisor.ServerBucketProfile> getClientBucketProfiles(Integer bucketId) {
        return this.clientBucketProfilesMap.get(bucketId);
    }

    public void setClientBucketProfiles(Integer bucketId, Set<BucketAdvisor.ServerBucketProfile> oldProfiles) {
        this.clientBucketProfilesMap.put(bucketId, oldProfiles);
    }

    public List closeBucketAdvisors() {
        ArrayList<Integer> primariesHeld = Collections.EMPTY_LIST;
        if (this.buckets != null) {
            for (int i = 0; i < this.buckets.length; ++i) {
                ProxyBucketRegion pbr = this.buckets[i];
                if (pbr.isPrimary()) {
                    if (primariesHeld == Collections.EMPTY_LIST) {
                        primariesHeld = new ArrayList<Integer>();
                    }
                    primariesHeld.add(i);
                }
                pbr.close();
            }
        }
        return primariesHeld;
    }

    @Override
    public void close() {
        super.close();
        if (this.buckets != null) {
            for (int i = 0; i < this.buckets.length; ++i) {
                this.buckets[i].close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeId(DistributionAdvisor.ProfileId memberId, boolean crashed, boolean regionDestroyed, boolean fromMembershipListener) {
        boolean removeBuckets = true;
        Object object = this.preInitQueueMonitor;
        synchronized (object) {
            if (this.preInitQueue != null) {
                assert (memberId instanceof InternalDistributedMember);
                QueuedBucketProfile qbf = new QueuedBucketProfile((InternalDistributedMember)memberId, crashed, regionDestroyed, fromMembershipListener);
                this.preInitQueue.add(qbf);
                removeBuckets = false;
            }
        }
        if (removeBuckets && this.buckets != null) {
            for (int i = 0; i < this.buckets.length; ++i) {
                boolean removed;
                ProxyBucketRegion pbr = this.buckets[i];
                BucketAdvisor pbra = pbr.getBucketAdvisor();
                boolean shouldSync = false;
                DistributionAdvisor.Profile profile = null;
                InternalDistributedMember mbr = null;
                if (memberId instanceof InternalDistributedMember && (shouldSync = pbra.shouldSyncForCrashedMember(mbr = (InternalDistributedMember)memberId))) {
                    profile = pbr.getBucketAdvisor().getProfile(memberId);
                }
                if (!(removed = pbr.getBucketAdvisor().removeId(memberId, crashed, regionDestroyed, fromMembershipListener)) || !shouldSync) continue;
                pbra.syncForCrashedMember(mbr, profile);
            }
        }
        boolean removedId = false;
        removedId = super.removeId(memberId, crashed, regionDestroyed, fromMembershipListener);
        if (logger.isTraceEnabled(LogMarker.DA)) {
            logger.trace(LogMarker.DA, "RegionAdvisor#removeId: removing member from region {}: {}; removed = {}; crashed = {}", new Object[]{this.getPartitionedRegion().getName(), memberId, removedId, crashed});
        }
        return removedId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdAndBuckets(InternalDistributedMember memberId, int prSerial, int[] serials, boolean regionDestroyed) {
        if (logger.isTraceEnabled(LogMarker.DA)) {
            logger.trace(LogMarker.DA, "RegionAdvisor#removeIdAndBuckets: removing member from region {}: {}; buckets = ({}) serials", new Object[]{this.getPartitionedRegion().getName(), memberId, serials == null ? "null" : Integer.valueOf(serials.length)});
        }
        Object object = this.preInitQueueMonitor;
        synchronized (object) {
            if (this.preInitQueue != null) {
                QueuedBucketProfile qbf = new QueuedBucketProfile(memberId, serials, regionDestroyed);
                this.preInitQueue.add(qbf);
                return;
            }
        }
        if (this.buckets != null) {
            if (logger.isTraceEnabled(LogMarker.DA)) {
                logger.trace(LogMarker.DA, "RegionAdvisor#removeIdAndBuckets: removing buckets for member{};{}", new Object[]{memberId, this});
            }
            for (int i = 0; i < this.buckets.length; ++i) {
                int s = serials[i];
                if (s == -1) continue;
                if (logger.isTraceEnabled(LogMarker.DA)) {
                    logger.trace(LogMarker.DA, "RegionAdvisor#removeIdAndBuckets: removing bucket #{} serial {}", new Object[]{i, s});
                }
                this.buckets[i].getBucketAdvisor().removeIdWithSerial(memberId, s, regionDestroyed);
            }
            super.removeIdWithSerial(memberId, prSerial, regionDestroyed);
        }
    }

    public void markBucketsOnMember(DistributedMember member, boolean sick) {
        if (this.buckets == null) {
            return;
        }
        for (int i = 0; i < this.buckets.length; ++i) {
            if (sick && !this.buckets[i].getBucketOwners().contains(member)) continue;
            this.buckets[i].setBucketSick(member, sick);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Marked bucket ({}) {}", new Object[]{this.getPartitionedRegion().bucketStringForLogs(i), this.buckets[i].isBucketSick() ? "sick" : "healthy"});
        }
    }

    public void updateBucketStatus(int bucketId, DistributedMember member, boolean profileRemoved) {
        if (profileRemoved) {
            this.buckets[bucketId].setBucketSick(member, false);
        } else {
            ResourceAdvisor advisor = this.getPartitionedRegion().getCache().getResourceAdvisor();
            boolean sick = advisor.adviseCritialMembers().contains(member);
            if (logger.isDebugEnabled()) {
                logger.debug("updateBucketStatus:({}):member:{}:sick:{}", new Object[]{this.getPartitionedRegion().bucketStringForLogs(bucketId), member, sick});
            }
            this.buckets[bucketId].setBucketSick(member, sick);
        }
    }

    public void checkIfBucketSick(int bucketId, Object key) throws LowMemoryException {
        if (MemoryThresholds.isLowMemoryExceptionDisabled()) {
            return;
        }
        assert (this.buckets != null);
        assert (this.buckets[bucketId] != null);
        if (this.buckets[bucketId].isBucketSick()) {
            Set<DistributedMember> sm = this.buckets[bucketId].getSickMembers();
            if (sm.isEmpty()) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("For bucket {} sick members are ", new Object[]{this.getPartitionedRegion().bucketStringForLogs(bucketId), sm});
            }
            throw new LowMemoryException(LocalizedStrings.ResourceManager_LOW_MEMORY_PR_0_KEY_1_MEMBERS_2.toLocalizedString(this.getPartitionedRegion().getFullPath(), key, sm), sm);
        }
    }

    public int getNumDataStores() {
        int numProfs = this.getNumProfiles();
        if (this.lastActiveProfiles != numProfs) {
            this.numDataStores = this.adviseDataStore().size();
            this.lastActiveProfiles = numProfs;
        }
        return this.numDataStores;
    }

    public Set<InternalDistributedMember> adviseDataStore() {
        return this.adviseDataStore(false);
    }

    public Set<InternalDistributedMember> adviseInitializedDataStore() {
        Set<InternalDistributedMember> s = this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                if (profile instanceof PartitionProfile) {
                    PartitionProfile p = (PartitionProfile)profile;
                    return p.isDataStore && (!p.dataPolicy.withPersistence() || p.regionInitialized);
                }
                return false;
            }
        });
        return s;
    }

    public Set<InternalDistributedMember> adviseNotAtShutDownAllStatus(final int status) {
        Set<InternalDistributedMember> s = this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                if (profile instanceof PartitionProfile) {
                    PartitionProfile p = (PartitionProfile)profile;
                    return p.isDataStore && p.shutDownAllStatus < status;
                }
                return false;
            }
        });
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForProfileStatus(int status) {
        ProfileShutdownListener listener = new ProfileShutdownListener();
        this.addProfileChangeListener(listener);
        try {
            Region pr;
            int memberNum = 0;
            String regionName = this.getPartitionedRegion().getFullPath();
            while ((pr = this.getPartitionedRegion().getCache().getRegion(regionName)) != null) {
                if (pr.isDestroyed()) {
                } else {
                    Set<InternalDistributedMember> members = this.adviseNotAtShutDownAllStatus(status);
                    memberNum = members.size();
                    if (memberNum > 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("waitForProfileStatus {} at PR:{}, expecting {} members: {}", new Object[]{status, this.getPartitionedRegion().getFullPath(), memberNum, members});
                        }
                        listener.waitForChange();
                    }
                    if (memberNum > 0) continue;
                }
                break;
            }
        }
        finally {
            this.removeProfileChangeListener(listener);
        }
    }

    public Set<InternalDistributedMember> adviseDataStore(boolean realHashSet) {
        Set<InternalDistributedMember> s = this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                if (profile instanceof PartitionProfile) {
                    PartitionProfile p = (PartitionProfile)profile;
                    return p.isDataStore;
                }
                return false;
            }
        });
        if (realHashSet && s == Collections.EMPTY_SET) {
            s = new HashSet<InternalDistributedMember>();
        }
        if (logger.isTraceEnabled(LogMarker.DA)) {
            logger.trace(LogMarker.DA, "adviseDataStore returning {} from {}", new Object[]{s, this.toStringWithProfiles()});
        }
        return s;
    }

    public Set<InternalDistributedMember> adviseFixedPartitionDataStores(final String partitionName) {
        Set<InternalDistributedMember> s = this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                if (profile instanceof PartitionProfile) {
                    PartitionProfile p = (PartitionProfile)profile;
                    if (p.fixedPAttrs != null) {
                        for (FixedPartitionAttributesImpl fpa : p.fixedPAttrs) {
                            if (!fpa.getPartitionName().equals(partitionName)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        });
        if (s == Collections.EMPTY_SET) {
            s = new HashSet<InternalDistributedMember>();
        }
        if (logger.isTraceEnabled(LogMarker.DA)) {
            logger.trace(LogMarker.DA, "adviseFixedPartitionDataStore returning {} from {}", new Object[]{s, this.toStringWithProfiles()});
        }
        return s;
    }

    public InternalDistributedMember adviseFixedPrimaryPartitionDataStore(final int bucketId) {
        final ArrayList fixedPartitionDataStore = new ArrayList(1);
        this.fetchProfiles(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                if (profile instanceof PartitionProfile) {
                    PartitionProfile p = (PartitionProfile)profile;
                    if (p.fixedPAttrs != null) {
                        for (FixedPartitionAttributesImpl fpa : p.fixedPAttrs) {
                            if (!fpa.isPrimary() || !fpa.hasBucket(bucketId)) continue;
                            fixedPartitionDataStore.add(0, p.getDistributedMember());
                            return true;
                        }
                    }
                }
                return false;
            }
        });
        if (logger.isTraceEnabled(LogMarker.DA)) {
            logger.trace(LogMarker.DA, "adviseFixedPartitionDataStore returning {} from {}", new Object[]{fixedPartitionDataStore, this.toStringWithProfiles()});
        }
        if (fixedPartitionDataStore.isEmpty()) {
            return null;
        }
        return (InternalDistributedMember)fixedPartitionDataStore.get(0);
    }

    public List<FixedPartitionAttributesImpl> adviseAllFixedPartitionAttributes() {
        final ArrayList<FixedPartitionAttributesImpl> allFPAs = new ArrayList<FixedPartitionAttributesImpl>();
        this.fetchProfiles(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                if (profile instanceof PartitionProfile) {
                    PartitionProfile pp = (PartitionProfile)profile;
                    if (pp.fixedPAttrs != null) {
                        allFPAs.addAll(pp.fixedPAttrs);
                        return true;
                    }
                }
                return false;
            }
        });
        return allFPAs;
    }

    public List<FixedPartitionAttributesImpl> adviseSameFPAs(final FixedPartitionAttributesImpl fpa) {
        final ArrayList<FixedPartitionAttributesImpl> sameFPAs = new ArrayList<FixedPartitionAttributesImpl>();
        this.fetchProfiles(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                if (profile instanceof PartitionProfile) {
                    PartitionProfile pp = (PartitionProfile)profile;
                    List<FixedPartitionAttributesImpl> fpaList = pp.fixedPAttrs;
                    if (fpaList != null) {
                        int index = fpaList.indexOf(fpa);
                        if (index != -1) {
                            sameFPAs.add(fpaList.get(index));
                        }
                        return true;
                    }
                }
                return false;
            }
        });
        return sameFPAs;
    }

    public List<FixedPartitionAttributesImpl> adviseRemotePrimaryFPAs() {
        final ArrayList<FixedPartitionAttributesImpl> remotePrimaryFPAs = new ArrayList<FixedPartitionAttributesImpl>();
        this.fetchProfiles(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                if (profile instanceof PartitionProfile) {
                    PartitionProfile pp = (PartitionProfile)profile;
                    List<FixedPartitionAttributesImpl> fpaList = pp.fixedPAttrs;
                    if (fpaList != null) {
                        for (FixedPartitionAttributesImpl fpa : fpaList) {
                            if (!fpa.isPrimary()) continue;
                            remotePrimaryFPAs.add(fpa);
                            return true;
                        }
                    }
                }
                return false;
            }
        });
        return remotePrimaryFPAs;
    }

    public Node adviseSmallestDataStore(List limitNodeList) {
        final HashMap<InternalDistributedMember, Node> filtSet = new HashMap<InternalDistributedMember, Node>(limitNodeList.size());
        Node n2 = null;
        for (Node n2 : limitNodeList) {
            filtSet.put(n2.getMemberId(), n2);
        }
        final Object[] smallest = new Object[1];
        this.adviseFilter(new DistributionAdvisor.Filter(){
            short numBucks = Short.MAX_VALUE;

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                PartitionProfile p;
                if (profile instanceof PartitionProfile && filtSet.containsKey((p = (PartitionProfile)profile).getDistributedMember()) && p.numBuckets < this.numBucks) {
                    smallest[0] = p.getDistributedMember();
                    this.numBucks = p.numBuckets;
                }
                return false;
            }
        });
        return (Node)filtSet.get(smallest[0]);
    }

    public List<DistributedMember> orderDataStoresUsingBucketCount(final Set nodes) {
        final TreeSet<NodeBucketSize> orderedSet = new TreeSet<NodeBucketSize>();
        ArrayList<DistributedMember> orderedList = new ArrayList<DistributedMember>();
        final InternalDistributedMember self = this.getDistributionManager().getDistributionManagerId();
        this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                if (profile instanceof PartitionProfile && nodes.contains(profile.getDistributedMember())) {
                    PartitionProfile p = (PartitionProfile)profile;
                    orderedSet.add(new NodeBucketSize(p.numBuckets, p.getDistributedMember()));
                    return true;
                }
                if (profile instanceof PartitionProfile && nodes.contains(self)) {
                    orderedSet.add(new NodeBucketSize(RegionAdvisor.this.getBucketSet().size(), self));
                    return true;
                }
                return false;
            }
        });
        if (nodes.contains(self) && !orderedSet.contains(new NodeBucketSize(this.getBucketSet().size(), self))) {
            orderedSet.add(new NodeBucketSize(this.getBucketSet().size(), self));
        }
        for (NodeBucketSize node : orderedSet) {
            orderedList.add(node.member);
        }
        return orderedList;
    }

    public Set adviseAllPRNodes() {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                CacheDistributionAdvisor.CacheProfile prof = (CacheDistributionAdvisor.CacheProfile)profile;
                return prof.isPartitioned;
            }
        });
    }

    public Set adviseRequiresNotification(EntryEventImpl event) {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                if (profile instanceof PartitionProfile) {
                    PartitionProfile prof = (PartitionProfile)profile;
                    if (prof.isPartitioned) {
                        InterestPolicy pol;
                        if (prof.hasCacheListener && (pol = prof.subscriptionAttributes.getInterestPolicy()) == InterestPolicy.ALL) {
                            return true;
                        }
                        return prof.requiresNotification;
                    }
                }
                return false;
            }
        });
    }

    @Override
    public final synchronized boolean putProfile(DistributionAdvisor.Profile p) {
        assert (p instanceof CacheDistributionAdvisor.CacheProfile);
        CacheDistributionAdvisor.CacheProfile profile = (CacheDistributionAdvisor.CacheProfile)p;
        PartitionedRegion pr = this.getPartitionedRegion();
        if (profile.hasCacheLoader) {
            pr.setHaveCacheLoader();
        }
        if (profile.filterProfile != null && !pr.isDataStore()) {
            profile.filterProfile = null;
        }
        return super.putProfile(profile);
    }

    public final PartitionProfile getPartitionProfile(InternalDistributedMember id) {
        return (PartitionProfile)this.getProfile(id);
    }

    public boolean isPrimaryForBucket(int bucketId) {
        if (this.buckets == null) {
            return false;
        }
        return this.buckets[bucketId].isPrimary();
    }

    public boolean isBucketLocal(int bucketId) {
        if (this.buckets == null) {
            return false;
        }
        return this.buckets[bucketId].getHostedBucketRegion() != null;
    }

    public boolean areBucketsInitialized() {
        return this.buckets != null;
    }

    public Bucket getBucket(int bucketId) {
        Assert.assertTrue(this.buckets != null);
        ProxyBucketRegion pbr = this.buckets[bucketId];
        BucketRegion ret = pbr.getHostedBucketRegion();
        if (ret != null) {
            return ret;
        }
        return pbr;
    }

    public BucketAdvisor getBucketAdvisor(int bucketId) {
        Assert.assertTrue(this.buckets != null);
        ProxyBucketRegion pbr = this.buckets[bucketId];
        BucketRegion ret = pbr.getHostedBucketRegion();
        if (ret != null) {
            return ret.getBucketAdvisor();
        }
        return pbr.getBucketAdvisor();
    }

    public Map<Integer, BucketAdvisor> getAllBucketAdvisors() {
        Assert.assertTrue(this.buckets != null);
        HashMap<Integer, BucketAdvisor> map = new HashMap<Integer, BucketAdvisor>();
        for (int i = 0; i < this.buckets.length; ++i) {
            ProxyBucketRegion pbr = this.buckets[i];
            BucketRegion ret = pbr.getHostedBucketRegion();
            if (ret == null) continue;
            map.put(ret.getId(), ret.getBucketAdvisor());
        }
        return map;
    }

    public int[] getBucketSerials() {
        if (this.buckets == null) {
            return new int[0];
        }
        int[] result = new int[this.buckets.length];
        for (int i = 0; i < result.length; ++i) {
            ProxyBucketRegion pbr = this.buckets[i];
            BucketRegion b = pbr.getCreatedBucketRegion();
            result[i] = b == null ? -1 : b.getSerialNumber();
        }
        return result;
    }

    public void resetBucketAdvisorParents() {
        if (this.buckets != null) {
            for (ProxyBucketRegion pbr : this.buckets) {
                if (pbr.getCreatedBucketRegion() != null) {
                    throw new InternalGemFireException(LocalizedStrings.RegionAdvisor_CANNOT_RESET_EXISTING_BUCKET.toLocalizedString(pbr.getPartitionedRegion().getFullPath(), pbr.getBucketId()));
                }
                pbr.getBucketAdvisor().resetParentAdvisor(pbr.getBucketId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket getBucketPostInit(int bucketId) {
        Object object = this.preInitQueueMonitor;
        synchronized (object) {
            boolean interrupted = false;
            try {
                while (this.preInitQueue != null) {
                    try {
                        this.preInitQueueMonitor.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        this.getAdvisee().getCancelCriterion().checkCancelInProgress(e);
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return this.getBucket(bucketId);
    }

    public final InternalDistributedMember getPrimaryMemberForBucket(int bucketId) {
        Assert.assertTrue(this.buckets != null);
        ProxyBucketRegion b = this.buckets[bucketId];
        return b.getBucketAdvisor().getPrimary();
    }

    public InternalDistributedMember getPreferredNode(int bucketId) {
        Assert.assertTrue(this.buckets != null);
        ProxyBucketRegion b = this.buckets[bucketId];
        return b.getBucketAdvisor().getPreferredNode();
    }

    public boolean isStorageAssignedForBucket(int bucketId) {
        Assert.assertTrue(this.buckets != null);
        return this.buckets[bucketId].getBucketRedundancy() >= 0;
    }

    public boolean isStorageAssignedForBucket(int bucketId, int minRedundancy, boolean wait) {
        if (!wait) {
            return this.isStorageAssignedForBucket(bucketId);
        }
        Assert.assertTrue(this.buckets != null);
        return this.buckets[bucketId].getBucketAdvisor().waitForRedundancy(minRedundancy);
    }

    public boolean waitForLocalBucketStorage(int bucketId) {
        Assert.assertTrue(this.buckets != null);
        return this.buckets[bucketId].getBucketAdvisor().waitForStorage();
    }

    public int getBucketRedundancy(int bucketId) {
        Assert.assertTrue(this.buckets != null);
        return this.buckets[bucketId].getBucketRedundancy();
    }

    public Set<InternalDistributedMember> getBucketOwners(int bucketId) {
        Assert.assertTrue(this.buckets != null);
        return this.buckets[bucketId].getBucketOwners();
    }

    public Set<Integer> getBucketSet() {
        Assert.assertTrue(this.buckets != null);
        return new BucketSet();
    }

    public ProxyBucketRegion[] getProxyBucketArray() {
        return this.buckets;
    }

    public ArrayList<PRHARedundancyProvider.DataStoreBuckets> adviseFilteredDataStores(final Set<InternalDistributedMember> memberFilter) {
        final HashMap<InternalDistributedMember, Integer> memberToPrimaryCount = new HashMap<InternalDistributedMember, Integer>();
        for (int i = 0; i < this.buckets.length; ++i) {
            ProxyBucketRegion pbr = this.buckets[i];
            InternalDistributedMember p = pbr.getBucketAdvisor().basicGetPrimaryMember();
            if (p == null) continue;
            Integer count = (Integer)memberToPrimaryCount.get(p);
            if (count != null) {
                memberToPrimaryCount.put(p, count + 1);
                continue;
            }
            memberToPrimaryCount.put(p, 1);
        }
        final ArrayList<PRHARedundancyProvider.DataStoreBuckets> ds = new ArrayList<PRHARedundancyProvider.DataStoreBuckets>(memberFilter.size());
        this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                PartitionProfile p;
                if (profile instanceof PartitionProfile && memberFilter.contains((p = (PartitionProfile)profile).getDistributedMember())) {
                    Integer priCount = (Integer)memberToPrimaryCount.get(p.getDistributedMember());
                    int primaryCount = 0;
                    if (priCount != null) {
                        primaryCount = priCount;
                    }
                    ds.add(new PRHARedundancyProvider.DataStoreBuckets(p.getDistributedMember(), p.numBuckets, primaryCount, p.localMaxMemory));
                }
                return false;
            }
        });
        return ds;
    }

    public void incrementBucketCount(DistributionAdvisor.Profile p) {
        PartitionProfile pp = (PartitionProfile)this.getProfile(p.getDistributedMember());
        if (pp != null) {
            Assert.assertTrue(pp.isDataStore);
            pp.numBuckets = (short)(pp.numBuckets + 1);
        }
    }

    public void decrementsBucketCount(DistributionAdvisor.Profile p) {
        PartitionProfile pp = (PartitionProfile)this.getProfile(p.getDistributedMember());
        if (pp != null) {
            Assert.assertTrue(pp.isDataStore);
            pp.numBuckets = (short)(pp.numBuckets - 1);
            if (pp.numBuckets < 0) {
                pp.numBuckets = 0;
            }
        }
    }

    @Override
    public void dumpProfiles(String infoMsg) {
        if (logger.isDebugEnabled()) {
            logger.debug("[dumpProfiles] dumping {}", new Object[]{this.toStringWithProfiles()});
        }
        super.dumpProfiles(infoMsg);
        ProxyBucketRegion[] pbrs = this.buckets;
        if (pbrs == null) {
            return;
        }
        for (int i = 0; i < pbrs.length; ++i) {
            pbrs[i].getBucketAdvisor().dumpProfiles(infoMsg);
            BucketPersistenceAdvisor persistentAdvisor = pbrs[i].getPersistenceAdvisor();
            if (persistentAdvisor == null) continue;
            persistentAdvisor.dump(infoMsg);
        }
    }

    public void notPrimary(int bucketId, InternalDistributedMember wasPrimary) {
        Assert.assertTrue(this.buckets != null);
        ProxyBucketRegion b = this.buckets[bucketId];
        b.getBucketAdvisor().notPrimary(wasPrimary);
    }

    public Set advisePrimaryOwners() {
        Assert.assertTrue(this.buckets != null);
        ProxyBucketRegion[] bucs = this.buckets;
        HashSet<InternalDistributedMember> hs = new HashSet<InternalDistributedMember>();
        for (int i = 0; i < bucs.length; ++i) {
            InternalDistributedMember mem;
            if (!this.isStorageAssignedForBucket(i) || (mem = bucs[i].getBucketAdvisor().getPrimary()) == null) continue;
            hs.add(mem);
        }
        return hs;
    }

    public <T> boolean accept(BucketVisitor<T> visitor, T aggregate) {
        ProxyBucketRegion[] bucs = this.buckets;
        Assert.assertTrue(bucs != null);
        for (ProxyBucketRegion pbr : bucs) {
            if (visitor.visit(this, pbr, aggregate)) continue;
            return false;
        }
        return true;
    }

    public PartitionedRegion getPartitionedRegion() {
        return (PartitionedRegion)this.getAdvisee();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBucketProfile(int bucketId, BucketAdvisor.BucketProfile profile) {
        Object object = this.preInitQueueMonitor;
        synchronized (object) {
            if (this.preInitQueue != null) {
                QueuedBucketProfile qbf = new QueuedBucketProfile(bucketId, profile);
                this.preInitQueue.add(qbf);
                return;
            }
        }
        this.getBucket(bucketId).getBucketAdvisor().putProfile(profile);
    }

    public Set adviseBucketProfileExchange() {
        return this.adviseDataStore();
    }

    public long adviseTotalMemoryAllocation() {
        final AtomicLong total = new AtomicLong();
        this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                if (profile instanceof PartitionProfile) {
                    PartitionProfile p = (PartitionProfile)profile;
                    total.addAndGet(p.localMaxMemory);
                }
                return false;
            }
        });
        return total.get();
    }

    public long adviseTotalMemoryAllocationForFPR() {
        final AtomicLong total = new AtomicLong();
        this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                if (profile instanceof PartitionProfile) {
                    PartitionProfile p = (PartitionProfile)profile;
                    if (p.fixedPAttrs != null) {
                        total.addAndGet(p.localMaxMemory);
                    }
                }
                return false;
            }
        });
        return total.get();
    }

    public boolean hasCreatedBuckets() {
        ProxyBucketRegion[] bucs = this.buckets;
        if (bucs != null) {
            for (int i = 0; i < bucs.length; ++i) {
                if (bucs[i].getBucketOwnersCount() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public int getCreatedBucketsCount() {
        ProxyBucketRegion[] bucs = this.buckets;
        if (bucs == null) {
            return 0;
        }
        int createdBucketsCount = 0;
        for (int i = 0; i < bucs.length; ++i) {
            if (bucs[i].getBucketOwnersCount() <= 0) continue;
            ++createdBucketsCount;
        }
        return createdBucketsCount;
    }

    public ArrayList getBucketRegionProfiles() {
        ProxyBucketRegion[] bucs = this.buckets;
        if (bucs == null) {
            return null;
        }
        ArrayList<BucketProfileAndId> result = new ArrayList<BucketProfileAndId>(bucs.length);
        for (int i = 0; i < bucs.length; ++i) {
            BucketRegion br = bucs[i].getCreatedBucketRegion();
            if (br == null) continue;
            result.add(new BucketProfileAndId(br.getProfile(), i));
        }
        if (result.size() == 0) {
            result = null;
        }
        return result;
    }

    public void putBucketRegionProfiles(ArrayList l) {
        int size = l.size();
        for (int i = 0; i < size; ++i) {
            BucketProfileAndId bp = (BucketProfileAndId)l.get(i);
            int id = bp.getId();
            this.getBucket(id).getBucketAdvisor().putProfile(bp.getBucketProfile());
        }
    }

    @Override
    protected void profileRemoved(DistributionAdvisor.Profile profile) {
        if (logger.isDebugEnabled()) {
            logger.debug("RA: removing profile {}", new Object[]{profile});
        }
        if (this.getAdvisee() instanceof PartitionedRegion) {
            ((PartitionedRegion)this.getAdvisee()).removeMemberFromCriticalList(profile.peerMemberId);
        }
        if (this.buckets != null) {
            for (int i = 0; i < this.buckets.length; ++i) {
                this.buckets[i].getBucketAdvisor().checkForLostPrimaryElector(profile);
            }
        }
    }

    public void addPersistenceListener(PersistentStateListener listener) {
        for (int i = 0; i < this.buckets.length; ++i) {
            BucketPersistenceAdvisor advisor = this.buckets[i].getPersistenceAdvisor();
            if (advisor == null) continue;
            advisor.addListener(listener);
        }
    }

    private class ProfileShutdownListener
    implements ProfileListener {
        private boolean profileChanged = false;

        ProfileShutdownListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForChange() {
            PartitionedRegion pr = RegionAdvisor.this.getPartitionedRegion();
            ProfileShutdownListener profileShutdownListener = this;
            synchronized (profileShutdownListener) {
                while (!this.profileChanged && pr != null && !pr.isDestroyed()) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.profileChanged = false;
            }
        }

        @Override
        public void profileCreated(DistributionAdvisor.Profile profile) {
            this.profileUpdated(profile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void profileRemoved(DistributionAdvisor.Profile profile, boolean regionDestroyed) {
            ProfileShutdownListener profileShutdownListener = this;
            synchronized (profileShutdownListener) {
                this.profileChanged = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void profileUpdated(DistributionAdvisor.Profile profile) {
            ProfileShutdownListener profileShutdownListener = this;
            synchronized (profileShutdownListener) {
                this.profileChanged = true;
                this.notifyAll();
            }
        }
    }

    public static class BucketProfileAndId
    implements DataSerializable {
        private static final long serialVersionUID = 332892607792421553L;
        private int id;
        private BucketAdvisor.BucketProfile bp;
        private boolean isServerBucketProfile = false;

        public BucketProfileAndId(DistributionAdvisor.Profile bp, int id) {
            this.id = id;
            this.bp = (BucketAdvisor.BucketProfile)bp;
            if (bp instanceof BucketAdvisor.ServerBucketProfile) {
                this.isServerBucketProfile = true;
            }
        }

        public BucketProfileAndId() {
        }

        public int getId() {
            return this.id;
        }

        public BucketAdvisor.BucketProfile getBucketProfile() {
            return this.bp;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.id = in.readInt();
            this.isServerBucketProfile = in.readBoolean();
            this.bp = this.isServerBucketProfile ? new BucketAdvisor.ServerBucketProfile() : new BucketAdvisor.BucketProfile();
            InternalDataSerializer.invokeFromData(this.bp, in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            out.writeInt(this.id);
            out.writeBoolean(this.isServerBucketProfile);
            InternalDataSerializer.invokeToData(this.bp, out);
        }

        public String toString() {
            return "BucketProfileAndId (profile=" + this.bp + "; id=" + this.id + ")";
        }
    }

    static class QueuedBucketProfile {
        protected final int bucketId;
        protected final BucketAdvisor.BucketProfile bucketProfile;
        protected final boolean memberDeparted;
        protected final boolean isRemoval;
        protected final boolean crashed;
        protected final boolean fromMembershipListener;
        protected final boolean destroyed;
        protected final InternalDistributedMember memberId;
        protected final int[] serials;

        public QueuedBucketProfile(int bId, BucketAdvisor.BucketProfile p) {
            this.bucketId = bId;
            this.bucketProfile = p;
            this.isRemoval = false;
            this.crashed = false;
            this.memberDeparted = false;
            this.memberId = null;
            this.serials = null;
            this.destroyed = false;
            this.fromMembershipListener = false;
        }

        public QueuedBucketProfile(InternalDistributedMember mbr, boolean crashed, boolean destroyed, boolean fromMembershipListener) {
            this.bucketId = 0;
            this.bucketProfile = null;
            this.isRemoval = true;
            this.crashed = crashed;
            this.memberDeparted = true;
            this.memberId = mbr;
            this.serials = null;
            this.destroyed = destroyed;
            this.fromMembershipListener = fromMembershipListener;
        }

        public QueuedBucketProfile(InternalDistributedMember mbr, int[] serials, boolean destroyed) {
            this.bucketId = 0;
            this.bucketProfile = null;
            this.isRemoval = true;
            this.crashed = false;
            this.memberDeparted = false;
            this.memberId = mbr;
            this.serials = serials;
            this.destroyed = destroyed;
            this.fromMembershipListener = false;
        }
    }

    public static interface BucketVisitor<T> {
        public boolean visit(RegionAdvisor var1, ProxyBucketRegion var2, T var3);
    }

    private class BucketSet
    extends AbstractSet {
        final ProxyBucketRegion[] pbrs;

        public BucketSet() {
            this.pbrs = RegionAdvisor.this.buckets;
            Assert.assertTrue(this.pbrs != null);
        }

        @Override
        public Object[] toArray() {
            ArrayList ar = new ArrayList(this.pbrs.length);
            try {
                Iterator e = this.iterator();
                while (e.hasNext()) {
                    ar.add(e.next());
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return ar.toArray();
        }

        @Override
        public Object[] toArray(Object[] p_a) {
            Object[] a = p_a;
            Object[] oa = this.toArray();
            if (a.length < oa.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), oa.length);
                System.arraycopy(oa, 0, a, 0, oa.length);
            }
            for (int i = 0; i < oa.length; ++i) {
                a[i] = oa[i];
            }
            if (a.length > oa.length) {
                a[oa.length] = null;
            }
            return a;
        }

        @Override
        public int size() {
            return this.pbrs.length;
        }

        @Override
        public Iterator iterator() {
            return new BucketSetIterator();
        }

        class BucketSetIterator
        implements Iterator {
            private int currentItem = -1;

            BucketSetIterator() {
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                if (RegionAdvisor.this.getPartitionedRegion().isFixedPartitionedRegion()) {
                    if (this.currentItem + 1 < BucketSet.this.pbrs.length) {
                        int possibleBucketId = this.currentItem;
                        boolean bucketExists = false;
                        List<FixedPartitionAttributesImpl> fpaList = RegionAdvisor.this.adviseAllFixedPartitionAttributes();
                        List<FixedPartitionAttributesImpl> localFpas = RegionAdvisor.this.getPartitionedRegion().getFixedPartitionAttributesImpl();
                        if (localFpas != null) {
                            fpaList.addAll(localFpas);
                        }
                        block0: while (++possibleBucketId < BucketSet.this.pbrs.length && !bucketExists) {
                            for (FixedPartitionAttributesImpl fpa : fpaList) {
                                if (!fpa.hasBucket(possibleBucketId)) continue;
                                bucketExists = true;
                                continue block0;
                            }
                        }
                        return bucketExists;
                    }
                    return false;
                }
                return this.currentItem + 1 < BucketSet.this.pbrs.length;
            }

            public Object next() {
                if (++this.currentItem < BucketSet.this.pbrs.length) {
                    if (RegionAdvisor.this.isStorageAssignedForBucket(this.currentItem)) {
                        return this.currentItem;
                    }
                    if (RegionAdvisor.this.getPartitionedRegion().isFixedPartitionedRegion()) {
                        boolean bucketExists = false;
                        List<FixedPartitionAttributesImpl> fpaList = RegionAdvisor.this.adviseAllFixedPartitionAttributes();
                        List<FixedPartitionAttributesImpl> localFpas = RegionAdvisor.this.getPartitionedRegion().getFixedPartitionAttributesImpl();
                        if (localFpas != null) {
                            fpaList.addAll(localFpas);
                        }
                        do {
                            for (FixedPartitionAttributesImpl fpa : fpaList) {
                                if (!fpa.hasBucket(this.currentItem)) continue;
                                bucketExists = true;
                                break;
                            }
                            if (bucketExists) continue;
                            ++this.currentItem;
                        } while (this.currentItem < BucketSet.this.pbrs.length && !bucketExists);
                        if (bucketExists) {
                            RegionAdvisor.this.getPartitionedRegion().createBucket(this.currentItem, 0, null);
                            return this.currentItem;
                        }
                    } else {
                        RegionAdvisor.this.getPartitionedRegion().createBucket(this.currentItem, 0, null);
                        return this.currentItem;
                    }
                }
                throw new NoSuchElementException();
            }
        }
    }

    private class NodeBucketSize
    implements Comparable {
        private final int numBuckets;
        private final DistributedMember member;

        public NodeBucketSize(int numBuckets, DistributedMember member) {
            this.numBuckets = numBuckets;
            this.member = member;
        }

        public int compareTo(Object o) {
            assert (o instanceof NodeBucketSize);
            NodeBucketSize node = (NodeBucketSize)o;
            if (node.numBuckets > this.numBuckets) {
                return 1;
            }
            return -1;
        }

        public String toString() {
            return "NodeBucketSize [ member =" + this.member + " numBuckets = " + this.numBuckets + "]";
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NodeBucketSize)) {
                return false;
            }
            NodeBucketSize node = (NodeBucketSize)obj;
            return this.member.getId().equals(node.member.getId());
        }
    }

    public static final class PartitionProfile
    extends CacheDistributionAdvisor.CacheProfile {
        public int localMaxMemory;
        public transient boolean isDataStore = false;
        public boolean requiresNotification = false;
        public transient short numBuckets = 0;
        public List<FixedPartitionAttributesImpl> fixedPAttrs;
        public int shutDownAllStatus = -1;

        public PartitionProfile() {
        }

        public PartitionProfile(InternalDistributedMember memberId, int version) {
            super(memberId, version);
            this.isPartitioned = true;
        }

        @Override
        protected final int getIntInfo() {
            int s = super.getIntInfo();
            if (this.requiresNotification) {
                s |= 0x8000;
            }
            return s;
        }

        @Override
        protected final void setIntInfo(int s) {
            super.setIntInfo(s);
            this.requiresNotification = (s & 0x8000) != 0;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.localMaxMemory = in.readInt();
            this.isDataStore = this.localMaxMemory > 0;
            this.fixedPAttrs = (List)DataSerializer.readObject(in);
            this.shutDownAllStatus = in.readInt();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.localMaxMemory);
            DataSerializer.writeObject(this.fixedPAttrs, out);
            out.writeInt(this.shutDownAllStatus);
        }

        @Override
        public StringBuilder getToStringHeader() {
            return new StringBuilder("RegionAdvisor.PartitionProfile");
        }

        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            sb.append("; isDataStore=").append(this.isDataStore).append("; requiresNotification=").append(this.requiresNotification).append("; localMaxMemory=").append(this.localMaxMemory).append("; numBuckets=").append(this.numBuckets);
            if (this.fixedPAttrs != null) {
                sb.append("; FixedPartitionAttributes=").append(this.fixedPAttrs);
            }
            sb.append("; filterProfile=").append(this.filterProfile);
            sb.append("; shutDownAllStatus=").append(this.shutDownAllStatus);
        }

        @Override
        public int getDSFID() {
            return 18;
        }
    }
}

