/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.SystemTimer;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;

public final class PRSanityCheckMessage
extends PartitionMessage {
    private String regionName;

    public PRSanityCheckMessage() {
    }

    public PRSanityCheckMessage(Set recipients, int prId, ReplyProcessor21 processor, String regionName) {
        super(recipients, prId, processor);
        this.regionName = regionName;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append(" regionName=").append(this.regionName);
    }

    @Override
    public int getDSFID() {
        return 56;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.regionName = DataSerializer.readString(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.regionName, out);
    }

    public static void schedule(final PartitionedRegion pr) {
        if (Boolean.getBoolean("gemfire.PRSanityCheckEnabled")) {
            final DM dm = pr.getDistributionManager();
            DistributedRegion prRoot = (DistributedRegion)PartitionedRegionHelper.getPRRoot(pr.getCache(), false);
            if (prRoot == null) {
                return;
            }
            Set<InternalDistributedMember> recipients = prRoot.getDistributionAdvisor().adviseGeneric();
            if (recipients.size() <= 0) {
                return;
            }
            final PRSanityCheckMessage delayedInstance = new PRSanityCheckMessage(recipients, pr.getPRId(), null, pr.getRegionIdentifier());
            PRSanityCheckMessage instance = new PRSanityCheckMessage(recipients, pr.getPRId(), null, pr.getRegionIdentifier());
            dm.putOutgoing(instance);
            int sanityCheckInterval = Integer.getInteger("gemfire.PRSanityCheckInterval", 5000);
            if (sanityCheckInterval != 0) {
                final SystemTimer tm = new SystemTimer(dm.getSystem(), true);
                SystemTimer.SystemTimerTask st = new SystemTimer.SystemTimerTask(){

                    @Override
                    public void run2() {
                        try {
                            if (!(pr.isLocallyDestroyed || pr.isClosed || pr.isDestroyed())) {
                                dm.putOutgoing(delayedInstance);
                            }
                        }
                        catch (CancelException cancelException) {
                        }
                        finally {
                            tm.cancel();
                        }
                    }
                };
                tm.schedule(st, sanityCheckInterval);
            }
        }
    }

    @Override
    public int getProcessorType() {
        return 75;
    }

    @Override
    public void process(DistributionManager dm) {
        PartitionedRegion.validatePRID(this.getSender(), this.regionId, this.regionName);
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException, QueryException, ForceReattemptException, InterruptedException {
        return false;
    }
}

