/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public final class PRLoad
implements DataSerializable {
    private static final long serialVersionUID = 778886995284953922L;
    private final float weight;
    private final float[] bucketReadLoads;
    private final float[] bucketWriteLoads;

    public static PRLoad createFromDataInput(DataInput in) throws IOException, ClassNotFoundException {
        float weight = in.readFloat();
        float[] bucketReadLoads = DataSerializer.readFloatArray(in);
        float[] bucketWriteLoads = DataSerializer.readFloatArray(in);
        return new PRLoad(weight, bucketReadLoads, bucketWriteLoads);
    }

    public PRLoad() {
        throw new UnsupportedOperationException("Use PRLoad#createFromDataInput(DataInput) instead.");
    }

    public PRLoad(int numBuckets, float weight) {
        this.weight = weight;
        this.bucketReadLoads = new float[numBuckets];
        this.bucketWriteLoads = new float[numBuckets];
    }

    public PRLoad(float weight, float[] bucketReadLoads, float[] bucketWriteLoads) {
        this.weight = weight;
        this.bucketReadLoads = bucketReadLoads;
        this.bucketWriteLoads = bucketWriteLoads;
    }

    public void addBucket(int bucketId, float readLoad, float writeLoad) {
        this.bucketReadLoads[bucketId] = readLoad;
        this.bucketWriteLoads[bucketId] = writeLoad;
    }

    public float getReadLoad(int bucketId) {
        return this.bucketReadLoads[bucketId];
    }

    public float getWriteLoad(int bucketId) {
        return this.bucketWriteLoads[bucketId];
    }

    public float getWeight() {
        return this.weight;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PRLoad@");
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append(", weight: ").append(this.weight);
        sb.append(", numBuckets: ").append(this.bucketReadLoads.length);
        sb.append(", bucketReadLoads: ").append(Arrays.toString(this.bucketReadLoads));
        sb.append(", bucketWriteLoads: ").append(Arrays.toString(this.bucketWriteLoads));
        return sb.toString();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeFloat(this.weight);
        DataSerializer.writeFloatArray(this.bucketReadLoads, out);
        DataSerializer.writeFloatArray(this.bucketWriteLoads, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("Use PRLoad#createFromDataInput(DataInput) instead.");
    }
}

