/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.DataLocationException;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.FilterRoutingInfo;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.partitioned.DestroyMessage;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class InvalidateMessage
extends DestroyMessage {
    private static final Logger logger = LogService.getLogger();

    public InvalidateMessage() {
    }

    private InvalidateMessage(Set recipients, boolean notifyOnly, int regionId, DirectReplyProcessor processor, EntryEventImpl event) {
        super(recipients, notifyOnly, regionId, processor, event, null);
    }

    InvalidateMessage(InvalidateMessage original, EntryEventImpl event) {
        super(original);
        this.versionTag = event.getVersionTag();
    }

    InvalidateMessage(InvalidateMessage original, EntryEventImpl event, Set members) {
        super(original, event, members);
    }

    @Override
    public PartitionMessage getMessageForRelayToListeners(EntryEventImpl event, Set members) {
        if (event.hasOldValue() && members != null && !members.isEmpty()) {
            return new InvalidateMessage(this, event, members);
        }
        return new InvalidateMessage(this, event);
    }

    public static Set notifyListeners(Set cacheOpReceivers, Set adjunctRecipients, FilterRoutingInfo filterRoutingInfo, PartitionedRegion r, EntryEventImpl event, DirectReplyProcessor processor) {
        InvalidateMessage msg = new InvalidateMessage(Collections.EMPTY_SET, true, r.getPRId(), processor, event);
        msg.versionTag = event.getVersionTag();
        return msg.relayToListeners(cacheOpReceivers, adjunctRecipients, filterRoutingInfo, event, r, processor);
    }

    public static InvalidateResponse send(DistributedMember recipient, PartitionedRegion r, EntryEventImpl event) throws ForceReattemptException {
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        InvalidateResponse p = new InvalidateResponse(r.getSystem(), recipients, event.getKey());
        InvalidateMessage m = new InvalidateMessage(recipients, false, r.getPRId(), p, event);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(LocalizedStrings.InvalidateMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion r, long startTime) throws EntryExistsException, DataLocationException {
        eventSender = this.originalSender;
        if (eventSender == null) {
            eventSender = this.getSender();
        }
        key = this.getKey();
        if (r.keyRequiresRegionContext()) {
            ((KeyWithRegionContext)key).setRegionContext(r);
        }
        event = EntryEventImpl.create((LocalRegion)r, this.getOperation(), key, null, this.getCallbackArg(), false, (DistributedMember)eventSender, true, false);
        try {
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(this.getSender());
                event.setVersionTag(this.versionTag);
            }
            if (this.bridgeContext != null) {
                event.setContext(this.bridgeContext);
            }
            event.setEventId(this.eventId);
            event.setPossibleDuplicate(this.posDup);
            ds = r.getDataStore();
            sendReply = true;
            event.setInvokePRCallbacks(this.notificationOnly == false);
            if (!this.notificationOnly) {
                Assert.assertTrue(ds != null, "This process should have storage for an item in " + this.toString());
                try {
                    bucket = PartitionedRegionHelper.getHashKey(event);
                    event.setCausedByMessage(this);
                    r.getDataView().invalidateOnRemote(event, true, false);
                    this.versionTag = event.getVersionTag();
                    if (!InvalidateMessage.logger.isTraceEnabled(LogMarker.DM)) ** GOTO lbl51
                    InvalidateMessage.logger.trace(LogMarker.DM, "{} invalidateLocally in bucket: {}, key: {}", new Object[]{this.getClass().getName(), bucket, key});
                }
                catch (DataLocationException e) {
                    ((ForceReattemptException)e).checkKey(event.getKey());
                    throw e;
                }
                catch (EntryNotFoundException eee) {
                    if (InvalidateMessage.logger.isDebugEnabled()) {
                        InvalidateMessage.logger.debug("{}: operateOnRegion caught EntryNotFoundException {}", new Object[]{this.getClass().getName(), eee.getMessage(), eee});
                    }
                    this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(eee), r, startTime);
                    sendReply = false;
                }
                catch (PrimaryBucketException pbe) {
                    this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(pbe), r, startTime);
                    var11_14 = false;
                    event.release();
                    return var11_14;
                }
            } else {
                event.setRegion(r);
                event.setOriginRemote(true);
                if (this.versionTag != null) {
                    this.versionTag.replaceNullIDs(this.getSender());
                    event.setVersionTag(this.versionTag);
                }
                if (this.filterInfo != null) {
                    event.setLocalFilterInfo(this.filterInfo.getFilterInfo(dm.getDistributionManagerId()));
                }
                r.invokeInvalidateCallbacks(EnumListenerEvent.AFTER_INVALIDATE, event, r.isInitialized());
            }
lbl51:
            // 4 sources

            var10_13 = sendReply;
            return var10_13;
        }
        finally {
            event.release();
        }
    }

    PartitionMessage.PartitionResponse createReplyProcessor(PartitionedRegion r, Set recipients, Object key) {
        return new InvalidateResponse(r.getSystem(), recipients, key);
    }

    @Override
    protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, PartitionedRegion pr, long startTime) {
        if (pr != null && startTime > 0L) {
            pr.getPrStats().endPartitionMessagesProcessing(startTime);
        }
        InvalidateReplyMessage.send(member, procId, this.getReplySender(dm), ex, this.versionTag);
    }

    @Override
    public int getDSFID() {
        return -96;
    }

    public static class InvalidateResponse
    extends PartitionMessage.PartitionResponse {
        private volatile boolean returnValueReceived;
        final Object key;
        public VersionTag versionTag;

        public InvalidateResponse(InternalDistributedSystem ds, Set recipients, Object key) {
            super(ds, recipients, false);
            this.key = key;
        }

        public void setResponse(InvalidateReplyMessage msg) {
            this.returnValueReceived = true;
            this.versionTag = msg.versionTag;
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(msg.getSender());
            }
        }

        public void waitForResult() throws CacheException, ForceReattemptException {
            try {
                this.waitForCacheException();
            }
            catch (ForceReattemptException e) {
                e.checkKey(this.key);
                throw e;
            }
            if (!this.returnValueReceived) {
                throw new ForceReattemptException(LocalizedStrings.InvalidateMessage_NO_RESPONSE_CODE_RECEIVED.toLocalizedString());
            }
        }
    }

    public static final class InvalidateReplyMessage
    extends ReplyMessage {
        VersionTag versionTag;

        public InvalidateReplyMessage() {
        }

        private InvalidateReplyMessage(int processorId, VersionTag version, ReplyException ex) {
            this.setProcessorId(processorId);
            this.versionTag = version;
            this.setException(ex);
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender replySender, ReplyException ex, VersionTag version) {
            Assert.assertTrue(recipient != null, "InvalidateReplyMessage NULL reply message");
            InvalidateReplyMessage m = new InvalidateReplyMessage(processorId, version, ex);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 rp) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "InvalidateReplyMessage process invoking reply processor with processorId: {}", new Object[]{this.processorId});
            }
            if (rp == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "InvalidateReplyMessage processor not found");
                }
                return;
            }
            if (rp instanceof InvalidateResponse) {
                InvalidateResponse processor = (InvalidateResponse)rp;
                processor.setResponse(this);
            }
            rp.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", new Object[]{rp, this});
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -95;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.versionTag, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.versionTag = (VersionTag)DataSerializer.readObject(in);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("InvalidateReplyMessage ").append("processorid=").append(this.processorId).append(" exception=").append(this.getException()).append(" versionTag=").append(this.versionTag);
            return sb.toString();
        }
    }
}

