/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.InterestRegistrationEvent;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class InterestEventMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private InterestRegistrationEvent event;

    public InterestEventMessage() {
    }

    private InterestEventMessage(Set recipients, int regionId, int processorId, InterestRegistrationEvent event, ReplyProcessor21 processor) {
        super(recipients, regionId, processor);
        this.event = event;
    }

    @Override
    public final int getProcessorType() {
        return 73;
    }

    @Override
    protected final boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion r, long startTime) throws ForceReattemptException {
        PartitionedRegionDataStore ds;
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.debug("InterestEventMessage operateOnPartitionedRegion: {}", new Object[]{r.getFullPath()});
        }
        if ((ds = r.getDataStore()) != null) {
            try {
                ds.handleInterestEvent(this.event);
                r.getPrStats().endPartitionMessagesProcessing(startTime);
                InterestEventReplyMessage.send(this.getSender(), this.getProcessorId(), dm);
            }
            catch (Exception e) {
                this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(new ForceReattemptException("Caught exception during interest registration processing:", e)), r, startTime);
                return false;
            }
        } else {
            throw new InternalError("InterestEvent message was sent to a member with no storage.");
        }
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; event=").append(this.event);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.event = (InterestRegistrationEvent)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.event, out);
    }

    public static InterestEventResponse send(Set recipients, PartitionedRegion region, InterestRegistrationEvent event) throws ForceReattemptException {
        InterestEventResponse response = new InterestEventResponse(region.getSystem(), recipients);
        InterestEventMessage m = new InterestEventMessage(recipients, region.getPRId(), response.getProcessorId(), event, response);
        Set failures = region.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException("Failed sending <" + m + "> to " + failures);
        }
        return response;
    }

    @Override
    public int getDSFID() {
        return -47;
    }

    public static class InterestEventResponse
    extends PartitionMessage.PartitionResponse {
        public InterestEventResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, recipients);
        }

        public void waitForResponse() throws ForceReattemptException {
            try {
                this.waitForCacheException();
            }
            catch (ForceReattemptException e) {
                logger.debug("InterestEventResponse got ForceReattemptException; rethrowing {}", new Object[]{e.getMessage(), e});
                throw e;
            }
            catch (CacheException e) {
                String msg = "InterestEventResponse got remote CacheException, throwing ForceReattemptException";
                logger.debug("InterestEventResponse got remote CacheException, throwing ForceReattemptException", (Throwable)e);
                throw new ForceReattemptException("InterestEventResponse got remote CacheException, throwing ForceReattemptException", e);
            }
        }
    }

    public static class InterestEventReplyMessage
    extends HighPriorityDistributionMessage {
        private int processorId;

        public InterestEventReplyMessage() {
        }

        private InterestEventReplyMessage(int processorId) {
            this.processorId = processorId;
        }

        public static void send(InternalDistributedMember recipient, int processorId, DM dm) throws ForceReattemptException {
            InterestEventReplyMessage m = new InterestEventReplyMessage(processorId);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(DistributionManager dm) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "InterestEventReplyMessage process invoking reply processor with processorId: {}", new Object[]{this.processorId});
            }
            try {
                ReplyProcessor21 processor = ReplyProcessor21.getProcessor(this.processorId);
                if (processor == null) {
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "InterestEventReplyMessage processor not found");
                    }
                    return;
                }
                processor.process(this);
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.debug("{} processed {}", new Object[]{processor, this});
                }
            }
            finally {
                dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer().append("InterestEventReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }

        @Override
        public int getDSFID() {
            return -46;
        }
    }
}

