/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.cache.CacheRuntimeException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.SerialDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public final class FlushMessage
extends SerialDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    int prId;
    int bucketId;
    int processorId;

    public FlushMessage() {
    }

    private FlushMessage(int prId, int bucketId, int processorId, InternalDistributedMember recipient) {
        this.prId = prId;
        this.bucketId = bucketId;
        this.processorId = processorId;
        this.setRecipient(recipient);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void process(DistributionManager dm) {
        if (this.bucketId != Integer.MIN_VALUE) {
            if (logger.isDebugEnabled()) {
                logger.debug("Received sent FlushMessage {}", new Object[]{this});
            }
            try {
                PartitionedRegion p = PartitionedRegion.getPRFromId(this.prId);
                Assert.assertTrue(p.getRegionAdvisor().isPrimaryForBucket(this.bucketId));
                return;
            }
            catch (PRLocallyDestroyedException fre) {
                if (!logger.isDebugEnabled()) return;
                logger.debug("Sending reply despite Region getting locally destroyed prId={}", new Object[]{this.prId, fre});
                return;
            }
            catch (CacheRuntimeException ce) {
                logger.debug("Sending reply despite unavailable Partitioned Region using prId={}", new Object[]{this.prId, ce});
                return;
            }
            finally {
                dm.putOutgoing(new FlushMessage(this.prId, Integer.MIN_VALUE, this.getProcessorId(), this.getSender()));
            }
        } else {
            ReplyProcessor21 rep;
            if (logger.isDebugEnabled()) {
                logger.debug("Processing FlushMessage as a response {}", new Object[]{this});
            }
            if ((rep = ReplyProcessor21.getProcessor(this.processorId)) == null) return;
            rep.process(this);
        }
    }

    public static ReplyProcessor21 send(InternalDistributedMember primary, PartitionedRegion p, int bucketId) {
        ReplyProcessor21 reply = new ReplyProcessor21(p.getDistributionManager(), primary);
        FlushMessage fm = new FlushMessage(p.getPRId(), bucketId, reply.getProcessorId(), primary);
        p.getDistributionManager().putOutgoing(fm);
        return reply;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    public int getDSFID() {
        return 49;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.prId = in.readInt();
        this.bucketId = in.readInt();
        this.processorId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.prId);
        out.writeInt(this.bucketId);
        out.writeInt(this.processorId);
    }
}

