/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class DumpAllPRConfigMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();

    public DumpAllPRConfigMessage() {
    }

    private DumpAllPRConfigMessage(Set recipients, int regionId, ReplyProcessor21 processor) {
        super(recipients, regionId, processor);
    }

    public static PartitionMessage.PartitionResponse send(Set recipients, PartitionedRegion r) {
        PartitionMessage.PartitionResponse p = new PartitionMessage.PartitionResponse(r.getSystem(), recipients);
        DumpAllPRConfigMessage m = new DumpAllPRConfigMessage(recipients, r.getPRId(), (ReplyProcessor21)p);
        r.getDistributionManager().putOutgoing(m);
        return p;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException {
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "DumpAllPRConfigMessage operateOnRegion: {}", new Object[]{pr.getFullPath()});
        }
        pr.dumpSelfEntryFromAllPartitionedRegions();
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.debug("{} dumped allPartitionedRegions", new Object[]{this.getClass().getName()});
        }
        return true;
    }

    @Override
    public int getDSFID() {
        return 44;
    }
}

