/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.lru;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.lru.HeapEvictor;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.offheap.MemoryAllocator;

public class OffHeapEvictor
extends HeapEvictor {
    private static final String EVICTOR_THREAD_GROUP_NAME = "OffHeapEvictorThreadGroup";
    private static final String EVICTOR_THREAD_NAME = "OffHeapEvictorThread";
    private long bytesToEvictWithEachBurst;

    public OffHeapEvictor(Cache gemFireCache) {
        super(gemFireCache);
        this.calculateEvictionBurst();
    }

    private void calculateEvictionBurst() {
        float evictionBurstPercentage = Float.parseFloat(System.getProperty("gemfire.HeapLRUCapacityController.evictionBurstPercentage", "0.4"));
        MemoryAllocator allocator = ((GemFireCacheImpl)this.cache).getOffHeapStore();
        if (null == allocator) {
            throw new IllegalStateException(LocalizedStrings.MEMSCALE_EVICTION_INIT_FAIL.toLocalizedString());
        }
        this.bytesToEvictWithEachBurst = (long)((double)allocator.getTotalMemory() * 0.01 * (double)evictionBurstPercentage);
    }

    @Override
    protected int getEvictionLoopDelayTime() {
        if (this.numEvictionLoopsCompleted < Math.max(3, this.numFastLoops)) {
            return 250;
        }
        return 1000;
    }

    @Override
    protected boolean includePartitionedRegion(PartitionedRegion region) {
        return region.getEvictionAttributes().getAlgorithm().isLRUHeap() && region.getDataStore() != null && region.getAttributes().getOffHeap();
    }

    @Override
    protected boolean includeLocalRegion(LocalRegion region) {
        return region.getEvictionAttributes().getAlgorithm().isLRUHeap() && region.getAttributes().getOffHeap();
    }

    @Override
    protected String getEvictorThreadGroupName() {
        return EVICTOR_THREAD_GROUP_NAME;
    }

    @Override
    protected String getEvictorThreadName() {
        return EVICTOR_THREAD_NAME;
    }

    @Override
    public long getTotalBytesToEvict() {
        return this.bytesToEvictWithEachBurst;
    }

    @Override
    protected InternalResourceManager.ResourceType getResourceType() {
        return InternalResourceManager.ResourceType.OFFHEAP_MEMORY;
    }
}

