/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.ha;

import com.gemstone.gemfire.internal.cache.ha.HAContainerWrapper;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class HAContainerMap
implements HAContainerWrapper {
    private Map map = null;
    private final Map<String, CacheClientProxy> haRegionNameToProxy;

    public HAContainerMap(HashMap containerMap) {
        this.map = containerMap;
        this.haRegionNameToProxy = new ConcurrentHashMap<String, CacheClientProxy>();
    }

    @Override
    public ClientProxyMembershipID getProxyID(String haRegionName) {
        CacheClientProxy proxy = this.haRegionNameToProxy.get(haRegionName);
        if (proxy != null) {
            return proxy.getProxyID();
        }
        return null;
    }

    @Override
    public Object putProxy(String haName, CacheClientProxy proxy) {
        return this.haRegionNameToProxy.put(haName, proxy);
    }

    @Override
    public CacheClientProxy getProxy(String haRegionName) {
        return this.haRegionNameToProxy.get(haRegionName);
    }

    @Override
    public Object removeProxy(String haName) {
        return this.haRegionNameToProxy.remove(haName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getKey(Object key) {
        Map map = this.map;
        synchronized (map) {
            Entry entry = (Entry)this.map.get(key);
            return entry == null ? null : entry.getKey();
        }
    }

    @Override
    public String getName() {
        return "HashMap";
    }

    @Override
    public void cleanUp() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map map = this.map;
        synchronized (map) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Map map = this.map;
        synchronized (map) {
            return this.map.containsKey(key);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("containsValue() not supported.");
    }

    public Set entrySet() {
        throw new UnsupportedOperationException("entrySet() not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Map map = this.map;
        synchronized (map) {
            Entry entry = (Entry)this.map.get(key);
            return entry == null ? null : entry.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getEntry(Object key) {
        Map map = this.map;
        synchronized (map) {
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Map map = this.map;
        synchronized (map) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        Map map = this.map;
        synchronized (map) {
            return this.map.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Entry entry = new Entry(key, value);
        Map map = this.map;
        synchronized (map) {
            return this.map.put(key, entry);
        }
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException("putAll() not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Map map = this.map;
        synchronized (map) {
            Entry entry = (Entry)this.map.remove(key);
            return entry == null ? null : entry.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Map map = this.map;
        synchronized (map) {
            return this.map.size();
        }
    }

    public Collection values() {
        throw new UnsupportedOperationException("values() not supported.");
    }

    protected static class Entry
    implements Map.Entry {
        private Object key = null;
        private Object value = null;

        public Entry(Object key, Object val) {
            if (key == null || val == null) {
                throw new IllegalArgumentException("key or value cannot be null.");
            }
            this.key = key;
            this.value = val;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object val) {
            throw new UnsupportedOperationException("setValue() not supported.");
        }
    }
}

