/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.operations.ExecuteFunctionOperationContext;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.execute.FunctionStats;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionException;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.gemstone.gemfire.internal.cache.execute.ServerToClientFunctionResultSender;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.logging.log4j.Logger;

public class ServerToClientFunctionResultSender65
extends ServerToClientFunctionResultSender {
    private static final Logger logger = LogService.getLogger();

    public ServerToClientFunctionResultSender65(ChunkedMessage msg, int messageType2, ServerConnection sc, Function function, ExecuteFunctionOperationContext authzContext) {
        super(msg, messageType2, sc, function, authzContext);
    }

    @Override
    public synchronized void lastResult(Object oneResult) {
        block11: {
            if (this.lastResultReceived) {
                return;
            }
            this.lastResultReceived = true;
            if (!this.isOkayToSendResult()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(" ServerToClientFunctionResultSender65 not sending lastResult {} as the server has shutdown", new Object[]{oneResult});
                }
                return;
            }
            try {
                this.authorizeResult(oneResult);
                if (!this.fn.hasResult()) {
                    throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
                }
                if (!this.headerSent) {
                    this.sendHeader();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(" ServerToClientFunctionResultSender65 sending lastResult {}", new Object[]{oneResult});
                }
                InternalDistributedMember memberID = InternalDistributedSystem.getAnyInstance().getDistributionManager().getId();
                ArrayList<Object> result = new ArrayList<Object>();
                result.add(oneResult);
                result.add(memberID);
                this.setBuffer();
                this.msg.setServerConnection(this.sc);
                if (oneResult instanceof InternalFunctionException) {
                    this.msg.setNumberOfParts(2);
                    this.msg.setLastChunkAndNumParts(true, 2);
                } else {
                    this.msg.setNumberOfParts(1);
                    this.msg.setLastChunkAndNumParts(true, 1);
                }
                this.msg.addObjPart(result);
                if (oneResult instanceof InternalFunctionException) {
                    ArrayList<Object> result2 = new ArrayList<Object>();
                    result2.add(BaseCommand.getExceptionTrace((Throwable)oneResult));
                    result2.add(memberID);
                    this.msg.addObjPart(result2);
                }
                this.msg.sendChunk(this.sc);
                this.sc.setAsTrue(1);
                FunctionStats.getFunctionStats(this.fn.getId(), null).incResultsReturned();
            }
            catch (IOException ex) {
                if (!this.isOkayToSendResult()) break block11;
                throw new FunctionException(LocalizedStrings.ExecuteFunction_IOEXCEPTION_WHILE_SENDING_LAST_CHUNK.toLocalizedString(), ex);
            }
        }
    }

    @Override
    public synchronized void lastResult(Object oneResult, DistributedMember memberID) {
        block10: {
            this.lastResultReceived = true;
            if (!this.isOkayToSendResult()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(" ServerToClientFunctionResultSender65 not sending lastResult {} as the server has shutdown", new Object[]{oneResult});
                }
                return;
            }
            try {
                this.authorizeResult(oneResult);
                if (!this.fn.hasResult()) {
                    throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
                }
                if (!this.headerSent) {
                    this.sendHeader();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(" ServerToClientFunctionResultSender65 sending lastResult {}", new Object[]{oneResult});
                }
                ArrayList<Object> result = new ArrayList<Object>();
                result.add(oneResult);
                result.add(memberID);
                this.setBuffer();
                this.msg.setServerConnection(this.sc);
                if (oneResult instanceof InternalFunctionException) {
                    this.msg.setNumberOfParts(2);
                    this.msg.setLastChunkAndNumParts(true, 2);
                } else {
                    this.msg.setNumberOfParts(1);
                    this.msg.setLastChunkAndNumParts(true, 1);
                }
                this.msg.addObjPart(result);
                if (oneResult instanceof InternalFunctionException) {
                    ArrayList<Object> result2 = new ArrayList<Object>();
                    result2.add(BaseCommand.getExceptionTrace((Throwable)oneResult));
                    result2.add(memberID);
                    this.msg.addObjPart(result2);
                }
                this.msg.sendChunk(this.sc);
                this.sc.setAsTrue(1);
                FunctionStats.getFunctionStats(this.fn.getId(), null).incResultsReturned();
            }
            catch (IOException ex) {
                if (!this.isOkayToSendResult()) break block10;
                throw new FunctionException(LocalizedStrings.ExecuteFunction_IOEXCEPTION_WHILE_SENDING_LAST_CHUNK.toLocalizedString(), ex);
            }
        }
    }

    @Override
    public synchronized void sendResult(Object oneResult) {
        block7: {
            if (!this.isOkayToSendResult()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(" ServerToClientFunctionResultSender65 not sending result {}  as the server has shutdown", new Object[]{oneResult});
                }
                return;
            }
            try {
                this.authorizeResult(oneResult);
                if (!this.fn.hasResult()) {
                    throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
                }
                if (!this.headerSent) {
                    this.sendHeader();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(" ServerToClientFunctionResultSender65 sending result {}", new Object[]{oneResult});
                }
                InternalDistributedMember memberID = InternalDistributedSystem.getAnyInstance().getDistributionManager().getId();
                ArrayList<Object> result = new ArrayList<Object>();
                result.add(oneResult);
                result.add(memberID);
                this.setBuffer();
                this.msg.setNumberOfParts(1);
                this.msg.addObjPart(result);
                this.msg.sendChunk(this.sc);
                FunctionStats.getFunctionStats(this.fn.getId(), null).incResultsReturned();
            }
            catch (IOException ex) {
                if (!this.isOkayToSendResult()) break block7;
                throw new FunctionException(LocalizedStrings.ExecuteFunction_IOEXCEPTION_WHILE_SENDING_RESULT_CHUNK.toLocalizedString(), ex);
            }
        }
    }

    @Override
    public synchronized void sendResult(Object oneResult, DistributedMember memberID) {
        block7: {
            if (!this.isOkayToSendResult()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(" ServerToClientFunctionResultSender65 not sending result {}  as the server has shutdown", new Object[]{oneResult});
                }
                return;
            }
            try {
                this.authorizeResult(oneResult);
                if (!this.fn.hasResult()) {
                    throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
                }
                if (!this.headerSent) {
                    this.sendHeader();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(" ServerToClientFunctionResultSender65 sending result {}", new Object[]{oneResult});
                }
                ArrayList<Object> result = new ArrayList<Object>();
                result.add(oneResult);
                result.add(memberID);
                this.setBuffer();
                this.msg.setNumberOfParts(1);
                this.msg.addObjPart(result);
                this.msg.sendChunk(this.sc);
                FunctionStats.getFunctionStats(this.fn.getId(), null).incResultsReturned();
            }
            catch (IOException ex) {
                if (!this.isOkayToSendResult()) break block7;
                throw new FunctionException(LocalizedStrings.ExecuteFunction_IOEXCEPTION_WHILE_SENDING_RESULT_CHUNK.toLocalizedString(), ex);
            }
        }
    }

    @Override
    protected void writeFunctionExceptionResponse(ChunkedMessage message, String errormessage, Throwable e) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug(" ServerToClientFunctionResultSender sending Function Error Response : {}", new Object[]{errormessage});
        }
        int numParts = 0;
        message.clear();
        if (e instanceof FunctionException && e.getCause() instanceof InternalFunctionInvocationTargetException) {
            message.setNumberOfParts(3);
            message.addObjPart(e);
            message.addStringPart(BaseCommand.getExceptionTrace(e));
            InternalFunctionInvocationTargetException fe = (InternalFunctionInvocationTargetException)e.getCause();
            message.addObjPart(fe.getFailedNodeSet());
            numParts = 3;
        } else {
            if (e instanceof FunctionException && e.getCause() instanceof QueryInvalidException) {
                e = new FunctionException(e.getLocalizedMessage());
            }
            message.setNumberOfParts(2);
            message.addObjPart(e);
            message.addStringPart(BaseCommand.getExceptionTrace(e));
            numParts = 2;
        }
        message.setServerConnection(this.sc);
        message.setLastChunkAndNumParts(true, numParts);
        message.sendChunk(this.sc);
        this.sc.setAsTrue(1);
    }
}

