/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.cache.operations.ExecuteFunctionOperationContext;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.execute.FunctionStats;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionException;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequestPP;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;

public class ServerToClientFunctionResultSender
implements ResultSender {
    private static final Logger logger = LogService.getLogger();
    protected ChunkedMessage msg = null;
    protected ServerConnection sc = null;
    protected int messageType = -1;
    protected volatile boolean headerSent = false;
    protected Function fn;
    protected ExecuteFunctionOperationContext authContext;
    protected InternalDistributedSystem ids = InternalDistributedSystem.getAnyInstance();
    protected AtomicBoolean alreadySendException = new AtomicBoolean(false);
    protected boolean lastResultReceived;
    protected ByteBuffer commBuffer;
    protected boolean isSelector;

    public boolean isLastResultReceived() {
        return this.lastResultReceived;
    }

    public ServerToClientFunctionResultSender(ChunkedMessage msg, int messageType2, ServerConnection sc, Function function, ExecuteFunctionOperationContext authzContext) {
        this.msg = msg;
        this.msg.setVersion(sc.getClientVersion());
        this.messageType = messageType2;
        this.sc = sc;
        this.fn = function;
        this.authContext = authzContext;
        this.isSelector = sc.getAcceptor().isSelector();
        if (this.isSelector) {
            this.commBuffer = msg.getCommBuffer();
        }
    }

    public synchronized void lastResult(Object oneResult) {
        block8: {
            this.lastResultReceived = true;
            if (!this.isOkayToSendResult()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender not sending lastResult {} as the server has shutdown", new Object[]{oneResult});
                }
                return;
            }
            if (this.lastResultReceived) {
                return;
            }
            try {
                this.authorizeResult(oneResult);
                if (!this.fn.hasResult()) {
                    throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
                }
                if (!this.headerSent) {
                    this.sendHeader();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender sending lastResult {}", new Object[]{oneResult});
                }
                this.setBuffer();
                this.msg.setNumberOfParts(1);
                this.msg.addObjPart(oneResult);
                this.msg.setLastChunk(true);
                this.msg.sendChunk(this.sc);
                this.sc.setAsTrue(1);
                FunctionStats.getFunctionStats(this.fn.getId(), null).incResultsReturned();
            }
            catch (IOException ex) {
                if (!this.isOkayToSendResult()) break block8;
                throw new FunctionException(LocalizedStrings.ExecuteFunction_IOEXCEPTION_WHILE_SENDING_LAST_CHUNK.toLocalizedString(), ex);
            }
        }
    }

    public synchronized void lastResult(Object oneResult, DistributedMember memberID) {
        block7: {
            this.lastResultReceived = true;
            if (!this.isOkayToSendResult()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender not sending lastResult {} as the server has shutdown", new Object[]{oneResult});
                }
                return;
            }
            try {
                this.authorizeResult(oneResult);
                if (!this.fn.hasResult()) {
                    throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
                }
                if (!this.headerSent) {
                    this.sendHeader();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender sending lastResult {}", new Object[]{oneResult});
                }
                this.setBuffer();
                this.msg.setNumberOfParts(1);
                this.msg.addObjPart(oneResult);
                this.msg.setLastChunk(true);
                this.msg.sendChunk(this.sc);
                this.sc.setAsTrue(1);
                FunctionStats.getFunctionStats(this.fn.getId(), null).incResultsReturned();
            }
            catch (IOException ex) {
                if (!this.isOkayToSendResult()) break block7;
                throw new FunctionException(LocalizedStrings.ExecuteFunction_IOEXCEPTION_WHILE_SENDING_LAST_CHUNK.toLocalizedString(), ex);
            }
        }
    }

    public synchronized void sendResult(Object oneResult) {
        block7: {
            if (!this.isOkayToSendResult()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender not sending result {} as the server has shutdown", new Object[]{oneResult});
                }
                return;
            }
            try {
                this.authorizeResult(oneResult);
                if (!this.fn.hasResult()) {
                    throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
                }
                if (!this.headerSent) {
                    this.sendHeader();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender sending result {}", new Object[]{oneResult});
                }
                this.setBuffer();
                this.msg.setNumberOfParts(1);
                this.msg.addObjPart(oneResult);
                this.msg.sendChunk(this.sc);
                FunctionStats.getFunctionStats(this.fn.getId(), null).incResultsReturned();
            }
            catch (IOException ex) {
                if (!this.isOkayToSendResult()) break block7;
                throw new FunctionException(LocalizedStrings.ExecuteFunction_IOEXCEPTION_WHILE_SENDING_RESULT_CHUNK.toLocalizedString(), ex);
            }
        }
    }

    public synchronized void sendResult(Object oneResult, DistributedMember memberID) {
        block7: {
            if (!this.isOkayToSendResult()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender not sending result {} as the server has shutdown", new Object[]{oneResult});
                }
                return;
            }
            try {
                this.authorizeResult(oneResult);
                if (!this.fn.hasResult()) {
                    throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
                }
                if (!this.headerSent) {
                    this.sendHeader();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerToClientFunctionResultSender sending result {}", new Object[]{oneResult});
                }
                this.setBuffer();
                this.msg.setNumberOfParts(1);
                this.msg.addObjPart(oneResult);
                this.msg.sendChunk(this.sc);
                FunctionStats.getFunctionStats(this.fn.getId(), null).incResultsReturned();
            }
            catch (IOException ex) {
                if (!this.isOkayToSendResult()) break block7;
                throw new FunctionException(LocalizedStrings.ExecuteFunction_IOEXCEPTION_WHILE_SENDING_RESULT_CHUNK.toLocalizedString(), ex);
            }
        }
    }

    protected void authorizeResult(Object oneResult) throws IOException {
        AuthorizeRequestPP authzRequestPP = this.sc.getPostAuthzRequest();
        if (authzRequestPP != null) {
            this.authContext.setIsPostOperation(true);
            this.authContext = authzRequestPP.executeFunctionAuthorize(oneResult, this.authContext);
        }
    }

    protected void writeFunctionExceptionResponse(ChunkedMessage message, String errormessage, Throwable e) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("ServerToClientFunctionResultSender sending Function Error Response: {}", new Object[]{errormessage});
        }
        message.clear();
        message.setLastChunk(true);
        message.addObjPart(e);
        message.sendChunk(this.sc);
        this.sc.setAsTrue(1);
    }

    protected void sendHeader() throws IOException {
        this.setBuffer();
        this.msg.setMessageType(this.messageType);
        this.msg.setLastChunk(false);
        this.msg.setNumberOfParts(1);
        this.msg.sendHeader();
        this.headerSent = true;
    }

    @Override
    public void sendException(Throwable exception) {
        InternalFunctionException iFunxtionException = new InternalFunctionException(exception);
        this.lastResult(iFunxtionException);
        this.lastResultReceived = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setException(Throwable exception) {
        this.lastResultReceived = true;
        ChunkedMessage chunkedMessage = this.msg;
        synchronized (chunkedMessage) {
            if (!this.sc.getTransientFlag(1)) {
                this.alreadySendException.set(true);
                try {
                    if (!this.headerSent) {
                        this.sendHeader();
                    }
                    String exceptionMessage = exception.getMessage() != null ? exception.getMessage() : "Exception occured during function execution";
                    logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteRegionFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, this.fn), exception);
                    if (logger.isDebugEnabled()) {
                        logger.debug("ServerToClientFunctionResultSender sending Function Exception : ");
                    }
                    this.writeFunctionExceptionResponse(this.msg, exceptionMessage, exception);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected boolean isOkayToSendResult() {
        return this.sc.getAcceptor().isRunning() && !this.ids.isDisconnecting() && !this.sc.getCachedRegionHelper().getCache().isClosed() && !this.alreadySendException.get();
    }

    protected void setBuffer() {
        if (this.isSelector) {
            Message.setTLCommBuffer(this.commBuffer);
        }
    }
}

