/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.internal.ProxyCache;
import com.gemstone.gemfire.cache.client.internal.ServerRegionProxy;
import com.gemstone.gemfire.cache.client.internal.UserAttributes;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TXStateProxyImpl;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.DefaultResultCollector;
import com.gemstone.gemfire.internal.cache.execute.FunctionStats;
import com.gemstone.gemfire.internal.cache.execute.InternalExecution;
import com.gemstone.gemfire.internal.cache.execute.MemberMappedArgument;
import com.gemstone.gemfire.internal.cache.execute.NoResult;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class ServerRegionFunctionExecutor
extends AbstractExecution {
    private static final Logger logger = LogService.getLogger();
    private final LocalRegion region;
    private boolean executeOnBucketSet = false;

    public ServerRegionFunctionExecutor(Region r, ProxyCache proxyCache) {
        if (r == null) {
            throw new IllegalArgumentException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("Region"));
        }
        this.region = (LocalRegion)r;
        this.proxyCache = proxyCache;
    }

    private ServerRegionFunctionExecutor(ServerRegionFunctionExecutor serverRegionFunctionExecutor, Object args) {
        super(serverRegionFunctionExecutor);
        this.region = serverRegionFunctionExecutor.region;
        this.filter.clear();
        this.filter.addAll(serverRegionFunctionExecutor.filter);
        this.args = args;
        this.executeOnBucketSet = serverRegionFunctionExecutor.executeOnBucketSet;
    }

    private ServerRegionFunctionExecutor(ServerRegionFunctionExecutor serverRegionFunctionExecutor, MemberMappedArgument memberMapargs) {
        super(serverRegionFunctionExecutor);
        this.region = serverRegionFunctionExecutor.region;
        this.filter.clear();
        this.filter.addAll(serverRegionFunctionExecutor.filter);
        this.memberMappedArg = memberMapargs;
        this.executeOnBucketSet = serverRegionFunctionExecutor.executeOnBucketSet;
    }

    private ServerRegionFunctionExecutor(ServerRegionFunctionExecutor serverRegionFunctionExecutor, ResultCollector rc) {
        super(serverRegionFunctionExecutor);
        this.region = serverRegionFunctionExecutor.region;
        this.filter.clear();
        this.filter.addAll(serverRegionFunctionExecutor.filter);
        this.rc = rc;
        this.executeOnBucketSet = serverRegionFunctionExecutor.executeOnBucketSet;
    }

    private ServerRegionFunctionExecutor(ServerRegionFunctionExecutor serverRegionFunctionExecutor, Set filter2) {
        super(serverRegionFunctionExecutor);
        this.region = serverRegionFunctionExecutor.region;
        this.filter.clear();
        this.filter.addAll(filter2);
        this.executeOnBucketSet = serverRegionFunctionExecutor.executeOnBucketSet;
    }

    private ServerRegionFunctionExecutor(ServerRegionFunctionExecutor serverRegionFunctionExecutor, Set<Integer> bucketsAsFilter, boolean executeOnBucketSet) {
        super(serverRegionFunctionExecutor);
        this.region = serverRegionFunctionExecutor.region;
        this.filter.clear();
        this.filter.addAll(bucketsAsFilter);
        this.executeOnBucketSet = executeOnBucketSet;
    }

    public Execution withFilter(Set fltr) {
        if (fltr == null) {
            throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("filter"));
        }
        this.executeOnBucketSet = false;
        return new ServerRegionFunctionExecutor(this, fltr);
    }

    @Override
    public InternalExecution withBucketFilter(Set<Integer> bucketIDs) {
        if (bucketIDs == null) {
            throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("buckets as filter"));
        }
        return new ServerRegionFunctionExecutor(this, bucketIDs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ResultCollector executeFunction(Function function) {
        byte hasResult = 0;
        try {
            if (this.proxyCache != null) {
                if (this.proxyCache.isClosed()) {
                    throw new CacheClosedException("Cache is closed for this user.");
                }
                UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
            }
            if (function.hasResult()) {
                hasResult = 1;
                if (this.rc == null) {
                    DefaultResultCollector defaultCollector = new DefaultResultCollector();
                    ResultCollector resultCollector = this.executeOnServer(function, defaultCollector, hasResult);
                    return resultCollector;
                }
                ResultCollector resultCollector = this.executeOnServer(function, this.rc, hasResult);
                return resultCollector;
            }
            this.executeOnServerNoAck(function, hasResult);
            NoResult noResult = new NoResult();
            return noResult;
        }
        finally {
            UserAttributes.userAttributes.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultCollector executeFunction(String functionId, boolean resultReq, boolean isHA, boolean optimizeForWrite) {
        try {
            if (this.proxyCache != null) {
                if (this.proxyCache.isClosed()) {
                    throw new CacheClosedException("Cache is closed for this user.");
                }
                UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
            }
            byte hasResult = 0;
            if (resultReq) {
                hasResult = 1;
                if (this.rc == null) {
                    DefaultResultCollector defaultCollector = new DefaultResultCollector();
                    ResultCollector resultCollector = this.executeOnServer(functionId, defaultCollector, hasResult, isHA, optimizeForWrite);
                    return resultCollector;
                }
                ResultCollector resultCollector = this.executeOnServer(functionId, this.rc, hasResult, isHA, optimizeForWrite);
                return resultCollector;
            }
            this.executeOnServerNoAck(functionId, hasResult, isHA, optimizeForWrite);
            NoResult noResult = new NoResult();
            return noResult;
        }
        finally {
            UserAttributes.userAttributes.set(null);
        }
    }

    private ResultCollector executeOnServer(Function function, ResultCollector collector, byte hasResult) throws FunctionException {
        ServerRegionProxy srp = this.getServerRegionProxy();
        FunctionStats stats = FunctionStats.getFunctionStats(function.getId(), this.region.getSystem());
        try {
            this.validateExecution(function, null);
            long start = stats.startTime();
            stats.startFunctionExecution(true);
            srp.executeFunction(this.region.getFullPath(), function, this, collector, hasResult, false);
            stats.endFunctionExecution(start, true);
            return collector;
        }
        catch (FunctionException functionException) {
            stats.endFunctionExecutionWithException(true);
            throw functionException;
        }
        catch (Exception exception) {
            stats.endFunctionExecutionWithException(true);
            throw new FunctionException(exception);
        }
    }

    private ResultCollector executeOnServer(String functionId, ResultCollector collector, byte hasResult, boolean isHA, boolean optimizeForWrite) throws FunctionException {
        ServerRegionProxy srp = this.getServerRegionProxy();
        FunctionStats stats = FunctionStats.getFunctionStats(functionId, this.region.getSystem());
        try {
            this.validateExecution(null, null);
            long start = stats.startTime();
            stats.startFunctionExecution(true);
            srp.executeFunction(this.region.getFullPath(), functionId, this, collector, hasResult, isHA, optimizeForWrite, false);
            stats.endFunctionExecution(start, true);
            return collector;
        }
        catch (FunctionException functionException) {
            stats.endFunctionExecutionWithException(true);
            throw functionException;
        }
        catch (Exception exception) {
            stats.endFunctionExecutionWithException(true);
            throw new FunctionException(exception);
        }
    }

    private void executeOnServerNoAck(Function function, byte hasResult) throws FunctionException {
        ServerRegionProxy srp = this.getServerRegionProxy();
        FunctionStats stats = FunctionStats.getFunctionStats(function.getId(), this.region.getSystem());
        try {
            this.validateExecution(function, null);
            long start = stats.startTime();
            stats.startFunctionExecution(false);
            srp.executeFunctionNoAck(this.region.getFullPath(), function, this, hasResult, false);
            stats.endFunctionExecution(start, false);
        }
        catch (FunctionException functionException) {
            stats.endFunctionExecutionWithException(false);
            throw functionException;
        }
        catch (Exception exception) {
            stats.endFunctionExecutionWithException(false);
            throw new FunctionException(exception);
        }
    }

    private void executeOnServerNoAck(String functionId, byte hasResult, boolean isHA, boolean optimizeForWrite) throws FunctionException {
        ServerRegionProxy srp = this.getServerRegionProxy();
        FunctionStats stats = FunctionStats.getFunctionStats(functionId, this.region.getSystem());
        try {
            this.validateExecution(null, null);
            long start = stats.startTime();
            stats.startFunctionExecution(false);
            srp.executeFunctionNoAck(this.region.getFullPath(), functionId, this, hasResult, isHA, optimizeForWrite, false);
            stats.endFunctionExecution(start, false);
        }
        catch (FunctionException functionException) {
            stats.endFunctionExecutionWithException(false);
            throw functionException;
        }
        catch (Exception exception) {
            stats.endFunctionExecutionWithException(false);
            throw new FunctionException(exception);
        }
    }

    private ServerRegionProxy getServerRegionProxy() throws FunctionException {
        ServerRegionProxy srp = this.region.getServerProxy();
        if (srp != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Found server region proxy on region. RegionName: {}", new Object[]{this.region.getName()});
            }
            return srp;
        }
        StringBuffer message = new StringBuffer();
        message.append(srp).append(": ");
        message.append("No available connection was found. Server Region Proxy is not available for this region " + this.region.getName());
        throw new FunctionException(message.toString());
    }

    public LocalRegion getRegion() {
        return this.region;
    }

    public String toString() {
        return new StringBuffer().append("[ ServerRegionExecutor:").append("args=").append(this.args).append(" ;filter=").append(this.filter).append(" ;region=").append(this.region.getName()).append("]").toString();
    }

    @Override
    public Execution withArgs(Object params) {
        if (params == null) {
            throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("args"));
        }
        return new ServerRegionFunctionExecutor(this, params);
    }

    public Execution withCollector(ResultCollector rs) {
        if (rs == null) {
            throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("Result Collector"));
        }
        return new ServerRegionFunctionExecutor(this, rs);
    }

    @Override
    public InternalExecution withMemberMappedArgument(MemberMappedArgument argument) {
        if (argument == null) {
            throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("MemberMappedArgument"));
        }
        return new ServerRegionFunctionExecutor(this, argument);
    }

    @Override
    public void validateExecution(Function function, Set targetMembers) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && cache.getTxManager().getTXState() != null) {
            TXStateProxyImpl tx = (TXStateProxyImpl)cache.getTxManager().getTXState();
            tx.getRealDeal(null, this.region);
            tx.incOperationCount();
        }
    }

    @Override
    public ResultCollector execute(String functionName) {
        if (functionName == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_INPUT_FUNCTION_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString());
        }
        this.isFnSerializationReqd = false;
        Function functionObject = FunctionService.getFunction(functionName);
        if (functionObject == null) {
            byte[] functionAttributes = this.getFunctionAttributes(functionName);
            if (functionAttributes == null) {
                ServerRegionProxy srp = this.getServerRegionProxy();
                byte[] obj = srp.getFunctionAttributes(functionName);
                functionAttributes = obj;
                this.addFunctionAttributes(functionName, functionAttributes);
            }
            boolean hasResult = functionAttributes[0] == 1;
            boolean isHA = functionAttributes[1] == 1;
            boolean optimizeForWrite = functionAttributes[2] == 1;
            return this.executeFunction(functionName, hasResult, isHA, optimizeForWrite);
        }
        return this.executeFunction(functionObject);
    }

    @Override
    public ResultCollector execute(String functionName, boolean hasResult) throws FunctionException {
        byte functionState;
        if (functionName == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_INPUT_FUNCTION_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString());
        }
        this.isFnSerializationReqd = false;
        Function functionObject = FunctionService.getFunction(functionName);
        if (functionObject == null) {
            return this.executeFunction(functionName, hasResult, hasResult, false);
        }
        byte registeredFunctionState = AbstractExecution.getFunctionState(functionObject.isHA(), functionObject.hasResult(), functionObject.optimizeForWrite());
        if (registeredFunctionState != (functionState = AbstractExecution.getFunctionState(hasResult, hasResult, false))) {
            throw new FunctionException(LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH_CLIENT_SERVER.toLocalizedString(functionName));
        }
        return this.executeFunction(functionObject);
    }

    @Override
    public ResultCollector execute(String functionName, boolean hasResult, boolean isHA) throws FunctionException {
        byte functionState;
        if (functionName == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_INPUT_FUNCTION_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString());
        }
        this.isFnSerializationReqd = false;
        if (isHA && !hasResult) {
            throw new FunctionException(LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH.toLocalizedString());
        }
        Function functionObject = FunctionService.getFunction(functionName);
        if (functionObject == null) {
            return this.executeFunction(functionName, hasResult, isHA, false);
        }
        byte registeredFunctionState = AbstractExecution.getFunctionState(functionObject.isHA(), functionObject.hasResult(), functionObject.optimizeForWrite());
        if (registeredFunctionState != (functionState = AbstractExecution.getFunctionState(isHA, hasResult, false))) {
            throw new FunctionException(LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH_CLIENT_SERVER.toLocalizedString(functionName));
        }
        return this.executeFunction(functionObject);
    }

    @Override
    public ResultCollector execute(String functionName, boolean hasResult, boolean isHA, boolean isOptimizeForWrite) throws FunctionException {
        byte functionState;
        if (functionName == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_INPUT_FUNCTION_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString());
        }
        this.isFnSerializationReqd = false;
        if (isHA && !hasResult) {
            throw new FunctionException(LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH.toLocalizedString());
        }
        Function functionObject = FunctionService.getFunction(functionName);
        if (functionObject == null) {
            return this.executeFunction(functionName, hasResult, isHA, isOptimizeForWrite);
        }
        byte registeredFunctionState = AbstractExecution.getFunctionState(functionObject.isHA(), functionObject.hasResult(), functionObject.optimizeForWrite());
        if (registeredFunctionState != (functionState = AbstractExecution.getFunctionState(isHA, hasResult, isOptimizeForWrite))) {
            throw new FunctionException(LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH_CLIENT_SERVER.toLocalizedString(functionName));
        }
        return this.executeFunction(functionObject);
    }

    public boolean getExecuteOnBucketSetFlag() {
        return this.executeOnBucketSet;
    }
}

