/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.LowMemoryException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionDataNotColocatedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.SetUtils;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.MemoryThresholds;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.DefaultResultCollector;
import com.gemstone.gemfire.internal.cache.execute.InternalExecution;
import com.gemstone.gemfire.internal.cache.execute.LocalResultCollector;
import com.gemstone.gemfire.internal.cache.execute.MemberFunctionResultSender;
import com.gemstone.gemfire.internal.cache.execute.MemberMappedArgument;
import com.gemstone.gemfire.internal.cache.execute.MultiRegionFunctionContextImpl;
import com.gemstone.gemfire.internal.cache.execute.MultiRegionFunctionResultWaiter;
import com.gemstone.gemfire.internal.cache.execute.NoResult;
import com.gemstone.gemfire.internal.cache.execute.ServerToClientFunctionResultSender;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class MultiRegionFunctionExecutor
extends AbstractExecution {
    private final Set<Region> regions;
    private ServerToClientFunctionResultSender sender;

    public MultiRegionFunctionExecutor(Set<Region> regions) {
        this.regions = regions;
    }

    private MultiRegionFunctionExecutor(MultiRegionFunctionExecutor drfe) {
        super(drfe);
        this.regions = drfe.regions;
        if (drfe.filter != null) {
            this.filter.clear();
            this.filter.addAll(drfe.filter);
        }
        this.sender = drfe.sender;
    }

    private MultiRegionFunctionExecutor(Set<Region> regions, Set filter2, Object args, MemberMappedArgument memberMappedArg, ServerToClientFunctionResultSender resultSender) {
        if (args != null) {
            this.args = args;
        } else if (memberMappedArg != null) {
            this.memberMappedArg = memberMappedArg;
            this.isMemberMappedArgument = true;
        }
        this.sender = resultSender;
        if (filter2 != null) {
            this.filter.clear();
            this.filter.addAll(filter2);
        }
        this.regions = regions;
        this.isClientServerMode = true;
    }

    private MultiRegionFunctionExecutor(MultiRegionFunctionExecutor executor, MemberMappedArgument argument) {
        super(executor);
        this.regions = executor.getRegions();
        this.filter.clear();
        this.filter.addAll(executor.filter);
        this.sender = executor.getServerResultSender();
        this.memberMappedArg = argument;
        this.isMemberMappedArgument = true;
    }

    private MultiRegionFunctionExecutor(MultiRegionFunctionExecutor executor, ResultCollector rs) {
        super(executor);
        this.regions = executor.getRegions();
        this.filter.clear();
        this.filter.addAll(executor.filter);
        this.sender = executor.getServerResultSender();
        this.rc = rs;
    }

    public MultiRegionFunctionExecutor(MultiRegionFunctionExecutor executor, Object args) {
        super(executor);
        this.regions = executor.getRegions();
        this.filter.clear();
        this.filter.addAll(executor.filter);
        this.sender = executor.getServerResultSender();
        this.args = args;
    }

    public MultiRegionFunctionExecutor(MultiRegionFunctionExecutor executor, boolean isReExecute) {
        super(executor);
        this.regions = executor.getRegions();
        this.filter.clear();
        this.filter.addAll(executor.filter);
        this.sender = executor.getServerResultSender();
        this.isReExecute = isReExecute;
    }

    @Override
    public InternalExecution withMemberMappedArgument(MemberMappedArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("MemberMapped Arg"));
        }
        return new MultiRegionFunctionExecutor(this, argument);
    }

    public Set<Region> getRegions() {
        return this.regions;
    }

    public ServerToClientFunctionResultSender getServerResultSender() {
        return this.sender;
    }

    @Override
    public Execution withArgs(Object args) {
        if (args == null) {
            throw new IllegalArgumentException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("args"));
        }
        return new MultiRegionFunctionExecutor(this, args);
    }

    @Override
    public Execution withCollector(ResultCollector<?, ?> rc) {
        if (rc == null) {
            throw new IllegalArgumentException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("Result Collector"));
        }
        return new MultiRegionFunctionExecutor(this, rc);
    }

    @Override
    public Execution withFilter(Set<?> filter) {
        throw new FunctionException(LocalizedStrings.ExecuteFunction_CANNOT_SPECIFY_0_FOR_ONREGIONS_FUNCTION.toLocalizedString("filter"));
    }

    @Override
    public InternalExecution withBucketFilter(Set<Integer> bucketIDs) {
        throw new FunctionException(LocalizedStrings.ExecuteFunction_CANNOT_SPECIFY_0_FOR_ONREGIONS_FUNCTION.toLocalizedString("bucket as filter"));
    }

    @Override
    public AbstractExecution withRoutingObjects(Set<Object> routingObjects) {
        throw new FunctionException(LocalizedStrings.ExecuteFunction_CANNOT_SPECIFY_0_FOR_ONREGIONS_FUNCTION.toLocalizedString("routing objects"));
    }

    @Override
    protected ResultCollector executeFunction(Function function) {
        if (function.hasResult()) {
            ResultCollector rc = this.rc;
            if (rc == null) {
                rc = new DefaultResultCollector();
            }
            return this.executeFunction(function, rc);
        }
        this.executeFunction(function, null);
        return new NoResult();
    }

    private ResultCollector executeFunction(Function function, ResultCollector resultCollector) {
        InternalDistributedSystem ds = InternalDistributedSystem.getConnectedInstance();
        if (ds == null) {
            throw new IllegalStateException(LocalizedStrings.ExecuteFunction_DS_NOT_CREATED_OR_NOT_READY.toLocalizedString());
        }
        DM dm = ds.getDistributionManager();
        Map<InternalDistributedMember, Set<String>> memberToRegionMap = this.calculateMemberToRegionMap();
        HashSet<InternalDistributedMember> dest = new HashSet<InternalDistributedMember>(memberToRegionMap.keySet());
        if (dest.isEmpty()) {
            throw new FunctionException(LocalizedStrings.MemberFunctionExecutor_NO_MEMBER_FOUND_FOR_EXECUTING_FUNCTION_0.toLocalizedString(function.getId()));
        }
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (function.optimizeForWrite() && cache != null && cache.getResourceManager().getHeapMonitor().containsHeapCriticalMembers(dest) && !MemoryThresholds.isLowMemoryExceptionDisabled()) {
            Set<InternalDistributedMember> hcm = cache.getResourceAdvisor().adviseCritialMembers();
            Set sm = SetUtils.intersection(hcm, dest);
            throw new LowMemoryException(LocalizedStrings.ResourceManager_LOW_MEMORY_FOR_0_FUNCEXEC_MEMBERS_1.toLocalizedString(function.getId(), sm), sm);
        }
        this.setExecutionNodes(dest);
        InternalDistributedMember localVM = cache.getMyId();
        LocalResultCollector<?, ?> localResultCollector = this.getLocalResultCollector(function, resultCollector);
        boolean remoteOnly = false;
        boolean localOnly = false;
        if (!dest.contains(localVM)) {
            remoteOnly = true;
        }
        if (dest.size() == 1 && dest.contains(localVM)) {
            localOnly = true;
        }
        this.validateExecution(function, dest);
        MemberFunctionResultSender resultSender = new MemberFunctionResultSender(dm, localResultCollector, function, localOnly, remoteOnly, null);
        if (dest.contains(localVM)) {
            dest.remove(localVM);
            Set<String> regionPathSet = memberToRegionMap.get(localVM);
            HashSet regions = new HashSet();
            if (regionPathSet != null) {
                GemFireCacheImpl cache1 = GemFireCacheImpl.getInstance();
                for (String regionPath : regionPathSet) {
                    regions.add(cache1.getRegion(regionPath));
                }
            }
            MultiRegionFunctionContextImpl context = new MultiRegionFunctionContextImpl(function.getId(), this.getArgumentsForMember(localVM.getId()), resultSender, regions, this.isReExecute);
            boolean isTx = cache.getTxManager().getTXState() != null;
            this.executeFunctionOnLocalNode(function, context, resultSender, dm, isTx);
        }
        if (!dest.isEmpty()) {
            HashMap<InternalDistributedMember, Object> memberArgs = new HashMap<InternalDistributedMember, Object>();
            for (InternalDistributedMember recip : dest) {
                memberArgs.put(recip, this.getArgumentsForMember(recip.getId()));
            }
            Assert.assertTrue(memberArgs.size() == dest.size());
            MultiRegionFunctionResultWaiter waiter = new MultiRegionFunctionResultWaiter(ds, localResultCollector, function, dest, memberArgs, resultSender, memberToRegionMap);
            ResultCollector reply = waiter.getFunctionResultFrom(dest, function, this);
            return reply;
        }
        return localResultCollector;
    }

    private Map<InternalDistributedMember, Set<String>> calculateMemberToRegionMap() {
        HashMap<InternalDistributedMember, Set<String>> memberToRegions = new HashMap<InternalDistributedMember, Set<String>>();
        HashSet nodes = new HashSet();
        for (Region region : this.regions) {
            InternalDistributedMember local;
            GemFireCacheImpl cache;
            Set<String> regions;
            DataPolicy dp = region.getAttributes().getDataPolicy();
            if (region instanceof PartitionedRegion) {
                PartitionedRegion pr = (PartitionedRegion)region;
                Set prMembers = pr.getRegionAdvisor().advisePrimaryOwners();
                if (pr.isDataStore()) {
                    GemFireCacheImpl cache2 = (GemFireCacheImpl)region.getCache();
                    InternalDistributedMember localVm = cache2.getMyId();
                    regions = (HashSet<String>)memberToRegions.get(localVm);
                    if (regions == null) {
                        regions = new HashSet<String>();
                    }
                    regions.add(pr.getFullPath());
                    memberToRegions.put(localVm, regions);
                }
                if (prMembers == null) continue;
                for (Object member : prMembers) {
                    regions = (Set)memberToRegions.get(member);
                    if (regions == null) {
                        regions = new HashSet();
                    }
                    regions.add(pr.getFullPath());
                    memberToRegions.put((InternalDistributedMember)member, regions);
                }
                nodes.addAll(prMembers);
                continue;
            }
            if (region instanceof DistributedRegion) {
                if (dp.isEmpty() || dp.isNormal()) {
                    Object member;
                    DistributedRegion dr = (DistributedRegion)region;
                    Set<InternalDistributedMember> replicates = dr.getCacheDistributionAdvisor().adviseInitializedReplicates();
                    boolean added = false;
                    member = replicates.iterator();
                    while (member.hasNext()) {
                        InternalDistributedMember member2 = (InternalDistributedMember)member.next();
                        if (!nodes.contains(member2)) continue;
                        added = true;
                        HashSet<String> regions2 = (HashSet<String>)memberToRegions.get(member2);
                        if (regions2 == null) {
                            regions2 = new HashSet<String>();
                        }
                        regions2.add(dr.getFullPath());
                        memberToRegions.put(member2, regions2);
                        break;
                    }
                    if (replicates.size() == 0 || added) continue;
                    member = (InternalDistributedMember)replicates.toArray()[new Random().nextInt(replicates.size())];
                    regions = (Set)memberToRegions.get(member);
                    if (regions == null) {
                        regions = new HashSet();
                    }
                    regions.add(dr.getFullPath());
                    memberToRegions.put((InternalDistributedMember)member, regions);
                    continue;
                }
                if (!dp.withReplication()) continue;
                cache = (GemFireCacheImpl)region.getCache();
                local = cache.getMyId();
                HashSet<String> regions3 = (HashSet<String>)memberToRegions.get(local);
                if (regions3 == null) {
                    regions3 = new HashSet<String>();
                }
                regions3.add(region.getFullPath());
                memberToRegions.put(local, regions3);
                continue;
            }
            if (!(region instanceof LocalRegion)) continue;
            cache = (GemFireCacheImpl)region.getCache();
            local = cache.getMyId();
            HashSet<String> regions4 = (HashSet<String>)memberToRegions.get(local);
            if (regions4 == null) {
                regions4 = new HashSet<String>();
            }
            regions4.add(region.getFullPath());
            memberToRegions.put(local, regions4);
        }
        return memberToRegions;
    }

    @Override
    public AbstractExecution setIsReExecute() {
        return new MultiRegionFunctionExecutor(this, true);
    }

    @Override
    public void validateExecution(Function function, Set targetMembers) {
        GemFireCacheImpl cache = null;
        Iterator<Region> iterator = this.regions.iterator();
        if (iterator.hasNext()) {
            Region r = iterator.next();
            cache = (GemFireCacheImpl)r.getCache();
        }
        if (cache != null && cache.getTxManager().getTXState() != null) {
            if (targetMembers.size() > 1) {
                throw new TransactionException(LocalizedStrings.PartitionedRegion_TX_FUNCTION_ON_MORE_THAN_ONE_NODE.toLocalizedString());
            }
            assert (targetMembers.size() == 1);
            DistributedMember funcTarget = (DistributedMember)targetMembers.iterator().next();
            DistributedMember target = cache.getTxManager().getTXState().getTarget();
            if (target == null) {
                cache.getTxManager().getTXState().setTarget(funcTarget);
            } else if (!target.equals(funcTarget)) {
                throw new TransactionDataNotColocatedException(LocalizedStrings.PartitionedRegion_TX_FUNCTION_EXECUTION_NOT_COLOCATED_0_1.toLocalizedString(target, funcTarget));
            }
        }
        if (function.optimizeForWrite() && cache.getResourceManager().getHeapMonitor().containsHeapCriticalMembers(targetMembers) && !MemoryThresholds.isLowMemoryExceptionDisabled()) {
            Set<InternalDistributedMember> hcm = cache.getResourceAdvisor().adviseCritialMembers();
            Set sm = SetUtils.intersection(hcm, targetMembers);
            throw new LowMemoryException(LocalizedStrings.ResourceManager_LOW_MEMORY_FOR_0_FUNCEXEC_MEMBERS_1.toLocalizedString(function.getId(), sm), sm);
        }
    }
}

