/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.MemberFunctionStreamingMessage;
import com.gemstone.gemfire.internal.cache.execute.FunctionStats;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionException;
import com.gemstone.gemfire.internal.cache.execute.InternalResultSender;
import com.gemstone.gemfire.internal.cache.execute.LocalResultCollector;
import com.gemstone.gemfire.internal.cache.execute.ServerToClientFunctionResultSender;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public final class MemberFunctionResultSender
implements InternalResultSender {
    private static final Logger logger = LogService.getLogger();
    MemberFunctionStreamingMessage msg = null;
    private final DM dm;
    private ResultCollector rc;
    private final Function function;
    private boolean localLastResultRecieved = false;
    private boolean onlyLocal = false;
    private boolean onlyRemote = false;
    private boolean completelyDoneFromRemote = false;
    private boolean enableOrderedResultStreming;
    private ServerToClientFunctionResultSender serverSender;

    public MemberFunctionResultSender(DM dm, MemberFunctionStreamingMessage msg, Function function) {
        this.msg = msg;
        this.dm = dm;
        this.function = function;
    }

    public MemberFunctionResultSender(DM dm, ResultCollector rc, Function function, boolean onlyLocal, boolean onlyRemote, ServerToClientFunctionResultSender sender) {
        this.dm = dm;
        this.rc = rc;
        this.function = function;
        this.onlyLocal = onlyLocal;
        this.onlyRemote = onlyRemote;
        this.serverSender = sender;
    }

    @Override
    public void lastResult(Object oneResult) {
        if (!this.function.hasResult()) {
            throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
        }
        if (this.serverSender != null) {
            if (this.localLastResultRecieved) {
                return;
            }
            if (this.onlyLocal) {
                this.serverSender.lastResult(oneResult);
                this.rc.endResults();
                this.localLastResultRecieved = true;
            } else {
                this.lastResult(oneResult, this.rc, false, true, this.dm.getId());
            }
        } else if (this.msg != null) {
            try {
                this.msg.sendReplyForOneResult(this.dm, oneResult, true, this.enableOrderedResultStreming);
            }
            catch (QueryException e) {
                throw new FunctionException(e);
            }
            catch (ForceReattemptException e) {
                throw new FunctionException(e);
            }
            catch (InterruptedException e) {
                throw new FunctionException(e);
            }
        } else {
            if (this.localLastResultRecieved) {
                return;
            }
            if (this.onlyLocal) {
                this.rc.addResult(this.dm.getDistributionManagerId(), oneResult);
                this.rc.endResults();
                this.localLastResultRecieved = true;
            } else {
                this.lastResult(oneResult, this.rc, false, true, this.dm.getDistributionManagerId());
            }
            FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReceived();
        }
        FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReturned();
    }

    private synchronized void lastResult(Object oneResult, ResultCollector collector, boolean lastRemoteResult, boolean lastLocalResult, DistributedMember memberID) {
        if (lastRemoteResult) {
            this.completelyDoneFromRemote = true;
        }
        if (lastLocalResult) {
            this.localLastResultRecieved = true;
        }
        if (this.serverSender != null) {
            if (this.completelyDoneFromRemote && this.localLastResultRecieved) {
                this.serverSender.lastResult(oneResult, memberID);
                collector.endResults();
            } else {
                this.serverSender.sendResult(oneResult, memberID);
            }
        } else if (this.completelyDoneFromRemote && this.localLastResultRecieved) {
            collector.addResult(memberID, oneResult);
            collector.endResults();
        } else {
            collector.addResult(memberID, oneResult);
        }
    }

    public void lastResult(Object oneResult, boolean completelyDone, ResultCollector reply, DistributedMember memberID) {
        if (this.serverSender != null) {
            if (completelyDone) {
                if (this.onlyRemote) {
                    this.serverSender.lastResult(oneResult, memberID);
                    reply.endResults();
                } else {
                    this.lastResult(oneResult, reply, true, false, memberID);
                }
            } else {
                this.serverSender.sendResult(oneResult, memberID);
            }
        } else {
            if (completelyDone) {
                if (this.onlyRemote) {
                    reply.addResult(memberID, oneResult);
                    reply.endResults();
                } else {
                    this.lastResult(oneResult, reply, true, false, memberID);
                }
            } else {
                reply.addResult(memberID, oneResult);
            }
            FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReceived();
        }
        FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReturned();
    }

    @Override
    public void sendResult(Object oneResult) {
        if (!this.function.hasResult()) {
            throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
        }
        if (this.serverSender != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("MemberFunctionResultSender sending result from local node to client {}", new Object[]{oneResult});
            }
            this.serverSender.sendResult(oneResult);
        } else {
            if (this.msg != null) {
                try {
                    this.msg.sendReplyForOneResult(this.dm, oneResult, false, this.enableOrderedResultStreming);
                }
                catch (QueryException e) {
                    throw new FunctionException(e);
                }
                catch (ForceReattemptException e) {
                    throw new FunctionException(e);
                }
                catch (InterruptedException e) {
                    throw new FunctionException(e);
                }
            } else {
                this.rc.addResult(this.dm.getDistributionManagerId(), oneResult);
                FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReceived();
            }
            FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReturned();
        }
    }

    @Override
    public void sendException(Throwable exception) {
        InternalFunctionException iFunxtionException = new InternalFunctionException(exception);
        this.lastResult(iFunxtionException);
        this.localLastResultRecieved = true;
    }

    @Override
    public void setException(Throwable exception) {
        ((LocalResultCollector)this.rc).setException(exception);
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.MemberResultSender_UNEXPECTED_EXCEPTION_DURING_FUNCTION_EXECUTION_ON_LOCAL_NODE), exception);
        this.rc.endResults();
        this.localLastResultRecieved = true;
    }

    @Override
    public void enableOrderedResultStreming(boolean enable) {
        this.enableOrderedResultStreming = enable;
    }

    @Override
    public boolean isLocallyExecuted() {
        return this.msg == null;
    }

    @Override
    public boolean isLastResultReceived() {
        return this.localLastResultRecieved;
    }
}

