/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.compression;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.cache.BytesAndBitsForCompactor;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.lang.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class CompressedCachedDeserializable
implements CachedDeserializable,
DataSerializableFixedID {
    static final int BASE_MEM_OVERHEAD = 12;
    protected byte[] value = null;

    public CompressedCachedDeserializable() {
    }

    protected abstract Compressor getCompressor();

    protected abstract int getMemoryOverhead();

    @Override
    public abstract int getDSFID();

    public CompressedCachedDeserializable(byte[] serializedValue) {
        if (serializedValue == null) {
            throw new NullPointerException(LocalizedStrings.PreferBytesCachedDeserializable_VALUE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.value = this.getCompressor().compress(serializedValue);
    }

    public CompressedCachedDeserializable(Object obj) {
        if (obj == null) {
            throw new NullPointerException(LocalizedStrings.PreferBytesCachedDeserializable_VALUE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.value = this.getCompressor().compress(EntryEventImpl.serialize(obj));
    }

    @Override
    public int getSizeInBytes() {
        return this.getMemoryOverhead() + CachedDeserializableFactory.getByteSize(this.value);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeByteArray(this.getCompressor().decompress(this.value), out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.value = this.getCompressor().compress(DataSerializer.readByteArray(in));
    }

    @Override
    public byte[] getSerializedValue() {
        return this.getCompressor().decompress(this.value);
    }

    @Override
    public Object getDeserializedForReading() {
        return this.getDeserializedValue(null, null);
    }

    @Override
    public String getStringForm() {
        try {
            return StringUtils.forceToString(this.getDeserializedForReading());
        }
        catch (RuntimeException ex) {
            return "Could not convert object to string because " + ex;
        }
    }

    @Override
    public Object getDeserializedWritableCopy(Region r, RegionEntry re) {
        return this.getDeserializedValue(r, re);
    }

    @Override
    public Object getDeserializedValue(Region r, RegionEntry re) {
        return EntryEventImpl.deserialize(this.getCompressor().decompress(this.value));
    }

    @Override
    public Object getValue() {
        return this.getCompressor().decompress(this.value);
    }

    @Override
    public void writeValueAsByteArray(DataOutput out) throws IOException {
        this.toData(out);
    }

    @Override
    public void fillSerializedValue(BytesAndBitsForCompactor wrapper, byte userBits) {
        byte[] uncompressed = this.getCompressor().decompress(this.value);
        wrapper.setData(uncompressed, userBits, uncompressed.length, false);
    }

    @Override
    public int getValueSizeInBytes() {
        return CachedDeserializableFactory.getByteSize(this.value);
    }
}

