/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryHeap;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryOffHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryOffHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryOffHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryOffHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryOffHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedThinRegionEntryOffHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedThinRegionEntryOffHeap
extends VersionedThinRegionEntry
implements OffHeapRegionEntry {
    private static final VersionedThinRegionEntryOffHeapFactory factory = new VersionedThinRegionEntryOffHeapFactory();

    public VersionedThinRegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinRegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VersionedThinRegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinRegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinRegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinRegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedThinRegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinRegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedThinRegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedThinRegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VersionedThinRegionEntryHeap.getEntryFactory();
        }
    }
}

