/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryHeap;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryOffHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryOffHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryOffHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryOffHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryOffHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryOffHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedThinDiskLRURegionEntryOffHeap
extends VersionedThinDiskLRURegionEntry
implements OffHeapRegionEntry {
    private static final VersionedThinDiskLRURegionEntryOffHeapFactory factory = new VersionedThinDiskLRURegionEntryOffHeapFactory();

    public VersionedThinDiskLRURegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinDiskLRURegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VersionedThinDiskLRURegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinDiskLRURegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinDiskLRURegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinDiskLRURegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedThinDiskLRURegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinDiskLRURegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedThinDiskLRURegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedThinDiskLRURegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VersionedThinDiskLRURegionEntryHeap.getEntryFactory();
        }
    }
}

