/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.AbstractDiskRegionEntry;
import com.gemstone.gemfire.internal.cache.DiskEntry;
import com.gemstone.gemfire.internal.cache.DiskId;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PlaceHolderDiskRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryHeap;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.cache.lru.LRUClockNode;
import com.gemstone.gemfire.internal.cache.persistence.DiskRecoveryStore;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionStamp;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.util.concurrent.CustomEntryConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class VersionedThinDiskLRURegionEntryHeapStringKey2
extends VersionedThinDiskLRURegionEntryHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VersionedThinDiskLRURegionEntryHeapStringKey2> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VersionedThinDiskLRURegionEntryHeapStringKey2.class, "lastModified");
    private volatile Object value;
    protected DiskId id;
    private LRUClockNode nextLRU;
    private LRUClockNode prevLRU;
    private int size;
    private VersionSource memberID;
    private short entryVersionLowBytes;
    private short regionVersionHighBytes;
    private int regionVersionLowBytes;
    private byte entryVersionHighByte;
    private byte distributedSystemId;
    private final long bits1;
    private final long bits2;

    public VersionedThinDiskLRURegionEntryHeapStringKey2(RegionEntryContext context, String key, Object value, boolean byteEncode) {
        super(context, value instanceof DiskEntry.RecoveredEntry ? null : value);
        this.initialize(context, value);
        long tmpBits1 = 0L;
        long tmpBits2 = 0L;
        if (byteEncode) {
            for (int i = key.length() - 1; i >= 0; --i) {
                if (i < 7) {
                    tmpBits1 |= (long)((byte)key.charAt(i) & 0xFF);
                    tmpBits1 <<= 8;
                    continue;
                }
                tmpBits2 <<= 8;
                tmpBits2 |= (long)((byte)key.charAt(i) & 0xFF);
            }
            tmpBits1 |= 0x40L;
        } else {
            for (int i = key.length() - 1; i >= 0; --i) {
                if (i < 3) {
                    tmpBits1 |= (long)key.charAt(i);
                    tmpBits1 <<= 16;
                    continue;
                }
                tmpBits2 <<= 16;
                tmpBits2 |= (long)key.charAt(i);
            }
        }
        this.bits1 = tmpBits1 |= (long)key.length();
        this.bits2 = tmpBits2;
    }

    @Override
    protected final Object getValueField() {
        return this.value;
    }

    @Override
    protected void setValueField(Object v) {
        this.value = v;
    }

    @Override
    protected long getlastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public final int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public final CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public final void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    protected void initialize(RegionEntryContext drs, Object value) {
        boolean isBackup;
        if (drs instanceof LocalRegion) {
            isBackup = ((LocalRegion)drs).getDiskRegion().isBackup();
        } else if (drs instanceof PlaceHolderDiskRegion) {
            isBackup = true;
        } else {
            throw new IllegalArgumentException("expected a LocalRegion or PlaceHolderDiskRegion");
        }
        if (isBackup) {
            this.diskInitialize(drs, value);
        }
    }

    @Override
    public final synchronized int updateAsyncEntrySize(EnableLRU capacityController) {
        int oldSize = this.getEntrySize();
        int newSize = capacityController.entrySize(this.getKeyForSizing(), null);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    private void diskInitialize(RegionEntryContext context, Object value) {
        DiskRecoveryStore drs = (DiskRecoveryStore)((Object)context);
        DiskStoreImpl ds = drs.getDiskStore();
        long maxOplogSize = ds.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, true, ds.needsLinkedList());
        DiskEntry.Helper.initialize(this, drs, value);
    }

    @Override
    public DiskId getDiskId() {
        return this.id;
    }

    @Override
    void setDiskId(RegionEntry old) {
        this.id = ((AbstractDiskRegionEntry)old).getDiskId();
    }

    @Override
    public void setDelayedDiskId(LocalRegion r) {
        DiskStoreImpl ds = r.getDiskStore();
        long maxOplogSize = ds.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, false, ds.needsLinkedList());
    }

    @Override
    public final synchronized int updateEntrySize(EnableLRU capacityController) {
        return this.updateEntrySize(capacityController, this._getValue());
    }

    @Override
    public final synchronized int updateEntrySize(EnableLRU capacityController, Object value) {
        int oldSize = this.getEntrySize();
        int newSize = capacityController.entrySize(this.getKeyForSizing(), value);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    @Override
    public final boolean testRecentlyUsed() {
        return this.areAnyBitsSet(0x1000000000000000L);
    }

    @Override
    public final void setRecentlyUsed() {
        this.setBits(0x1000000000000000L);
    }

    @Override
    public final void unsetRecentlyUsed() {
        this.clearBits(-1152921504606846977L);
    }

    @Override
    public final boolean testEvicted() {
        return this.areAnyBitsSet(0x2000000000000000L);
    }

    @Override
    public final void setEvicted() {
        this.setBits(0x2000000000000000L);
    }

    @Override
    public final void unsetEvicted() {
        this.clearBits(-2305843009213693953L);
    }

    @Override
    public final void setNextLRUNode(LRUClockNode next) {
        this.nextLRU = next;
    }

    @Override
    public final LRUClockNode nextLRUNode() {
        return this.nextLRU;
    }

    @Override
    public final void setPrevLRUNode(LRUClockNode prev) {
        this.prevLRU = prev;
    }

    @Override
    public final LRUClockNode prevLRUNode() {
        return this.prevLRU;
    }

    @Override
    public final int getEntrySize() {
        return this.size;
    }

    protected final void setEntrySize(int size) {
        this.size = size;
    }

    @Override
    public Object getKeyForSizing() {
        return null;
    }

    @Override
    public int getEntryVersion() {
        return this.entryVersionHighByte << 16 & 0xFF0000 | this.entryVersionLowBytes & 0xFFFF;
    }

    @Override
    public long getRegionVersion() {
        return (long)this.regionVersionHighBytes << 32 | (long)this.regionVersionLowBytes & 0xFFFFFFFFL;
    }

    @Override
    public long getVersionTimeStamp() {
        return this.getLastModified();
    }

    @Override
    public void setVersionTimeStamp(long time) {
        this.setLastModified(time);
    }

    @Override
    public VersionSource getMemberID() {
        return this.memberID;
    }

    @Override
    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    public void setVersions(VersionTag tag) {
        this.memberID = tag.getMemberID();
        int eVersion = tag.getEntryVersion();
        this.entryVersionLowBytes = (short)(eVersion & 0xFFFF);
        this.entryVersionHighByte = (byte)((eVersion & 0xFF0000) >> 16);
        this.regionVersionHighBytes = tag.getRegionVersionHighBytes();
        this.regionVersionLowBytes = tag.getRegionVersionLowBytes();
        if (!tag.isGatewayTag() && this.distributedSystemId == tag.getDistributedSystemId()) {
            if (this.getVersionTimeStamp() <= tag.getVersionTimeStamp()) {
                this.setVersionTimeStamp(tag.getVersionTimeStamp());
            } else {
                tag.setVersionTimeStamp(this.getVersionTimeStamp());
            }
        } else {
            this.setVersionTimeStamp(tag.getVersionTimeStamp());
        }
        this.distributedSystemId = (byte)(tag.getDistributedSystemId() & 0xFF);
    }

    @Override
    public void setMemberID(VersionSource memberID) {
        this.memberID = memberID;
    }

    @Override
    public VersionStamp getVersionStamp() {
        return this;
    }

    public VersionTag asVersionTag() {
        VersionTag tag = VersionTag.create(this.memberID);
        tag.setEntryVersion(this.getEntryVersion());
        tag.setRegionVersion(this.regionVersionHighBytes, this.regionVersionLowBytes);
        tag.setVersionTimeStamp(this.getVersionTimeStamp());
        tag.setDistributedSystemId(this.distributedSystemId);
        return tag;
    }

    public void processVersionTag(LocalRegion r, VersionTag tag, boolean isTombstoneFromGII, boolean hasDelta, VersionSource thisVM, InternalDistributedMember sender, boolean checkForConflicts) {
        this.basicProcessVersionTag(r, tag, isTombstoneFromGII, hasDelta, thisVM, sender, checkForConflicts);
    }

    @Override
    public void processVersionTag(EntryEvent cacheEvent) {
        super.processVersionTag(cacheEvent);
    }

    @Override
    public short getRegionVersionHighBytes() {
        return this.regionVersionHighBytes;
    }

    @Override
    public int getRegionVersionLowBytes() {
        return this.regionVersionLowBytes;
    }

    private int getKeyLength() {
        return (int)(this.bits1 & 0x3FL);
    }

    private int getEncoding() {
        return (int)(this.bits1 >> 6) & 3;
    }

    @Override
    public final Object getKey() {
        int keylen = this.getKeyLength();
        char[] chars = new char[keylen];
        long tmpBits1 = this.bits1;
        long tmpBits2 = this.bits2;
        if (this.getEncoding() == 1) {
            for (int i = 0; i < keylen; ++i) {
                if (i < 7) {
                    chars[i] = (char)((tmpBits1 >>= 8) & 0xFFL);
                    continue;
                }
                chars[i] = (char)(tmpBits2 & 0xFFL);
                tmpBits2 >>= 8;
            }
        } else {
            for (int i = 0; i < keylen; ++i) {
                if (i < 3) {
                    chars[i] = (char)((tmpBits1 >>= 16) & 0xFFFFL);
                    continue;
                }
                chars[i] = (char)(tmpBits2 & 0xFFFFL);
                tmpBits2 >>= 16;
            }
        }
        return new String(chars);
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof String) {
            String str = (String)k;
            int keylen = this.getKeyLength();
            if (str.length() == keylen) {
                long tmpBits1 = this.bits1;
                long tmpBits2 = this.bits2;
                if (this.getEncoding() == 1) {
                    for (int i = 0; i < keylen; ++i) {
                        char c;
                        if (i < 7) {
                            c = (char)((tmpBits1 >>= 8) & 0xFFL);
                        } else {
                            c = (char)(tmpBits2 & 0xFFL);
                            tmpBits2 >>= 8;
                        }
                        if (str.charAt(i) == c) continue;
                        return false;
                    }
                } else {
                    for (int i = 0; i < keylen; ++i) {
                        char c;
                        if (i < 3) {
                            c = (char)((tmpBits1 >>= 16) & 0xFFFFL);
                        } else {
                            c = (char)(tmpBits2 & 0xFFFFL);
                            tmpBits2 >>= 16;
                        }
                        if (str.charAt(i) == c) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

