/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalStatisticsDisabledException;
import com.gemstone.gemfire.internal.cache.AbstractDiskRegionEntry;
import com.gemstone.gemfire.internal.cache.DiskEntry;
import com.gemstone.gemfire.internal.cache.DiskId;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskRegionEntryOffHeap;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.cache.persistence.DiskRecoveryStore;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionStamp;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.offheap.OffHeapRegionEntryHelper;
import com.gemstone.gemfire.internal.util.concurrent.CustomEntryConcurrentHashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class VersionedStatsDiskRegionEntryOffHeapUUIDKey
extends VersionedStatsDiskRegionEntryOffHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VersionedStatsDiskRegionEntryOffHeapUUIDKey> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VersionedStatsDiskRegionEntryOffHeapUUIDKey.class, "lastModified");
    private volatile long ohAddress;
    private static final AtomicLongFieldUpdater<VersionedStatsDiskRegionEntryOffHeapUUIDKey> ohAddrUpdater = AtomicLongFieldUpdater.newUpdater(VersionedStatsDiskRegionEntryOffHeapUUIDKey.class, "ohAddress");
    protected DiskId id;
    private volatile long lastAccessed;
    private volatile int hitCount;
    private volatile int missCount;
    private static final AtomicIntegerFieldUpdater<VersionedStatsDiskRegionEntryOffHeapUUIDKey> hitCountUpdater = AtomicIntegerFieldUpdater.newUpdater(VersionedStatsDiskRegionEntryOffHeapUUIDKey.class, "hitCount");
    private static final AtomicIntegerFieldUpdater<VersionedStatsDiskRegionEntryOffHeapUUIDKey> missCountUpdater = AtomicIntegerFieldUpdater.newUpdater(VersionedStatsDiskRegionEntryOffHeapUUIDKey.class, "missCount");
    private VersionSource memberID;
    private short entryVersionLowBytes;
    private short regionVersionHighBytes;
    private int regionVersionLowBytes;
    private byte entryVersionHighByte;
    private byte distributedSystemId;
    private final long keyMostSigBits;
    private final long keyLeastSigBits;

    public VersionedStatsDiskRegionEntryOffHeapUUIDKey(RegionEntryContext context, UUID key, Object value) {
        super(context, value instanceof DiskEntry.RecoveredEntry ? null : value);
        this.initialize(context, value);
        this.keyMostSigBits = key.getMostSignificantBits();
        this.keyLeastSigBits = key.getLeastSignificantBits();
    }

    @Override
    public Token getValueAsToken() {
        return OffHeapRegionEntryHelper.getValueAsToken(this);
    }

    @Override
    protected Object getValueField() {
        return OffHeapRegionEntryHelper._getValue(this);
    }

    @Override
    protected void setValueField(Object v) {
        OffHeapRegionEntryHelper.setValue(this, v);
    }

    @Override
    public Object _getValueRetain(RegionEntryContext context, boolean decompress) {
        return OffHeapRegionEntryHelper._getValueRetain(this, decompress, context);
    }

    @Override
    public long getAddress() {
        return ohAddrUpdater.get(this);
    }

    @Override
    public boolean setAddress(long expectedAddr, long newAddr) {
        return ohAddrUpdater.compareAndSet(this, expectedAddr, newAddr);
    }

    @Override
    public void release() {
        OffHeapRegionEntryHelper.releaseEntry(this);
    }

    @Override
    public void returnToPool() {
    }

    @Override
    protected long getlastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public final int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public final CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public final void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    protected void initialize(RegionEntryContext context, Object value) {
        this.diskInitialize(context, value);
    }

    @Override
    public int updateAsyncEntrySize(EnableLRU capacityController) {
        throw new IllegalStateException("should never be called");
    }

    private void diskInitialize(RegionEntryContext context, Object value) {
        DiskRecoveryStore drs = (DiskRecoveryStore)((Object)context);
        DiskStoreImpl ds = drs.getDiskStore();
        long maxOplogSize = ds.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, true, ds.needsLinkedList());
        DiskEntry.Helper.initialize(this, drs, value);
    }

    @Override
    public DiskId getDiskId() {
        return this.id;
    }

    @Override
    void setDiskId(RegionEntry old) {
        this.id = ((AbstractDiskRegionEntry)old).getDiskId();
    }

    @Override
    public final void updateStatsForGet(boolean hit, long time) {
        this.setLastAccessed(time);
        if (hit) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
    }

    @Override
    protected final void setLastModified(long lastModified) {
        this._setLastModified(lastModified);
        if (!DISABLE_ACCESS_TIME_UPDATE_ON_PUT) {
            this.setLastAccessed(lastModified);
        }
    }

    @Override
    public final long getLastAccessed() throws InternalStatisticsDisabledException {
        return this.lastAccessed;
    }

    private void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    @Override
    public final long getHitCount() throws InternalStatisticsDisabledException {
        return (long)this.hitCount & 0xFFFFFFFFL;
    }

    @Override
    public final long getMissCount() throws InternalStatisticsDisabledException {
        return (long)this.missCount & 0xFFFFFFFFL;
    }

    private void incrementHitCount() {
        hitCountUpdater.incrementAndGet(this);
    }

    private void incrementMissCount() {
        missCountUpdater.incrementAndGet(this);
    }

    @Override
    public final void resetCounts() throws InternalStatisticsDisabledException {
        hitCountUpdater.set(this, 0);
        missCountUpdater.set(this, 0);
    }

    @Override
    public final void txDidDestroy(long currTime) {
        this.setLastModified(currTime);
        this.setLastAccessed(currTime);
        this.hitCount = 0;
        this.missCount = 0;
    }

    @Override
    public boolean hasStats() {
        return true;
    }

    @Override
    public int getEntryVersion() {
        return this.entryVersionHighByte << 16 & 0xFF0000 | this.entryVersionLowBytes & 0xFFFF;
    }

    @Override
    public long getRegionVersion() {
        return (long)this.regionVersionHighBytes << 32 | (long)this.regionVersionLowBytes & 0xFFFFFFFFL;
    }

    @Override
    public long getVersionTimeStamp() {
        return this.getLastModified();
    }

    @Override
    public void setVersionTimeStamp(long time) {
        this.setLastModified(time);
    }

    @Override
    public VersionSource getMemberID() {
        return this.memberID;
    }

    @Override
    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    public void setVersions(VersionTag tag) {
        this.memberID = tag.getMemberID();
        int eVersion = tag.getEntryVersion();
        this.entryVersionLowBytes = (short)(eVersion & 0xFFFF);
        this.entryVersionHighByte = (byte)((eVersion & 0xFF0000) >> 16);
        this.regionVersionHighBytes = tag.getRegionVersionHighBytes();
        this.regionVersionLowBytes = tag.getRegionVersionLowBytes();
        if (!tag.isGatewayTag() && this.distributedSystemId == tag.getDistributedSystemId()) {
            if (this.getVersionTimeStamp() <= tag.getVersionTimeStamp()) {
                this.setVersionTimeStamp(tag.getVersionTimeStamp());
            } else {
                tag.setVersionTimeStamp(this.getVersionTimeStamp());
            }
        } else {
            this.setVersionTimeStamp(tag.getVersionTimeStamp());
        }
        this.distributedSystemId = (byte)(tag.getDistributedSystemId() & 0xFF);
    }

    @Override
    public void setMemberID(VersionSource memberID) {
        this.memberID = memberID;
    }

    @Override
    public VersionStamp getVersionStamp() {
        return this;
    }

    public VersionTag asVersionTag() {
        VersionTag tag = VersionTag.create(this.memberID);
        tag.setEntryVersion(this.getEntryVersion());
        tag.setRegionVersion(this.regionVersionHighBytes, this.regionVersionLowBytes);
        tag.setVersionTimeStamp(this.getVersionTimeStamp());
        tag.setDistributedSystemId(this.distributedSystemId);
        return tag;
    }

    public void processVersionTag(LocalRegion r, VersionTag tag, boolean isTombstoneFromGII, boolean hasDelta, VersionSource thisVM, InternalDistributedMember sender, boolean checkForConflicts) {
        this.basicProcessVersionTag(r, tag, isTombstoneFromGII, hasDelta, thisVM, sender, checkForConflicts);
    }

    @Override
    public void processVersionTag(EntryEvent cacheEvent) {
        super.processVersionTag(cacheEvent);
    }

    @Override
    public short getRegionVersionHighBytes() {
        return this.regionVersionHighBytes;
    }

    @Override
    public int getRegionVersionLowBytes() {
        return this.regionVersionLowBytes;
    }

    @Override
    public final Object getKey() {
        return new UUID(this.keyMostSigBits, this.keyLeastSigBits);
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof UUID) {
            UUID uuid = (UUID)k;
            return uuid.getLeastSignificantBits() == this.keyLeastSigBits && uuid.getMostSignificantBits() == this.keyMostSigBits;
        }
        return false;
    }
}

