/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryHeap;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryOffHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryOffHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryOffHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryOffHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryOffHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryOffHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedStatsDiskLRURegionEntryOffHeap
extends VersionedStatsDiskLRURegionEntry
implements OffHeapRegionEntry {
    private static final VersionedStatsDiskLRURegionEntryOffHeapFactory factory = new VersionedStatsDiskLRURegionEntryOffHeapFactory();

    public VersionedStatsDiskLRURegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsDiskLRURegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsDiskLRURegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsDiskLRURegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsDiskLRURegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsDiskLRURegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedStatsDiskLRURegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsDiskLRURegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedStatsDiskLRURegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedStatsDiskLRURegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VersionedStatsDiskLRURegionEntryHeap.getEntryFactory();
        }
    }
}

