/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryHeapIntKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryHeapLongKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryHeapUUIDKey;
import java.util.UUID;

public abstract class VersionedStatsDiskLRURegionEntryHeap
extends VersionedStatsDiskLRURegionEntry {
    private static final VersionedStatsDiskLRURegionEntryHeapFactory factory = new VersionedStatsDiskLRURegionEntryHeapFactory();

    public VersionedStatsDiskLRURegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsDiskLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsDiskLRURegionEntryHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsDiskLRURegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsDiskLRURegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsDiskLRURegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedStatsDiskLRURegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsDiskLRURegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedStatsDiskLRURegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedStatsDiskLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

