/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryHeap;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryOffHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryOffHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryOffHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryOffHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryOffHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMThinLRURegionEntryOffHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedThinLRURegionEntryOffHeap;
import java.util.UUID;

public abstract class VMThinLRURegionEntryOffHeap
extends VMThinLRURegionEntry
implements OffHeapRegionEntry {
    private static final VMThinLRURegionEntryOffHeapFactory factory = new VMThinLRURegionEntryOffHeapFactory();

    public VMThinLRURegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinLRURegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VMThinLRURegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinLRURegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMThinLRURegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinLRURegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMThinLRURegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinLRURegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMThinLRURegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMThinLRURegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinLRURegionEntryOffHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VMThinLRURegionEntryHeap.getEntryFactory();
        }
    }
}

