/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryHeap;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryOffHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryOffHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryOffHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryOffHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryOffHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMThinDiskLRURegionEntryOffHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedThinDiskLRURegionEntryOffHeap;
import java.util.UUID;

public abstract class VMThinDiskLRURegionEntryOffHeap
extends VMThinDiskLRURegionEntry
implements OffHeapRegionEntry {
    private static final VMThinDiskLRURegionEntryOffHeapFactory factory = new VMThinDiskLRURegionEntryOffHeapFactory();

    public VMThinDiskLRURegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMThinDiskLRURegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VMThinDiskLRURegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMThinDiskLRURegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMThinDiskLRURegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMThinDiskLRURegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMThinDiskLRURegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMThinDiskLRURegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMThinDiskLRURegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMThinDiskLRURegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedThinDiskLRURegionEntryOffHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VMThinDiskLRURegionEntryHeap.getEntryFactory();
        }
    }
}

