/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.InternalStatisticsDisabledException;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.VMStatsRegionEntryHeap;
import com.gemstone.gemfire.internal.util.concurrent.CustomEntryConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class VMStatsRegionEntryHeapStringKey2
extends VMStatsRegionEntryHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VMStatsRegionEntryHeapStringKey2> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VMStatsRegionEntryHeapStringKey2.class, "lastModified");
    private volatile Object value;
    private volatile long lastAccessed;
    private volatile int hitCount;
    private volatile int missCount;
    private static final AtomicIntegerFieldUpdater<VMStatsRegionEntryHeapStringKey2> hitCountUpdater = AtomicIntegerFieldUpdater.newUpdater(VMStatsRegionEntryHeapStringKey2.class, "hitCount");
    private static final AtomicIntegerFieldUpdater<VMStatsRegionEntryHeapStringKey2> missCountUpdater = AtomicIntegerFieldUpdater.newUpdater(VMStatsRegionEntryHeapStringKey2.class, "missCount");
    private final long bits1;
    private final long bits2;

    public VMStatsRegionEntryHeapStringKey2(RegionEntryContext context, String key, Object value, boolean byteEncode) {
        super(context, value);
        long tmpBits1 = 0L;
        long tmpBits2 = 0L;
        if (byteEncode) {
            for (int i = key.length() - 1; i >= 0; --i) {
                if (i < 7) {
                    tmpBits1 |= (long)((byte)key.charAt(i) & 0xFF);
                    tmpBits1 <<= 8;
                    continue;
                }
                tmpBits2 <<= 8;
                tmpBits2 |= (long)((byte)key.charAt(i) & 0xFF);
            }
            tmpBits1 |= 0x40L;
        } else {
            for (int i = key.length() - 1; i >= 0; --i) {
                if (i < 3) {
                    tmpBits1 |= (long)key.charAt(i);
                    tmpBits1 <<= 16;
                    continue;
                }
                tmpBits2 <<= 16;
                tmpBits2 |= (long)key.charAt(i);
            }
        }
        this.bits1 = tmpBits1 |= (long)key.length();
        this.bits2 = tmpBits2;
    }

    @Override
    protected final Object getValueField() {
        return this.value;
    }

    @Override
    protected void setValueField(Object v) {
        this.value = v;
    }

    @Override
    protected long getlastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public final int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public final CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public final void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    @Override
    public final void updateStatsForGet(boolean hit, long time) {
        this.setLastAccessed(time);
        if (hit) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
    }

    @Override
    protected final void setLastModified(long lastModified) {
        this._setLastModified(lastModified);
        if (!DISABLE_ACCESS_TIME_UPDATE_ON_PUT) {
            this.setLastAccessed(lastModified);
        }
    }

    @Override
    public final long getLastAccessed() throws InternalStatisticsDisabledException {
        return this.lastAccessed;
    }

    private void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    @Override
    public final long getHitCount() throws InternalStatisticsDisabledException {
        return (long)this.hitCount & 0xFFFFFFFFL;
    }

    @Override
    public final long getMissCount() throws InternalStatisticsDisabledException {
        return (long)this.missCount & 0xFFFFFFFFL;
    }

    private void incrementHitCount() {
        hitCountUpdater.incrementAndGet(this);
    }

    private void incrementMissCount() {
        missCountUpdater.incrementAndGet(this);
    }

    @Override
    public final void resetCounts() throws InternalStatisticsDisabledException {
        hitCountUpdater.set(this, 0);
        missCountUpdater.set(this, 0);
    }

    @Override
    public final void txDidDestroy(long currTime) {
        this.setLastModified(currTime);
        this.setLastAccessed(currTime);
        this.hitCount = 0;
        this.missCount = 0;
    }

    @Override
    public boolean hasStats() {
        return true;
    }

    private int getKeyLength() {
        return (int)(this.bits1 & 0x3FL);
    }

    private int getEncoding() {
        return (int)(this.bits1 >> 6) & 3;
    }

    @Override
    public final Object getKey() {
        int keylen = this.getKeyLength();
        char[] chars = new char[keylen];
        long tmpBits1 = this.bits1;
        long tmpBits2 = this.bits2;
        if (this.getEncoding() == 1) {
            for (int i = 0; i < keylen; ++i) {
                if (i < 7) {
                    chars[i] = (char)((tmpBits1 >>= 8) & 0xFFL);
                    continue;
                }
                chars[i] = (char)(tmpBits2 & 0xFFL);
                tmpBits2 >>= 8;
            }
        } else {
            for (int i = 0; i < keylen; ++i) {
                if (i < 3) {
                    chars[i] = (char)((tmpBits1 >>= 16) & 0xFFFFL);
                    continue;
                }
                chars[i] = (char)(tmpBits2 & 0xFFFFL);
                tmpBits2 >>= 16;
            }
        }
        return new String(chars);
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof String) {
            String str = (String)k;
            int keylen = this.getKeyLength();
            if (str.length() == keylen) {
                long tmpBits1 = this.bits1;
                long tmpBits2 = this.bits2;
                if (this.getEncoding() == 1) {
                    for (int i = 0; i < keylen; ++i) {
                        char c;
                        if (i < 7) {
                            c = (char)((tmpBits1 >>= 8) & 0xFFL);
                        } else {
                            c = (char)(tmpBits2 & 0xFFL);
                            tmpBits2 >>= 8;
                        }
                        if (str.charAt(i) == c) continue;
                        return false;
                    }
                } else {
                    for (int i = 0; i < keylen; ++i) {
                        char c;
                        if (i < 3) {
                            c = (char)((tmpBits1 >>= 16) & 0xFFFFL);
                        } else {
                            c = (char)(tmpBits2 & 0xFFFFL);
                            tmpBits2 >>= 16;
                        }
                        if (str.charAt(i) == c) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

