/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.InlineKeyHelper;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntry;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryHeap;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryOffHeapIntKey;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryOffHeapLongKey;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryOffHeapObjectKey;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryOffHeapStringKey1;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryOffHeapStringKey2;
import com.gemstone.gemfire.internal.cache.VMStatsDiskLRURegionEntryOffHeapUUIDKey;
import com.gemstone.gemfire.internal.cache.VersionedStatsDiskLRURegionEntryOffHeap;
import java.util.UUID;

public abstract class VMStatsDiskLRURegionEntryOffHeap
extends VMStatsDiskLRURegionEntry
implements OffHeapRegionEntry {
    private static final VMStatsDiskLRURegionEntryOffHeapFactory factory = new VMStatsDiskLRURegionEntryOffHeapFactory();

    public VMStatsDiskLRURegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsDiskLRURegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VMStatsDiskLRURegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsDiskLRURegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMStatsDiskLRURegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsDiskLRURegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMStatsDiskLRURegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsDiskLRURegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMStatsDiskLRURegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VMStatsDiskLRURegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsDiskLRURegionEntryOffHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VMStatsDiskLRURegionEntryHeap.getEntryFactory();
        }
    }
}

