/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.control.MemoryEvent;
import com.gemstone.gemfire.internal.cache.control.ResourceListener;
import com.gemstone.gemfire.internal.cache.versions.CompactVersionHolder;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.size.ReflectionSingleObjectSizer;
import com.gemstone.gemfire.internal.util.concurrent.StoppableReentrantLock;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class TombstoneService
implements ResourceListener<MemoryEvent> {
    private static final Logger logger = LogService.getLogger();
    public static long REPLICATED_TOMBSTONE_TIMEOUT = Long.getLong("gemfire.tombstone-timeout", 600000L);
    public static long CLIENT_TOMBSTONE_TIMEOUT = Long.getLong("gemfire.non-replicated-tombstone-timeout", 480000L);
    public static long EXPIRED_TOMBSTONE_LIMIT = Long.getLong("gemfire.tombstone-gc-threshold", 100000L);
    public static long DEFUNCT_TOMBSTONE_SCAN_INTERVAL = Long.getLong("gemfire.tombstone-scan-interval", 60000L);
    public static double GC_MEMORY_THRESHOLD = (double)Integer.getInteger("gemfire.tombstone-gc-memory-threshold", 30).intValue() * 0.01;
    public static boolean FORCE_GC_MEMORY_EVENTS = false;
    public static final Object debugSync = new Object();
    public static final boolean DEBUG_TOMBSTONE_COUNT = Boolean.getBoolean("gemfire.TombstoneService.DEBUG_TOMBSTONE_COUNT");
    public static boolean IDLE_EXPIRATION = false;
    private TombstoneSweeper replicatedTombstoneSweeper;
    private TombstoneSweeper nonReplicatedTombstoneSweeper;
    private GemFireCacheImpl cache;
    private Queue<Tombstone> replicatedTombstones = new ConcurrentLinkedQueue<Tombstone>();
    private Queue<Tombstone> nonReplicatedTombstones = new ConcurrentLinkedQueue<Tombstone>();
    private AtomicLong replicatedTombstoneQueueSize = new AtomicLong();
    private AtomicLong nonReplicatedTombstoneQueueSize = new AtomicLong();
    public Object blockGCLock = new Object();
    private int progressingDeltaGIICount;

    public static TombstoneService initialize(GemFireCacheImpl cache) {
        TombstoneService instance = new TombstoneService(cache);
        return instance;
    }

    private TombstoneService(GemFireCacheImpl cache) {
        this.cache = cache;
        this.replicatedTombstoneSweeper = new TombstoneSweeper(cache, this.replicatedTombstones, REPLICATED_TOMBSTONE_TIMEOUT, true, this.replicatedTombstoneQueueSize);
        this.nonReplicatedTombstoneSweeper = new TombstoneSweeper(cache, this.nonReplicatedTombstones, CLIENT_TOMBSTONE_TIMEOUT, false, this.nonReplicatedTombstoneQueueSize);
        this.startSweeper(this.replicatedTombstoneSweeper);
        this.startSweeper(this.nonReplicatedTombstoneSweeper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSweeper(TombstoneSweeper tombstoneSweeper) {
        TombstoneSweeper tombstoneSweeper2 = tombstoneSweeper;
        synchronized (tombstoneSweeper2) {
            if (tombstoneSweeper.sweeperThread == null) {
                tombstoneSweeper.sweeperThread = new Thread((ThreadGroup)LoggingThreadGroup.createThreadGroup("Destroyed Entries Processors", logger), tombstoneSweeper);
                tombstoneSweeper.sweeperThread.setDaemon(true);
                String product = "GemFire";
                if (tombstoneSweeper == this.replicatedTombstoneSweeper) {
                    tombstoneSweeper.sweeperThread.setName(product + " Garbage Collection Thread 1");
                } else {
                    tombstoneSweeper.sweeperThread.setName(product + " Garbage Collection Thread 2");
                }
                tombstoneSweeper.sweeperThread.start();
            }
        }
    }

    public void stop() {
        this.stopSweeper(this.replicatedTombstoneSweeper);
        this.stopSweeper(this.nonReplicatedTombstoneSweeper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSweeper(TombstoneSweeper t) {
        Thread sweeperThread;
        TombstoneSweeper tombstoneSweeper = t;
        synchronized (tombstoneSweeper) {
            sweeperThread = t.sweeperThread;
            t.isStopped = true;
            if (sweeperThread != null) {
                t.notifyAll();
            }
        }
        try {
            sweeperThread.join(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        t.tombstones.clear();
    }

    public void scheduleTombstone(LocalRegion r, RegionEntry entry, VersionTag destroyedVersion) {
        if (entry.getVersionStamp() == null) {
            logger.warn("Detected an attempt to schedule a tombstone for an entry that is not versioned in region " + r.getFullPath(), (Throwable)new Exception("stack trace"));
            return;
        }
        boolean useReplicated = this.useReplicatedQueue(r);
        Tombstone ts = new Tombstone(entry, r, destroyedVersion);
        if (useReplicated) {
            this.replicatedTombstones.add(ts);
            this.replicatedTombstoneQueueSize.addAndGet(ts.getSize());
        } else {
            this.nonReplicatedTombstones.add(ts);
            this.nonReplicatedTombstoneQueueSize.addAndGet(ts.getSize());
        }
    }

    private boolean useReplicatedQueue(LocalRegion r) {
        return r.getScope().isDistributed() && r.getServerProxy() == null && r.dataPolicy.withReplication();
    }

    public void unscheduleTombstones(LocalRegion r) {
        Queue<Tombstone> queue = r.getAttributes().getDataPolicy().withReplication() ? this.replicatedTombstones : this.nonReplicatedTombstones;
        long removalSize = 0L;
        Iterator it = queue.iterator();
        while (it.hasNext()) {
            Tombstone t = (Tombstone)it.next();
            if (t.region != r) continue;
            it.remove();
            removalSize += (long)t.getSize();
        }
        if (queue == this.replicatedTombstones) {
            this.replicatedTombstoneQueueSize.addAndGet(-removalSize);
        } else {
            this.nonReplicatedTombstoneQueueSize.addAndGet(-removalSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGCBlockCount() {
        Object object = this.blockGCLock;
        synchronized (object) {
            return this.progressingDeltaGIICount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrementGCBlockCount() {
        Object object = this.blockGCLock;
        synchronized (object) {
            return ++this.progressingDeltaGIICount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decrementGCBlockCount() {
        Object object = this.blockGCLock;
        synchronized (object) {
            return --this.progressingDeltaGIICount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Object> gcTombstones(LocalRegion r, Map<VersionSource, Long> regionGCVersions) {
        Object object = this.blockGCLock;
        synchronized (object) {
            int count = this.getGCBlockCount();
            if (count > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("gcTombstones skipped due to {} Delta GII on going", new Object[]{count});
                }
                return null;
            }
            boolean replicated = false;
            long removalSize = 0L;
            StoppableReentrantLock lock = null;
            boolean locked = false;
            if (logger.isDebugEnabled()) {
                logger.debug("gcTombstones invoked for region {} and version map {}", new Object[]{r, regionGCVersions});
            }
            HashSet<Tombstone> removals = new HashSet<Tombstone>();
            VersionSource myId = r.getVersionMember();
            boolean isBucket = r.isUsedForPartitionedRegionBucket();
            try {
                Tombstone currentTombstone;
                Queue<Tombstone> queue;
                locked = false;
                if (r.getServerProxy() != null) {
                    queue = this.nonReplicatedTombstones;
                    lock = this.nonReplicatedTombstoneSweeper.currentTombstoneLock;
                    lock.lock();
                    locked = true;
                    currentTombstone = this.nonReplicatedTombstoneSweeper.currentTombstone;
                } else {
                    queue = this.replicatedTombstones;
                    replicated = true;
                    lock = this.replicatedTombstoneSweeper.currentTombstoneLock;
                    lock.lock();
                    locked = true;
                    currentTombstone = this.replicatedTombstoneSweeper.currentTombstone;
                }
                if (currentTombstone != null && currentTombstone.region == r) {
                    Long maxReclaimedRV;
                    Iterator<Map.Entry<VersionSource<Object>, Long>> destroyingMember = currentTombstone.getMemberID();
                    if (destroyingMember == null) {
                        destroyingMember = myId;
                    }
                    if ((maxReclaimedRV = regionGCVersions.get(destroyingMember)) != null && currentTombstone.getRegionVersion() <= maxReclaimedRV) {
                        removals.add(currentTombstone);
                    }
                }
                for (Tombstone t : queue) {
                    Long maxReclaimedRV;
                    if (t.region != r) continue;
                    Object destroyingMember = t.getMemberID();
                    if (destroyingMember == null) {
                        destroyingMember = myId;
                    }
                    if ((maxReclaimedRV = regionGCVersions.get(destroyingMember)) == null || t.getRegionVersion() > maxReclaimedRV) continue;
                    removals.add(t);
                    removalSize += (long)t.getSize();
                }
                queue.removeAll(removals);
                if (replicated) {
                    this.replicatedTombstoneQueueSize.addAndGet(-removalSize);
                } else {
                    this.nonReplicatedTombstoneQueueSize.addAndGet(-removalSize);
                }
            }
            finally {
                if (locked) {
                    lock.unlock();
                }
            }
            for (Map.Entry<VersionSource, Long> entry : regionGCVersions.entrySet()) {
                r.getVersionVector().recordGCVersion(entry.getKey(), entry.getValue());
            }
            r.getVersionVector().pruneOldExceptions();
            if (r.getDataPolicy().withPersistence()) {
                r.getDiskRegion().writeRVVGC(r);
            }
            HashSet<Object> removedKeys = new HashSet<Object>();
            for (Tombstone t : removals) {
                if (!t.region.getRegionMap().removeTombstone(t.entry, t, false, true) || !isBucket) continue;
                removedKeys.add(t.entry.getKey());
            }
            return removedKeys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gcTombstoneKeys(LocalRegion r, Set<Object> tombstoneKeys) {
        Queue<Tombstone> queue = this.nonReplicatedTombstones;
        HashSet<Tombstone> removals = new HashSet<Tombstone>();
        this.nonReplicatedTombstoneSweeper.currentTombstoneLock.lock();
        try {
            Tombstone currentTombstone = this.nonReplicatedTombstoneSweeper.currentTombstone;
            long removalSize = 0L;
            VersionSource myId = r.getVersionMember();
            if (logger.isDebugEnabled()) {
                logger.debug("gcTombstones invoked for region {} and keys {}", new Object[]{r, tombstoneKeys});
            }
            if (currentTombstone != null && currentTombstone.region == r) {
                Object destroyingMember = currentTombstone.getMemberID();
                if (destroyingMember == null) {
                    destroyingMember = myId;
                }
                if (tombstoneKeys.contains(currentTombstone.entry.getKey())) {
                    removals.add(currentTombstone);
                }
            }
            for (Tombstone t : queue) {
                if (t.region != r) continue;
                Object destroyingMember = t.getMemberID();
                if (destroyingMember == null) {
                    destroyingMember = myId;
                }
                if (!tombstoneKeys.contains(t.entry.getKey())) continue;
                removals.add(t);
                removalSize += (long)t.getSize();
            }
            queue.removeAll(removals);
            this.nonReplicatedTombstoneQueueSize.addAndGet(removalSize);
        }
        finally {
            this.nonReplicatedTombstoneSweeper.currentTombstoneLock.unlock();
        }
        for (Tombstone t : removals) {
            t.region.getRegionMap().removeTombstone(t.entry, t, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forceBatchExpirationForTests(int count) throws InterruptedException {
        this.replicatedTombstoneSweeper.testHook_batchExpired = new CountDownLatch(1);
        try {
            TombstoneSweeper tombstoneSweeper = this.replicatedTombstoneSweeper;
            synchronized (tombstoneSweeper) {
                TombstoneSweeper tombstoneSweeper2 = this.replicatedTombstoneSweeper;
                tombstoneSweeper2.forceExpirationCount = tombstoneSweeper2.forceExpirationCount + (long)count;
                this.replicatedTombstoneSweeper.notifyAll();
            }
            boolean bl = this.replicatedTombstoneSweeper.testHook_batchExpired.await(30L, TimeUnit.SECONDS);
            return bl;
        }
        finally {
            this.replicatedTombstoneSweeper.testHook_batchExpired = null;
        }
    }

    public boolean isTombstoneScheduled(LocalRegion r, RegionEntry re) {
        Queue<Tombstone> queue = r.getDataPolicy().withReplication() ? this.replicatedTombstones : this.nonReplicatedTombstones;
        VersionSource myId = r.getVersionMember();
        VersionTag entryTag = re.getVersionStamp().asVersionTag();
        int entryVersion = entryTag.getEntryVersion();
        for (Tombstone t : queue) {
            if (t.region != r) continue;
            Object destroyingMember = t.getMemberID();
            if (destroyingMember == null) {
                destroyingMember = myId;
            }
            if (t.region != r || !t.entry.getKey().equals(re.getKey()) || t.getEntryVersion() != entryVersion) continue;
            return true;
        }
        if (this.replicatedTombstoneSweeper != null) {
            return this.replicatedTombstoneSweeper.hasExpiredTombstone(r, re, entryTag);
        }
        return false;
    }

    public String toString() {
        return "Destroyed entries GC service.  Replicate Queue=" + this.replicatedTombstones.toString() + " Non-replicate Queue=" + this.nonReplicatedTombstones + (this.replicatedTombstoneSweeper.expiredTombstones != null ? " expired batch size = " + this.replicatedTombstoneSweeper.expiredTombstones.size() : "");
    }

    @Override
    public void onEvent(MemoryEvent event) {
        if (event.isLocal() && event.getState().isEviction() && !event.getPreviousState().isEviction()) {
            this.replicatedTombstoneSweeper.forceBatchExpiration();
        }
    }

    private static class TombstoneSweeper
    implements Runnable {
        private final long expiryTime;
        Queue<Tombstone> tombstones;
        AtomicLong queueSize = new AtomicLong();
        Thread sweeperThread;
        boolean batchMode;
        volatile boolean batchExpirationSuspended;
        Tombstone currentTombstone;
        final StoppableReentrantLock currentTombstoneLock;
        Set<Tombstone> expiredTombstones;
        private long forceExpirationCount = 0L;
        private boolean forceBatchExpiration = false;
        private volatile boolean batchExpirationInProgress;
        private CountDownLatch testHook_batchExpired;
        private GemFireCacheImpl cache;
        private volatile boolean isStopped;

        TombstoneSweeper(GemFireCacheImpl cache, Queue<Tombstone> tombstones, long expiryTime, boolean batchMode, AtomicLong queueSize) {
            this.cache = cache;
            this.expiryTime = expiryTime;
            this.tombstones = tombstones;
            this.queueSize = queueSize;
            if (batchMode) {
                this.batchMode = true;
                this.expiredTombstones = new HashSet<Tombstone>();
            }
            this.currentTombstoneLock = new StoppableReentrantLock(cache.getCancelCriterion());
        }

        void suspendBatchExpiration() {
            this.batchExpirationSuspended = true;
        }

        void resumeBatchExpiration() {
            if (this.batchExpirationSuspended) {
                this.batchExpirationSuspended = false;
            }
        }

        void forceBatchExpiration() {
            this.forceBatchExpiration = true;
        }

        private void processBatch() {
            if (!this.batchExpirationSuspended && (this.forceBatchExpiration || (long)this.expiredTombstones.size() >= EXPIRED_TOMBSTONE_LIMIT) || this.testHook_batchExpired != null) {
                this.forceBatchExpiration = false;
                this.expireBatch();
            }
        }

        boolean hasExpiredTombstone(LocalRegion r, RegionEntry re, VersionTag tag) {
            boolean retry;
            int entryVersion = tag.getEntryVersion();
            do {
                retry = false;
                try {
                    for (Tombstone t : this.expiredTombstones) {
                        if (t.region != r || !t.entry.getKey().equals(re.getKey()) || t.getEntryVersion() != entryVersion) continue;
                        return true;
                    }
                }
                catch (ConcurrentModificationException e) {
                    retry = true;
                }
            } while (retry);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void expireBatch() {
            if (this.batchExpirationInProgress) {
                return;
            }
            Object object = this.cache.getTombstoneService().blockGCLock;
            synchronized (object) {
                int count = this.cache.getTombstoneService().getGCBlockCount();
                if (count > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("expireBatch skipped due to {} Delta GII on going", new Object[]{count});
                    }
                    return;
                }
                this.batchExpirationInProgress = true;
                boolean batchScheduled = false;
                try {
                    final HashSet<DistributedRegion> regionsAffected = new HashSet<DistributedRegion>();
                    Set<Tombstone> expired = this.expiredTombstones;
                    long removalSize = 0L;
                    this.expiredTombstones = new HashSet<Tombstone>();
                    if (expired.size() == 0) {
                        return;
                    }
                    for (Tombstone t : expired) {
                        t.region.getVersionVector().recordGCVersion(t.getMemberID(), t.getRegionVersion());
                        regionsAffected.add((DistributedRegion)t.region);
                    }
                    for (DistributedRegion r : regionsAffected) {
                        r.getVersionVector().pruneOldExceptions();
                        if (!r.getDataPolicy().withPersistence()) continue;
                        r.getDiskRegion().writeRVVGC(r);
                    }
                    final HashMap<LocalRegion, HashSet<Object>> reapedKeys = new HashMap<LocalRegion, HashSet<Object>>();
                    for (Tombstone t : expired) {
                        if (t.region.getRegionMap().removeTombstone(t.entry, t, false, true) && t.region.isUsedForPartitionedRegionBucket()) {
                            HashSet<Object> keys = (HashSet<Object>)reapedKeys.get(t.region);
                            if (keys == null) {
                                keys = new HashSet<Object>();
                                reapedKeys.put(t.region, keys);
                            }
                            keys.add(t.entry.getKey());
                        }
                        removalSize += (long)t.getSize();
                    }
                    this.queueSize.addAndGet(-removalSize);
                    this.cache.getDistributionManager().getWaitingThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                for (DistributedRegion r : regionsAffected) {
                                    r.distributeTombstoneGC((Set)reapedKeys.get(r));
                                }
                            }
                            finally {
                                batchExpirationInProgress = false;
                            }
                        }
                    });
                    batchScheduled = true;
                }
                finally {
                    if (this.testHook_batchExpired != null) {
                        this.testHook_batchExpired.countDown();
                    }
                    if (!batchScheduled) {
                        this.batchExpirationInProgress = false;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long minimumRetentionMs = this.expiryTime / 10L;
            long maximumSleepTime = 10000L;
            if (logger.isTraceEnabled(LogMarker.TOMBSTONE)) {
                logger.trace(LogMarker.TOMBSTONE, "Destroyed entries sweeper starting with default sleep interval={}", new Object[]{this.expiryTime});
            }
            this.currentTombstone = null;
            long minimumScanTime = 100L;
            long scanInterval = Math.min(DEFUNCT_TOMBSTONE_SCAN_INTERVAL, this.expiryTime);
            long lastScanTime = this.cache.cacheTimeMillis();
            while (!this.isStopped && this.cache.getCancelCriterion().cancelInProgress() == null) {
                Throwable problem;
                block63: {
                    problem = null;
                    try {
                        long sleepTime;
                        if (this.batchMode) {
                            this.cache.getCachePerfStats().setReplicatedTombstonesSize(this.queueSize.get());
                        } else {
                            this.cache.getCachePerfStats().setNonReplicatedTombstonesSize(this.queueSize.get());
                        }
                        SystemFailure.checkFailure();
                        long now = this.cache.cacheTimeMillis();
                        if (this.forceExpirationCount <= 0L) {
                            if (this.batchMode) {
                                this.processBatch();
                            }
                            if (GC_MEMORY_THRESHOLD > 0.0 && this.batchMode) {
                                Runtime rt = Runtime.getRuntime();
                                long freeMemory = rt.freeMemory();
                                long totalMemory = rt.totalMemory();
                                long maxMemory = rt.maxMemory();
                                freeMemory += maxMemory - totalMemory;
                                if (FORCE_GC_MEMORY_EVENTS || (double)freeMemory / ((double)totalMemory * 1.0) < GC_MEMORY_THRESHOLD) {
                                    boolean bl = this.forceBatchExpiration = !this.batchExpirationInProgress && (long)this.expiredTombstones.size() > EXPIRED_TOMBSTONE_LIMIT / 4L;
                                    if (this.forceBatchExpiration && logger.isDebugEnabled()) {
                                        logger.debug("forcing batch expiration due to low memory conditions");
                                    }
                                }
                            }
                        }
                        if (this.currentTombstone == null) {
                            try {
                                this.currentTombstoneLock.lock();
                                try {
                                    this.currentTombstone = this.tombstones.remove();
                                }
                                finally {
                                    this.currentTombstoneLock.unlock();
                                }
                                if (logger.isTraceEnabled(LogMarker.TOMBSTONE)) {
                                    logger.trace(LogMarker.TOMBSTONE, "current tombstone is {}", new Object[]{this.currentTombstone});
                                }
                            }
                            catch (NoSuchElementException e) {
                                if (logger.isTraceEnabled(LogMarker.TOMBSTONE)) {
                                    logger.trace(LogMarker.TOMBSTONE, "queue is empty - will sleep");
                                }
                                this.forceExpirationCount = 0L;
                            }
                        }
                        if (this.currentTombstone == null) {
                            sleepTime = this.expiryTime;
                        } else if (this.currentTombstone.getVersionTimeStamp() + this.expiryTime > now && (this.forceExpirationCount <= 0L || this.currentTombstone.getVersionTimeStamp() + this.expiryTime - now <= minimumRetentionMs)) {
                            sleepTime = this.currentTombstone.getVersionTimeStamp() + this.expiryTime - now;
                        } else {
                            if (this.forceExpirationCount > 0L) {
                                --this.forceExpirationCount;
                            }
                            sleepTime = 0L;
                            try {
                                if (this.batchMode) {
                                    if (logger.isTraceEnabled(LogMarker.TOMBSTONE)) {
                                        logger.trace(LogMarker.TOMBSTONE, "expiring tombstone {}", new Object[]{this.currentTombstone});
                                    }
                                    this.expiredTombstones.add(this.currentTombstone);
                                } else {
                                    if (logger.isTraceEnabled(LogMarker.TOMBSTONE)) {
                                        logger.trace(LogMarker.TOMBSTONE, "removing expired tombstone {}", new Object[]{this.currentTombstone});
                                    }
                                    this.queueSize.addAndGet(-this.currentTombstone.getSize());
                                    this.currentTombstone.region.getRegionMap().removeTombstone(this.currentTombstone.entry, this.currentTombstone, false, true);
                                }
                                this.currentTombstoneLock.lock();
                                try {
                                    this.currentTombstone = null;
                                }
                                finally {
                                    this.currentTombstoneLock.unlock();
                                }
                            }
                            catch (CancelException e) {
                                return;
                            }
                            catch (Exception e) {
                                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GemFireCacheImpl_TOMBSTONE_ERROR), (Throwable)e);
                                this.currentTombstoneLock.lock();
                                try {
                                    this.currentTombstone = null;
                                }
                                finally {
                                    this.currentTombstoneLock.unlock();
                                }
                            }
                        }
                        if (sleepTime <= 0L) break block63;
                        if ((sleepTime = Math.min(sleepTime, scanInterval)) > minimumScanTime && now - lastScanTime > scanInterval) {
                            long elapsed;
                            lastScanTime = now;
                            long start = now;
                            Iterator<Object> it = this.tombstones.iterator();
                            while (it.hasNext()) {
                                Tombstone test = (Tombstone)it.next();
                                if (!it.hasNext()) continue;
                                if (test.region.getRegionMap().isTombstoneNotNeeded(test.entry, test.getEntryVersion())) {
                                    it.remove();
                                    this.queueSize.addAndGet(-test.getSize());
                                    if (test != this.currentTombstone) continue;
                                    this.currentTombstoneLock.lock();
                                    try {
                                        this.currentTombstone = null;
                                    }
                                    finally {
                                        this.currentTombstoneLock.unlock();
                                    }
                                    sleepTime = 0L;
                                    continue;
                                }
                                if (!this.batchMode || test == this.currentTombstone || test.getVersionTimeStamp() + this.expiryTime > now) continue;
                                it.remove();
                                this.queueSize.addAndGet(-test.getSize());
                                if (logger.isTraceEnabled(LogMarker.TOMBSTONE)) {
                                    logger.trace(LogMarker.TOMBSTONE, "expiring tombstone {}", new Object[]{this.currentTombstone});
                                }
                                this.expiredTombstones.add(test);
                                sleepTime = 0L;
                            }
                            if (this.batchMode) {
                                it = this.expiredTombstones.iterator();
                                while (it.hasNext()) {
                                    Tombstone test = (Tombstone)it.next();
                                    if (!test.region.getRegionMap().isTombstoneNotNeeded(test.entry, test.getEntryVersion())) continue;
                                    if (logger.isTraceEnabled(LogMarker.TOMBSTONE)) {
                                        logger.trace(LogMarker.TOMBSTONE, "removing obsolete tombstone: {}", new Object[]{test});
                                    }
                                    it.remove();
                                    this.queueSize.addAndGet(-test.getSize());
                                    if (test != this.currentTombstone) continue;
                                    this.currentTombstoneLock.lock();
                                    try {
                                        this.currentTombstone = null;
                                    }
                                    finally {
                                        this.currentTombstoneLock.unlock();
                                    }
                                    sleepTime = 0L;
                                }
                            }
                            if (sleepTime > 0L && (sleepTime -= (elapsed = this.cache.cacheTimeMillis() - start)) <= 0L) {
                                minimumScanTime = elapsed;
                                continue;
                            }
                        }
                        if (this.batchMode && IDLE_EXPIRATION && sleepTime >= this.expiryTime && this.expiredTombstones.size() > 0) {
                            this.expireBatch();
                        }
                        if (sleepTime <= 0L) break block63;
                        try {
                            sleepTime = Math.min(sleepTime, maximumSleepTime);
                            if (logger.isTraceEnabled(LogMarker.TOMBSTONE)) {
                                logger.trace(LogMarker.TOMBSTONE, "sleeping for {}", new Object[]{sleepTime});
                            }
                            TombstoneSweeper start = this;
                            synchronized (start) {
                                if (this.isStopped) {
                                    return;
                                }
                                this.wait(sleepTime);
                            }
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    catch (CancelException e) {
                        break;
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable e) {
                        SystemFailure.checkFailure();
                        problem = e;
                    }
                }
                if (problem == null) continue;
                logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.TombstoneService_UNEXPECTED_EXCEPTION), problem);
            }
        }
    }

    private static class Tombstone
    extends CompactVersionHolder {
        public static int PER_TOMBSTONE_OVERHEAD = ReflectionSingleObjectSizer.REFERENCE_SIZE + ReflectionSingleObjectSizer.REFERENCE_SIZE * 3 + ReflectionSingleObjectSizer.REFERENCE_SIZE + 18;
        RegionEntry entry;
        LocalRegion region;

        Tombstone(RegionEntry entry, LocalRegion region, VersionTag destroyedVersion) {
            super(destroyedVersion);
            this.entry = entry;
            this.region = region;
        }

        public int getSize() {
            return PER_TOMBSTONE_OVERHEAD + ObjectSizer.DEFAULT.sizeof(this.entry.getKey());
        }

        @Override
        public String toString() {
            String v = super.toString();
            StringBuilder sb = new StringBuilder();
            sb.append("(").append(this.entry.getKey()).append("; ").append(this.region.getName()).append("; ").append(v).append(")");
            return sb.toString();
        }
    }
}

