/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.TransactionDataNotColocatedException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessage;
import com.gemstone.gemfire.internal.cache.TXCommitMessage;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXMessage;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class TXRemoteCommitMessage
extends TXMessage {
    private static final Logger logger = LogService.getLogger();

    public TXRemoteCommitMessage() {
    }

    public TXRemoteCommitMessage(int txUniqId, InternalDistributedMember onBehalfOfClientMember, ReplyProcessor21 processor) {
        super(txUniqId, onBehalfOfClientMember, processor);
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    public static RemoteCommitResponse send(Cache cache, int txUniqId, InternalDistributedMember onBehalfOfClientMember, DistributedMember recipient) {
        InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        RemoteCommitResponse p = new RemoteCommitResponse(system, recipients);
        TXRemoteCommitMessage msg = new TXRemoteCommitMessage(txUniqId, onBehalfOfClientMember, p);
        msg.setRecipients(recipients);
        system.getDistributionManager().putOutgoing(msg);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean operateOnTx(TXId txId, DistributionManager dm) throws RemoteOperationException {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        TXManagerImpl txMgr = cache.getTXMgr();
        if (logger.isDebugEnabled()) {
            logger.debug("TX: Committing: {}", new Object[]{txId});
        }
        TXStateProxy txState = txMgr.getTXState();
        boolean commitSuccessful = false;
        TXCommitMessage cmsg = null;
        try {
            if (txMgr.isHostedTxRecentlyCompleted(txId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("TX: found a previously committed transaction:{}", new Object[]{txId});
                }
                if (txMgr.isExceptionToken(cmsg = txMgr.getRecentlyCompletedMessage(txId))) {
                    throw txMgr.getExceptionForToken(cmsg, txId);
                }
                commitSuccessful = true;
            } else if (txState != null) {
                txState.setCommitOnBehalfOfRemoteStub(true);
                txMgr.commit();
                commitSuccessful = true;
                cmsg = txState.getCommitMessage();
            }
        }
        finally {
            if (commitSuccessful || !cache.isSqlfSystem()) {
                txMgr.removeHostedTXState(txId);
            }
        }
        TXRemoteCommitReplyMessage.send(this.getSender(), this.getProcessorId(), cmsg, this.getReplySender(dm));
        return false;
    }

    @Override
    public int getDSFID() {
        return -112;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    public static class RemoteCommitResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private volatile TXCommitMessage commitMessage;
        private volatile long start;

        public RemoteCommitResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, (Collection)recipients, true);
        }

        public TXCommitMessage getCommitMessage() {
            return this.commitMessage;
        }

        @Override
        public void process(DistributionMessage msg) {
            if (DistributionStats.enableClockStats) {
                this.start = DistributionStats.getStatTime();
            }
            if (msg instanceof TXRemoteCommitReplyMessage) {
                TXRemoteCommitReplyMessage reply = (TXRemoteCommitReplyMessage)msg;
                this.commitMessage = reply.getCommitMessage();
            }
            super.process(msg);
        }

        public TXCommitMessage waitForResponse() throws RemoteOperationException {
            try {
                this.waitForCacheException();
                if (DistributionStats.enableClockStats) {
                    this.getDistributionManager().getStats().incReplyHandOffTime(this.start);
                }
            }
            catch (RemoteOperationException e) {
                String msg = "RemoteCommitResponse got RemoteOperationException; rethrowing";
                logger.debug("RemoteCommitResponse got RemoteOperationException; rethrowing", (Throwable)e);
                throw e;
            }
            catch (TransactionDataNotColocatedException e) {
                throw e;
            }
            return this.commitMessage;
        }
    }

    public static final class TXRemoteCommitReplyMessage
    extends ReplyMessage {
        private transient TXCommitMessage commitMessage;
        public transient byte[] valueInBytes;

        public TXRemoteCommitReplyMessage() {
        }

        public TXRemoteCommitReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        private TXRemoteCommitReplyMessage(int processorId, TXCommitMessage val) {
            this.setProcessorId(processorId);
            this.commitMessage = val;
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public static void send(InternalDistributedMember recipient, int processorId, TXCommitMessage val, ReplySender replySender) throws RemoteOperationException {
            Assert.assertTrue(recipient != null, "TXRemoteCommitReply NULL reply message");
            TXRemoteCommitReplyMessage m = new TXRemoteCommitReplyMessage(processorId, val);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "TXRemoteCommitReply process invoking reply processor with processorId:{}", new Object[]{this.processorId});
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "TXRemoteCommitReply processor not found");
                }
                return;
            }
            processor.process(this);
        }

        @Override
        public int getDSFID() {
            return -39;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.commitMessage, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.commitMessage = (TXCommitMessage)DataSerializer.readObject(in);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("TXRemoteCommitReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }

        public TXCommitMessage getCommitMessage() {
            return this.commitMessage;
        }
    }
}

