/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.SerialDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.TransactionMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public abstract class TXMessage
extends SerialDistributionMessage
implements MessageWithReply,
TransactionMessage {
    private static final Logger logger = LogService.getLogger();
    private int processorId;
    private int txUniqId;
    private InternalDistributedMember txMemberId = null;

    public TXMessage() {
    }

    public TXMessage(int txUniqueId, InternalDistributedMember onBehalfOfMember, ReplyProcessor21 processor) {
        this.txUniqId = txUniqueId;
        this.txMemberId = onBehalfOfMember;
        this.processorId = processor == null ? 0 : processor.getProcessorId();
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        Throwable thr = null;
        boolean sendReply = true;
        try {
            GemFireCacheImpl cache;
            if (logger.isDebugEnabled()) {
                logger.debug("processing {}", new Object[]{this});
            }
            if (this.checkCacheClosing(cache = GemFireCacheImpl.getInstance()) || this.checkDSClosing(cache.getDistributedSystem())) {
                thr = new CacheClosedException(LocalizedStrings.PartitionMessage_REMOTE_CACHE_IS_CLOSED_0.toLocalizedString(dm.getId()));
                return;
            }
            TXManagerImpl txMgr = cache.getTXMgr();
            TXStateProxy tx = null;
            try {
                assert (this.txUniqId != -1);
                TXId txId = new TXId(this.getMemberToMasqueradeAs(), this.txUniqId);
                tx = txMgr.masqueradeAs(this);
                sendReply = this.operateOnTx(txId, dm);
                txMgr.unmasquerade(tx);
            }
            catch (Throwable throwable) {
                txMgr.unmasquerade(tx);
                throw throwable;
            }
        }
        catch (CommitConflictException cce) {
            thr = cce;
        }
        catch (DistributedSystemDisconnectedException se) {
            sendReply = false;
            if (logger.isDebugEnabled()) {
                logger.debug("shutdown caught, abandoning message: " + se);
            }
        }
        catch (RegionDestroyedException rde) {
            thr = new ForceReattemptException(LocalizedStrings.PartitionMessage_REGION_IS_DESTROYED_IN_0.toLocalizedString(dm.getDistributionManagerId()), rde);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            if (sendReply) {
                thr = t;
            }
        }
        finally {
            ReplySender rs = this.getReplySender(dm);
            if (sendReply && (this.processorId != 0 || rs != dm)) {
                ReplyException rex = null;
                if (thr != null) {
                    rex = new ReplyException(thr);
                }
                this.sendReply(this.getSender(), this.processorId, dm, rex);
            }
        }
    }

    private boolean checkDSClosing(InternalDistributedSystem distributedSystem) {
        return distributedSystem == null || distributedSystem.isDisconnecting();
    }

    private boolean checkCacheClosing(GemFireCacheImpl cache) {
        return cache == null || cache.isClosed();
    }

    private void sendReply(InternalDistributedMember recipient, int processorId2, DistributionManager dm, ReplyException rex) {
        ReplyMessage.send(recipient, processorId2, rex, this.getReplySender(dm));
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        String className = this.getClass().getName();
        buff.append(className.substring(className.indexOf(".cache.") + ".cache.".length()));
        buff.append("(txId=").append(this.txUniqId).append("; txMbr=").append(this.txMemberId).append("; sender=").append(this.getSender()).append("; processorId=").append(this.processorId);
        this.appendFields(buff);
        buff.append(")");
        return buff.toString();
    }

    public void appendFields(StringBuffer buff) {
    }

    protected abstract boolean operateOnTx(TXId var1, DistributionManager var2) throws RemoteOperationException;

    @Override
    public int getTXUniqId() {
        return this.txUniqId;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
        out.writeInt(this.txUniqId);
        DataSerializer.writeObject(this.txMemberId, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
        this.txUniqId = in.readInt();
        this.txMemberId = (InternalDistributedMember)DataSerializer.readObject(in);
    }

    @Override
    public final InternalDistributedMember getMemberToMasqueradeAs() {
        if (this.txMemberId == null) {
            return this.getSender();
        }
        return this.txMemberId;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    public InternalDistributedMember getTXOriginatorClient() {
        return this.txMemberId;
    }

    @Override
    public boolean canParticipateInTransaction() {
        return true;
    }

    @Override
    public boolean isTransactionDistributed() {
        return false;
    }
}

