/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.TransactionEvent;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.offheap.Releasable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TXEvent
implements TransactionEvent,
Releasable {
    private final TXStateInterface localTxState;
    private List events;
    private List createEvents = null;
    private List putEvents = null;
    private List invalidateEvents = null;
    private List destroyEvents = null;
    private final Cache cache;

    TXEvent(TXStateInterface localTxState, Cache cache) {
        this.localTxState = localTxState;
        this.cache = cache;
        this.events = null;
    }

    @Override
    public TransactionId getTransactionId() {
        return this.localTxState.getTransactionId();
    }

    public synchronized List getCreateEvents() {
        if (this.createEvents == null) {
            ArrayList<CacheEvent> result = new ArrayList<CacheEvent>();
            for (CacheEvent ce : this.getEvents()) {
                if (!ce.getOperation().isCreate()) continue;
                result.add(ce);
            }
            this.createEvents = result.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(result);
        }
        return this.createEvents;
    }

    public synchronized List getPutEvents() {
        if (this.putEvents == null) {
            ArrayList<CacheEvent> result = new ArrayList<CacheEvent>();
            for (CacheEvent ce : this.getEvents()) {
                if (!ce.getOperation().isUpdate()) continue;
                result.add(ce);
            }
            this.putEvents = result.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(result);
        }
        return this.putEvents;
    }

    public synchronized List getInvalidateEvents() {
        if (this.invalidateEvents == null) {
            ArrayList<CacheEvent> result = new ArrayList<CacheEvent>();
            for (CacheEvent ce : this.getEvents()) {
                if (!ce.getOperation().isInvalidate()) continue;
                result.add(ce);
            }
            this.invalidateEvents = result.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(result);
        }
        return this.invalidateEvents;
    }

    public synchronized List getDestroyEvents() {
        if (this.destroyEvents == null) {
            ArrayList<CacheEvent> result = new ArrayList<CacheEvent>();
            for (CacheEvent ce : this.getEvents()) {
                if (!ce.getOperation().isDestroy()) continue;
                result.add(ce);
            }
            this.destroyEvents = result.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(result);
        }
        return this.destroyEvents;
    }

    public synchronized List getEvents() {
        if (this.events == null) {
            this.events = this.localTxState.getEvents();
        }
        return this.events;
    }

    public boolean hasOnlyInternalEvents() {
        List txevents = this.getEvents();
        if (txevents == null || txevents.isEmpty()) {
            return false;
        }
        for (CacheEvent txevent : txevents) {
            LocalRegion region = (LocalRegion)txevent.getRegion();
            if (region == null || region.isPdxTypesRegion() || region.isInternalRegion()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Cache getCache() {
        return this.cache;
    }

    @Override
    public synchronized void release() {
        if (this.events != null) {
            for (Object o : this.getEvents()) {
                if (!(o instanceof EntryEventImpl)) continue;
                ((EntryEventImpl)o).release();
            }
        }
    }
}

