/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessage;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessageWithDirectReply;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class RemoteRegionOperation
extends RemoteOperationMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private transient DistributedRegion region;
    private Operation op;

    public RemoteRegionOperation() {
    }

    public static RemoteRegionOperation clear(InternalDistributedMember recipient, DistributedRegion region) {
        return new RemoteRegionOperation(recipient, region, Operation.CLEAR);
    }

    private RemoteRegionOperation(InternalDistributedMember recipient, DistributedRegion region, Operation op) {
        super(recipient, region.getFullPath(), (DirectReplyProcessor)new RemoteOperationMessage.RemoteOperationResponse(region.getSystem(), Collections.singleton(recipient)));
        this.op = op;
        this.region = region;
    }

    public void distribute() throws RemoteOperationException {
        RemoteOperationMessage.RemoteOperationResponse p = (RemoteOperationMessage.RemoteOperationResponse)this.processor;
        Set failures = this.region.getDistributionManager().putOutgoing(this);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(LocalizedStrings.FAILED_SENDING_0.toLocalizedString(this));
        }
        p.waitForCacheException();
    }

    @Override
    protected boolean operateOnRegion(DistributionManager dm, LocalRegion r, long startTime) throws CacheException, RemoteOperationException {
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "DistributedRemoteRegionOperation operateOnRegion: {}", new Object[]{r.getFullPath()});
        }
        if (!(r instanceof PartitionedRegion)) {
            r.waitOnInitialization();
        }
        if (this.op.equals((Object)Operation.CLEAR)) {
            r.clear();
        }
        RemoteRegionOperationReplyMessage.send(this.getSender(), this.getProcessorId(), this.getReplySender(dm));
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; operation=").append((Object)this.op);
    }

    @Override
    public int getDSFID() {
        return -131;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.op = Operation.values()[in.readByte()];
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeByte(this.op.ordinal());
    }

    public static final class RemoteRegionOperationReplyMessage
    extends ReplyMessage {
        public RemoteRegionOperationReplyMessage() {
        }

        private RemoteRegionOperationReplyMessage(int processorId) {
            this.processorId = processorId;
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender replySender) {
            Assert.assertTrue(recipient != null, "RemoteRegionOperationReplyMessage NULL reply message");
            RemoteRegionOperationReplyMessage m = new RemoteRegionOperationReplyMessage(processorId);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "RemoteRegionOperationReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -132;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("RemoteRegionOperationReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }
    }

    private static enum Operation {
        CLEAR;

    }
}

