/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.TransactionDataNotColocatedException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.RemoteDestroyMessage;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessage;
import com.gemstone.gemfire.internal.cache.versions.DiskVersionTag;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class RemoteInvalidateMessage
extends RemoteDestroyMessage {
    private static final Logger logger = LogService.getLogger();

    public RemoteInvalidateMessage() {
    }

    private RemoteInvalidateMessage(Set recipients, String regionPath, DirectReplyProcessor processor, EntryEventImpl event, boolean useOriginRemote, boolean possibleDuplicate) {
        super(recipients, regionPath, processor, event, null, 78, useOriginRemote, possibleDuplicate);
    }

    public static boolean distribute(EntryEventImpl event, boolean onlyPersistent) {
        Collection<InternalDistributedMember> replicates;
        boolean successful = false;
        DistributedRegion r = (DistributedRegion)event.getRegion();
        Set<InternalDistributedMember> set = replicates = onlyPersistent ? r.getCacheDistributionAdvisor().adviseInitializedPersistentMembers().keySet() : r.getCacheDistributionAdvisor().adviseInitializedReplicates();
        if (replicates.isEmpty()) {
            return false;
        }
        if (replicates.size() > 1) {
            ArrayList<InternalDistributedMember> l = new ArrayList<InternalDistributedMember>(replicates);
            Collections.shuffle(l);
            replicates = l;
        }
        int attempts = 0;
        for (InternalDistributedMember replicate : replicates) {
            try {
                boolean posDup = ++attempts > 1;
                InvalidateResponse processor = RemoteInvalidateMessage.send(replicate, event.getRegion(), event, 74, false, posDup);
                processor.waitForCacheException();
                VersionTag versionTag = processor.getVersionTag();
                if (versionTag != null) {
                    event.setVersionTag(versionTag);
                    if (event.getRegion().getVersionVector() != null) {
                        event.getRegion().getVersionVector().recordVersion(versionTag.getMemberID(), versionTag);
                    }
                }
                event.setInhibitDistribution(true);
                return true;
            }
            catch (TransactionDataNotColocatedException enfe) {
                throw enfe;
            }
            catch (CancelException e) {
                event.getRegion().getCancelCriterion().checkCancelInProgress(e);
            }
            catch (EntryNotFoundException e) {
                throw new EntryNotFoundException("" + event.getKey());
            }
            catch (CacheException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("RemoteDestroyMessage caught CacheException during distribution", (Throwable)e);
                }
                successful = true;
            }
            catch (RemoteOperationException e) {
                if (!logger.isTraceEnabled(LogMarker.DM)) continue;
                logger.trace(LogMarker.DM, "RemoteDestroyMessage caught an unexpected exception during distribution", (Throwable)e);
            }
        }
        return successful;
    }

    public static InvalidateResponse send(DistributedMember recipient, LocalRegion r, EntryEventImpl event, int processorType, boolean useOriginRemote, boolean possibleDuplicate) throws RemoteOperationException {
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        InvalidateResponse p = new InvalidateResponse(r.getSystem(), recipients, event.getKey());
        RemoteInvalidateMessage m = new RemoteInvalidateMessage(recipients, r.getFullPath(), p, event, useOriginRemote, possibleDuplicate);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(LocalizedStrings.InvalidateMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean operateOnRegion(DistributionManager dm, LocalRegion r, long startTime) throws EntryExistsException, RemoteOperationException {
        InternalDistributedMember eventSender = this.originalSender;
        if (eventSender == null) {
            eventSender = this.getSender();
        }
        Object key = this.getKey();
        if (r.keyRequiresRegionContext()) {
            ((KeyWithRegionContext)key).setRegionContext(r);
        }
        EntryEventImpl event = EntryEventImpl.create(r, this.getOperation(), key, null, this.getCallbackArg(), this.useOriginRemote, (DistributedMember)eventSender, true, false);
        try {
            if (this.bridgeContext != null) {
                event.setContext(this.bridgeContext);
            }
            event.setCausedByMessage(this);
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(this.getSender());
                event.setVersionTag(this.versionTag);
            }
            Assert.assertTrue(this.eventId != null);
            event.setEventId(this.eventId);
            event.setPossibleDuplicate(this.possibleDuplicate);
            boolean eventShouldHaveOldValue = this.getHasOldValue();
            if (eventShouldHaveOldValue) {
                if (this.getOldValueIsSerialized()) {
                    event.setSerializedOldValue(this.getOldValueBytes());
                } else {
                    event.setOldValue(this.getOldValueBytes());
                }
            }
            boolean sendReply = true;
            try {
                r.checkReadiness();
                r.checkForLimitedOrNoAccess();
                r.basicInvalidate(event);
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "remoteInvalidated key: {}", new Object[]{key});
                }
                this.sendReply(this.getSender(), this.processorId, dm, null, event.getRegion(), event.getVersionTag(), startTime);
                sendReply = false;
            }
            catch (EntryNotFoundException eee) {
                if (logger.isDebugEnabled()) {
                    logger.debug("operateOnRegion caught EntryNotFoundException");
                }
                this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(eee), r, null, startTime);
                sendReply = false;
            }
            catch (PrimaryBucketException pbe) {
                this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(pbe), r, startTime);
                boolean bl = false;
                event.release();
                return bl;
            }
            boolean bl = sendReply;
            return bl;
        }
        finally {
            event.release();
        }
    }

    RemoteOperationMessage.RemoteOperationResponse createReplyProcessor(PartitionedRegion r, Set recipients, Object key) {
        return new InvalidateResponse(r.getSystem(), recipients, key);
    }

    @Override
    protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, LocalRegion r, long startTime) {
        this.sendReply(member, procId, dm, ex, r, null, startTime);
    }

    protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, LocalRegion r, VersionTag versionTag, long startTime) {
        InvalidateReplyMessage.send(member, procId, this.getReplySender(dm), versionTag, ex);
    }

    @Override
    public int getDSFID() {
        return -31;
    }

    public static class InvalidateResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private volatile boolean returnValueReceived;
        final Object key;
        VersionTag versionTag;

        public InvalidateResponse(InternalDistributedSystem ds, Set recipients, Object key) {
            super(ds, (Collection)recipients, true);
            this.key = key;
        }

        public void setResponse(VersionTag versionTag) {
            this.returnValueReceived = true;
            this.versionTag = versionTag;
        }

        public void waitForResult() throws CacheException, RemoteOperationException {
            try {
                this.waitForCacheException();
            }
            catch (RemoteOperationException e) {
                e.checkKey(this.key);
                throw e;
            }
            if (!this.returnValueReceived) {
                throw new RemoteOperationException(LocalizedStrings.InvalidateMessage_NO_RESPONSE_CODE_RECEIVED.toLocalizedString());
            }
        }

        public VersionTag getVersionTag() {
            return this.versionTag;
        }
    }

    public static final class InvalidateReplyMessage
    extends ReplyMessage {
        private VersionTag versionTag;
        private static final byte HAS_VERSION = 1;
        private static final byte PERSISTENT = 2;

        public InvalidateReplyMessage() {
        }

        private InvalidateReplyMessage(int processorId, VersionTag versionTag, ReplyException ex) {
            this.setProcessorId(processorId);
            this.versionTag = versionTag;
            this.setException(ex);
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender replySender, VersionTag versionTag, ReplyException ex) {
            Assert.assertTrue(recipient != null, "InvalidateReplyMessage NULL reply message");
            InvalidateReplyMessage m = new InvalidateReplyMessage(processorId, versionTag, ex);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 rp) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "InvalidateReplyMessage process invoking reply processor with processorId:{}", new Object[]{this.processorId});
            }
            if (rp == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "InvalidateReplyMessage processor not found");
                }
                return;
            }
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(this.getSender());
            }
            if (rp instanceof InvalidateResponse) {
                InvalidateResponse processor = (InvalidateResponse)rp;
                processor.setResponse(this.versionTag);
            }
            rp.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", new Object[]{rp, this});
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -30;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            byte b = 0;
            if (this.versionTag != null) {
                b = (byte)(b | 1);
            }
            if (this.versionTag instanceof DiskVersionTag) {
                b = (byte)(b | 2);
            }
            out.writeByte(b);
            if (this.versionTag != null) {
                InternalDataSerializer.invokeToData(this.versionTag, out);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            boolean persistentTag;
            super.fromData(in);
            byte b = in.readByte();
            boolean hasTag = (b & 1) != 0;
            boolean bl = persistentTag = (b & 2) != 0;
            if (hasTag) {
                this.versionTag = VersionTag.create(persistentTag, in);
            }
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("InvalidateReplyMessage ").append("processorid=").append(this.processorId).append(" exception=").append(this.getException());
            if (this.versionTag != null) {
                sb.append("version=").append(this.versionTag);
            }
            return sb.toString();
        }
    }
}

