/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessage;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class RemoteFetchVersionMessage
extends RemoteOperationMessage {
    private static final Logger logger = LogService.getLogger();
    private Object key;

    public RemoteFetchVersionMessage() {
    }

    public static FetchVersionResponse send(InternalDistributedMember recipient, LocalRegion r, Object key) throws RemoteOperationException {
        FetchVersionResponse response = new FetchVersionResponse(r.getSystem(), recipient);
        RemoteFetchVersionMessage msg = new RemoteFetchVersionMessage(recipient, r.getFullPath(), response, key);
        Set failures = r.getDistributionManager().putOutgoing(msg);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(LocalizedStrings.GetMessage_FAILED_SENDING_0.toLocalizedString(msg));
        }
        return response;
    }

    private RemoteFetchVersionMessage(InternalDistributedMember recipient, String regionPath, ReplyProcessor21 processor, Object key) {
        super(recipient, regionPath, processor);
        this.key = key;
    }

    @Override
    public int getDSFID() {
        return 155;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    public int getProcessorType() {
        return 74;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.key = DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.key, out);
    }

    @Override
    protected boolean operateOnRegion(DistributionManager dm, LocalRegion r, long startTime) throws RemoteOperationException {
        if (!(r instanceof PartitionedRegion)) {
            r.waitOnInitialization();
        }
        try {
            RegionEntry re;
            if (r.keyRequiresRegionContext()) {
                ((KeyWithRegionContext)this.key).setRegionContext(r);
            }
            if ((re = r.getRegionEntry(this.key)) == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "RemoteFetchVersionMessage did not find entry for key:{}", new Object[]{this.key});
                }
                r.checkEntryNotFound(this.key);
            }
            VersionTag tag = re.getVersionStamp().asVersionTag();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.debug("RemoteFetchVersionMessage for key:{} returning tag:{}", new Object[]{this.key, tag});
            }
            FetchVersionReplyMessage.send(this.getSender(), this.processorId, tag, dm);
        }
        catch (EntryNotFoundException e) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(e), r, startTime);
        }
        return false;
    }

    public static class FetchVersionResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private volatile VersionTag tag;

        public FetchVersionResponse(InternalDistributedSystem dm, InternalDistributedMember member) {
            super(dm, member, true);
        }

        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof FetchVersionReplyMessage) {
                    FetchVersionReplyMessage reply = (FetchVersionReplyMessage)msg;
                    this.tag = reply.tag;
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "FetchVersionResponse return tag is {}", new Object[]{this.tag});
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        public VersionTag waitForResponse() throws RemoteOperationException {
            try {
                this.waitForCacheException();
            }
            catch (RemoteOperationException e) {
                logger.debug("RemoteFetchVersionMessage threw", (Throwable)e);
                throw e;
            }
            catch (EntryNotFoundException e) {
                logger.debug("RemoteFetchVersionMessage threw", (Throwable)e);
                throw e;
            }
            catch (CacheException e) {
                logger.debug("RemoteFetchVersionMessage threw", (Throwable)e);
                throw new RemoteOperationException("RemoteFetchVersionMessage threw exception", e);
            }
            return this.tag;
        }
    }

    public static final class FetchVersionReplyMessage
    extends ReplyMessage {
        private VersionTag tag;

        public FetchVersionReplyMessage() {
        }

        private FetchVersionReplyMessage(int processorId, VersionTag tag) {
            this.setProcessorId(processorId);
            this.tag = tag;
        }

        public static void send(InternalDistributedMember recipient, int processorId, VersionTag tag, DM dm) {
            FetchVersionReplyMessage reply = new FetchVersionReplyMessage(processorId, tag);
            reply.setRecipient(recipient);
            dm.putOutgoing(reply);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.DM);
            if (isDebugEnabled) {
                logger.trace(LogMarker.DM, "FetchVersionReplyMessage process invoking reply processor with processorId:{}", new Object[]{this.processorId});
            }
            if (processor == null) {
                if (isDebugEnabled) {
                    logger.debug("FetchVersionReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (isDebugEnabled) {
                logger.trace(LogMarker.DM, "{}  Processed  {}", new Object[]{processor, this});
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return 156;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.tag, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.tag = (VersionTag)DataSerializer.readObject(in);
        }
    }
}

