/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.TransactionDataNotColocatedException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.DistributedCacheOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessage;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessageWithDirectReply;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.versions.DiskVersionTag;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class RemoteDestroyMessage
extends RemoteOperationMessageWithDirectReply
implements EntryEventImpl.OldValueImporter {
    private static final Logger logger = LogService.getLogger();
    private static final short FLAG_USEORIGINREMOTE = 1;
    private static final short FLAG_HASOLDVALUE = 2;
    private static final short FLAG_OLDVALUEISSERIALIZED = 4;
    private static final short FLAG_POSSIBLEDUPLICATE = 8;
    private Object key;
    private Object cbArg;
    private Operation op;
    ClientProxyMembershipID bridgeContext;
    EventID eventId;
    InternalDistributedMember originalSender;
    private boolean hasOldValue = false;
    private boolean oldValueIsSerialized = false;
    private Object expectedOldValue;
    private byte[] oldValBytes;
    private transient Object oldValObj;
    boolean useOriginRemote;
    protected boolean possibleDuplicate;
    VersionTag<?> versionTag;
    protected static final short USE_ORIGIN_REMOTE = 64;
    protected static final short HAS_OLD_VALUE = 128;
    protected static final short CACHE_WRITE = 256;
    protected static final short HAS_BRIDGE_CONTEXT = 512;
    protected static final short HAS_ORIGINAL_SENDER = 1024;
    protected static final int HAS_VERSION_TAG = 2048;

    public RemoteDestroyMessage() {
    }

    protected RemoteDestroyMessage(Set recipients, String regionPath, DirectReplyProcessor processor, EntryEventImpl event, Object expectedOldValue, int processorType, boolean useOriginRemote, boolean possibleDuplicate) {
        super(recipients, regionPath, processor);
        this.expectedOldValue = expectedOldValue;
        this.key = event.getKey();
        this.cbArg = event.getRawCallbackArgument();
        this.op = event.getOperation();
        this.bridgeContext = event.getContext();
        this.eventId = event.getEventId();
        this.processorType = processorType;
        this.useOriginRemote = useOriginRemote;
        this.possibleDuplicate = possibleDuplicate;
        this.versionTag = event.getVersionTag();
        Assert.assertTrue(this.eventId != null);
        if (event.hasOldValue()) {
            this.hasOldValue = true;
            event.exportOldValue(this);
        }
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    private void setOldValBytes(byte[] valBytes) {
        this.oldValBytes = valBytes;
    }

    private final void setOldValObj(Object o) {
        this.oldValObj = o;
    }

    public final byte[] getOldValueBytes() {
        return this.oldValBytes;
    }

    private Object getOldValObj() {
        return this.oldValObj;
    }

    protected boolean getHasOldValue() {
        return this.hasOldValue;
    }

    protected boolean getOldValueIsSerialized() {
        return this.oldValueIsSerialized;
    }

    public void setOldValue(EntryEventImpl event) {
        if (event.hasOldValue()) {
            this.hasOldValue = true;
            CachedDeserializable cd = (CachedDeserializable)((Object)event.getSerializedOldValue());
            if (cd != null) {
                if (!cd.isSerialized()) {
                    this.oldValueIsSerialized = false;
                    this.setOldValBytes((byte[])cd.getDeserializedForReading());
                } else {
                    this.oldValueIsSerialized = true;
                    Object o = cd.getValue();
                    if (o instanceof byte[]) {
                        this.setOldValBytes((byte[])o);
                    } else {
                        this.setOldValObj(o);
                    }
                }
            } else {
                Object old = event.getRawOldValue();
                if (old instanceof byte[]) {
                    this.oldValueIsSerialized = false;
                    this.setOldValBytes((byte[])old);
                } else {
                    this.oldValueIsSerialized = true;
                    this.setOldValObj(old);
                }
            }
        }
    }

    public static boolean distribute(EntryEventImpl event, Object expectedOldValue, boolean onlyPersistent) {
        Collection<InternalDistributedMember> replicates;
        boolean successful = false;
        DistributedRegion r = (DistributedRegion)event.getRegion();
        Set<InternalDistributedMember> set = replicates = onlyPersistent ? r.getCacheDistributionAdvisor().adviseInitializedPersistentMembers().keySet() : r.getCacheDistributionAdvisor().adviseInitializedReplicates();
        if (replicates.isEmpty()) {
            return false;
        }
        if (replicates.size() > 1) {
            ArrayList<InternalDistributedMember> l = new ArrayList<InternalDistributedMember>(replicates);
            Collections.shuffle(l);
            replicates = l;
        }
        int attempts = 0;
        for (InternalDistributedMember replicate : replicates) {
            try {
                boolean posDup = ++attempts > 1;
                RemoteDestroyReplyProcessor processor = RemoteDestroyMessage.send(replicate, event.getRegion(), event, expectedOldValue, 74, false, posDup);
                processor.waitForCacheException();
                VersionTag versionTag = processor.getVersionTag();
                if (versionTag != null) {
                    event.setVersionTag(versionTag);
                    if (event.getRegion().getVersionVector() != null) {
                        event.getRegion().getVersionVector().recordVersion(versionTag.getMemberID(), versionTag);
                    }
                }
                event.setInhibitDistribution(true);
                return true;
            }
            catch (EntryNotFoundException e) {
                throw new EntryNotFoundException("" + event.getKey());
            }
            catch (TransactionDataNotColocatedException enfe) {
                throw enfe;
            }
            catch (CancelException e) {
                event.getRegion().getCancelCriterion().checkCancelInProgress(e);
            }
            catch (CacheException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("RemoteDestroyMessage caught CacheException during distribution", (Throwable)e);
                }
                successful = true;
            }
            catch (RemoteOperationException e) {
                if (!logger.isTraceEnabled(LogMarker.DM)) continue;
                logger.trace(LogMarker.DM, "RemoteDestroyMessage caught an unexpected exception during distribution", (Throwable)e);
            }
        }
        return successful;
    }

    public static RemoteDestroyReplyProcessor send(DistributedMember recipient, LocalRegion r, EntryEventImpl event, Object expectedOldValue, int processorType, boolean useOriginRemote, boolean possibleDuplicate) throws RemoteOperationException {
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        RemoteDestroyReplyProcessor p = new RemoteDestroyReplyProcessor(r.getSystem(), recipients, (Object)false);
        p.requireResponse();
        RemoteDestroyMessage m = new RemoteDestroyMessage(recipients, r.getFullPath(), p, event, expectedOldValue, processorType, useOriginRemote, possibleDuplicate);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(LocalizedStrings.RemoteDestroyMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    @Override
    public int getProcessorType() {
        return this.processorType;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean operateOnRegion(DistributionManager dm, LocalRegion r, long startTime) throws EntryExistsException, RemoteOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int getDSFID() {
        return -32;
    }

    private void sendReply(DM dm, VersionTag versionTag) {
        DestroyReplyMessage.send(this.getSender(), this.getReplySender(dm), this.processorId, versionTag);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.setKey(DataSerializer.readObject(in));
        this.cbArg = DataSerializer.readObject(in);
        this.op = Operation.fromOrdinal(in.readByte());
        if ((this.flags & 0x200) != 0) {
            this.bridgeContext = (ClientProxyMembershipID)DataSerializer.readObject(in);
        }
        if ((this.flags & 0x400) != 0) {
            this.originalSender = (InternalDistributedMember)DataSerializer.readObject(in);
        }
        this.eventId = (EventID)DataSerializer.readObject(in);
        if (this.hasOldValue) {
            in.readByte();
            this.setOldValBytes(DataSerializer.readByteArray(in));
        }
        this.expectedOldValue = DataSerializer.readObject(in);
        this.versionTag = (VersionTag)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.getKey(), out);
        DataSerializer.writeObject(this.cbArg, out);
        out.writeByte(this.op.ordinal);
        if (this.bridgeContext != null) {
            DataSerializer.writeObject(this.bridgeContext, out);
        }
        if (this.originalSender != null) {
            DataSerializer.writeObject(this.originalSender, out);
        }
        DataSerializer.writeObject(this.eventId, out);
        if (this.hasOldValue) {
            out.writeByte(this.oldValueIsSerialized ? 1 : 0);
            byte policy = DistributedCacheOperation.valueIsToDeserializationPolicy(this.oldValueIsSerialized);
            DistributedCacheOperation.writeValue(policy, this.getOldValObj(), this.getOldValueBytes(), out);
        }
        DataSerializer.writeObject(this.expectedOldValue, out);
        DataSerializer.writeObject(this.versionTag, out);
    }

    @Override
    protected void setFlags(short flags, DataInput in) throws IOException, ClassNotFoundException {
        super.setFlags(flags, in);
        this.hasOldValue = (flags & 0x80) != 0;
        this.useOriginRemote = (flags & 0x40) != 0;
        this.possibleDuplicate = (flags & 8) != 0;
    }

    @Override
    protected short computeCompressedShort() {
        short s = super.computeCompressedShort();
        if (this.hasOldValue) {
            s = (short)(s | 0x80);
        }
        if (this.useOriginRemote) {
            s = (short)(s | 0x40);
        }
        if (this.possibleDuplicate) {
            s = (short)(s | 8);
        }
        if (this.bridgeContext != null) {
            s = (short)(s | 0x200);
        }
        if (this.originalSender != null) {
            s = (short)(s | 0x400);
        }
        if (this.versionTag != null) {
            s = (short)(s | 0x800);
        }
        return s;
    }

    @Override
    public EventID getEventID() {
        return this.eventId;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; key=").append(this.getKey());
        if (this.originalSender != null) {
            buff.append("; originalSender=").append(this.originalSender);
        }
        if (this.bridgeContext != null) {
            buff.append("; bridgeContext=").append(this.bridgeContext);
        }
        if (this.eventId != null) {
            buff.append("; eventId=").append(this.eventId);
        }
        buff.append("; hasOldValue= ").append(this.hasOldValue);
    }

    protected final Object getKey() {
        return this.key;
    }

    private final void setKey(Object key) {
        this.key = key;
    }

    public final Operation getOperation() {
        return this.op;
    }

    protected final Object getCallbackArg() {
        return this.cbArg;
    }

    @Override
    public boolean prefersOldSerialized() {
        return true;
    }

    @Override
    public boolean isUnretainedOldReferenceOk() {
        return true;
    }

    @Override
    public boolean isCachedDeserializableValueOk() {
        return false;
    }

    private void setOldValueIsSerialized(boolean isSerialized) {
        this.oldValueIsSerialized = isSerialized ? (CachedDeserializableFactory.preferObject() ? true : true) : false;
    }

    @Override
    public void importOldObject(Object ov, boolean isSerialized) {
        this.setOldValueIsSerialized(isSerialized);
        this.setOldValObj(ov);
    }

    @Override
    public void importOldBytes(byte[] ov, boolean isSerialized) {
        this.setOldValueIsSerialized(isSerialized);
        this.setOldValBytes(ov);
    }

    static class RemoteDestroyReplyProcessor
    extends RemoteOperationMessage.RemoteOperationResponse {
        VersionTag versionTag;

        RemoteDestroyReplyProcessor(InternalDistributedSystem ds, Set recipients, Object key) {
            super(ds, (Collection)recipients, false);
        }

        void setResponse(VersionTag versionTag) {
            this.versionTag = versionTag;
        }

        VersionTag getVersionTag() {
            return this.versionTag;
        }
    }

    public static class DestroyReplyMessage
    extends ReplyMessage {
        private static final byte HAS_VERSION = 1;
        private static final byte PERSISTENT = 2;
        private VersionTag versionTag;

        public DestroyReplyMessage() {
        }

        static void send(InternalDistributedMember recipient, ReplySender dm, int procId, VersionTag versionTag) {
            Assert.assertTrue(recipient != null, "DestroyReplyMessage NULL recipient");
            DestroyReplyMessage m = new DestroyReplyMessage(recipient, procId, versionTag);
            dm.putOutgoing(m);
        }

        DestroyReplyMessage(InternalDistributedMember recipient, int procId, VersionTag versionTag) {
            this.setProcessorId(procId);
            this.setRecipient(recipient);
            this.versionTag = versionTag;
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        @Override
        public int getDSFID() {
            return 151;
        }

        @Override
        public void process(DM dm, ReplyProcessor21 rp) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "DestroyReplyMessage process invoking reply processor with processorId:{}", new Object[]{this.processorId});
            }
            if (rp == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "DestroyReplyMessage processor not found");
                }
                return;
            }
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(this.getSender());
            }
            if (rp instanceof RemoteDestroyReplyProcessor) {
                RemoteDestroyReplyProcessor processor = (RemoteDestroyReplyProcessor)rp;
                processor.setResponse(this.versionTag);
            }
            rp.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", new Object[]{rp, this});
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            byte b = 0;
            if (this.versionTag != null) {
                b = (byte)(b | 1);
            }
            if (this.versionTag instanceof DiskVersionTag) {
                b = (byte)(b | 2);
            }
            out.writeByte(b);
            if (this.versionTag != null) {
                InternalDataSerializer.invokeToData(this.versionTag, out);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            boolean persistentTag;
            super.fromData(in);
            byte b = in.readByte();
            boolean hasTag = (b & 1) != 0;
            boolean bl = persistentTag = (b & 2) != 0;
            if (hasTag) {
                this.versionTag = VersionTag.create(persistentTag, in);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = super.getStringBuilder();
            sb.append(this.getShortClassName());
            sb.append(" processorId=");
            sb.append(this.processorId);
            if (this.versionTag != null) {
                sb.append(" version=").append(this.versionTag);
            }
            sb.append(" from ");
            sb.append(this.getSender());
            ReplyException ex = this.getException();
            if (ex != null) {
                sb.append(" with exception ");
                sb.append(ex);
            }
            return sb.toString();
        }
    }
}

