/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionExpiryTask;

class RegionIdleExpiryTask
extends RegionExpiryTask {
    RegionIdleExpiryTask(LocalRegion reg) {
        super(reg);
    }

    @Override
    public long getExpirationTime() throws EntryNotFoundException {
        ExpirationAction action = this.getAction();
        if ((action == ExpirationAction.INVALIDATE || action == ExpirationAction.LOCAL_INVALIDATE) && this.getLocalRegion().regionInvalid) {
            int timeout = this.getIdleAttributes().getTimeout();
            if (timeout == 0) {
                return 0L;
            }
            if (!this.getLocalRegion().EXPIRY_UNITS_MS) {
                timeout *= 1000;
            }
            return (long)timeout + this.getLocalRegion().cacheTimeMillis();
        }
        return this.getIdleExpirationTime();
    }

    @Override
    protected ExpirationAction getAction() {
        return this.getIdleAttributes().getAction();
    }

    @Override
    protected final void addExpiryTask() {
        this.getLocalRegion().addIdleExpiryTask(this);
    }

    @Override
    public boolean isPending() {
        return false;
    }
}

