/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.internal.cache.AbstractDiskRegion;
import com.gemstone.gemfire.internal.cache.DiskEntry;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionMap;
import com.gemstone.gemfire.internal.cache.lru.LRUStatistics;
import com.gemstone.gemfire.internal.cache.persistence.DiskRecoveryStore;
import com.gemstone.gemfire.internal.cache.persistence.DiskRegionView;
import com.gemstone.gemfire.internal.cache.persistence.DiskStoreID;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;

public class PlaceHolderDiskRegion
extends AbstractDiskRegion
implements DiskRecoveryStore {
    private final String name;
    LRUStatistics prlruStats;

    PlaceHolderDiskRegion(DiskStoreImpl ds, long id, String name) {
        super(ds, id);
        this.name = name;
    }

    PlaceHolderDiskRegion(DiskRegionView drv) {
        super(drv);
        this.name = drv.getName();
    }

    public LRUStatistics getPRLRUStats() {
        return this.prlruStats;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public String getPrName() {
        assert (this.isBucket());
        String bn = PartitionedRegionHelper.getBucketName(this.name);
        return PartitionedRegionHelper.getPRPath(bn);
    }

    @Override
    void beginDestroyRegion(LocalRegion region) {
    }

    @Override
    public void finishPendingDestroy() {
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("name=").append(this.name).append(" id=").append(this.getId());
        return sb.toString();
    }

    @Override
    public DiskRegionView getDiskRegionView() {
        return this;
    }

    @Override
    public DiskEntry getDiskEntry(Object key) {
        RegionEntry re = this.getRecoveredEntryMap().getEntry(key);
        if (re != null && re.isRemoved() && !re.isTombstone()) {
            re = null;
        }
        return (DiskEntry)re;
    }

    @Override
    public DiskEntry initializeRecoveredEntry(Object key, DiskEntry.RecoveredEntry value) {
        RegionEntry re = this.getRecoveredEntryMap().initRecoveredEntry(key, value);
        if (re == null) {
            throw new InternalGemFireError(LocalizedStrings.LocalRegion_ENTRY_ALREADY_EXISTED_0.toLocalizedString(key));
        }
        return (DiskEntry)re;
    }

    @Override
    public DiskEntry updateRecoveredEntry(Object key, DiskEntry.RecoveredEntry value) {
        return (DiskEntry)this.getRecoveredEntryMap().updateRecoveredEntry(key, value);
    }

    @Override
    public void destroyRecoveredEntry(Object key) {
        throw new IllegalStateException("destroyRecoveredEntry should not be called during recovery");
    }

    @Override
    public void copyRecoveredEntries(RegionMap rm) {
        throw new IllegalStateException("copyRecoveredEntries should not be called during recovery");
    }

    @Override
    public void foreachRegionEntry(LocalRegion.RegionEntryCallback callback) {
        throw new IllegalStateException("foreachRegionEntry should not be called during recovery");
    }

    @Override
    public boolean lruLimitExceeded() {
        return this.getRecoveredEntryMap().lruLimitExceeded();
    }

    @Override
    public DiskStoreID getDiskStoreID() {
        return this.getDiskStore().getDiskStoreID();
    }

    @Override
    public void acquireReadLock() {
    }

    @Override
    public void releaseReadLock() {
    }

    @Override
    public void updateSizeOnFaultIn(Object key, int newSize, int bytesOnDisk) {
    }

    @Override
    public int calculateValueSize(Object val) {
        return 0;
    }

    @Override
    public int calculateRegionEntryValueSize(RegionEntry re) {
        return 0;
    }

    @Override
    public RegionMap getRegionMap() {
        return this.getRecoveredEntryMap();
    }

    @Override
    public void close() {
        RegionMap rm = this.getRecoveredEntryMap();
        if (rm != null) {
            rm.close();
        }
    }

    @Override
    public void handleDiskAccessException(DiskAccessException dae) {
        this.getDiskStore().getCache().getLoggerI18n().error(LocalizedStrings.PlaceHolderDiskRegion_A_DISKACCESSEXCEPTION_HAS_OCCURED_WHILE_RECOVERING_FROM_DISK, this.getName(), (Throwable)dae);
    }

    @Override
    public boolean didClearCountChange() {
        return false;
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.getDiskStore().getCancelCriterion();
    }

    @Override
    public boolean isSync() {
        return true;
    }

    @Override
    public void endRead(long start, long end, long bytesRead) {
    }

    @Override
    public boolean isRegionClosed() {
        return false;
    }

    @Override
    public void initializeStats(long numEntriesInVM, long numOverflowOnDisk, long numOverflowBytesOnDisk) {
        this.numEntriesInVM.set(numEntriesInVM);
        this.numOverflowOnDisk.set(numOverflowOnDisk);
        this.numOverflowBytesOnDisk.set(numOverflowBytesOnDisk);
    }
}

