/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EntryOperation;
import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.FixedPartitionResolver;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.partition.PartitionNotAvailableException;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryOperationImpl;
import com.gemstone.gemfire.internal.cache.FixedPartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.FixedPartitionAttributesListener;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.HasCachePerfStats;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.Node;
import com.gemstone.gemfire.internal.cache.PartitionRegionConfig;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.Bucket;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.partitioned.RegionAdvisor;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class PartitionedRegionHelper {
    private static final Logger logger = LogService.getLogger();
    static final long BYTES_PER_MB = 0x100000L;
    public static final String PR_ROOT_REGION_NAME = "__PR";
    public static final String PARTITION_LOCK_SERVICE_NAME = "__PRLS";
    static final String BUCKET_REGION_PREFIX = "_B_";
    static final String VM_OWNERSHIP_WAIT_TIME_PROPERTY = "gemfire.VM_OWNERSHIP_WAIT_TIME";
    static final long VM_OWNERSHIP_WAIT_TIME_DEFAULT = Long.MAX_VALUE;
    static final String MAX_PARTITIONED_REGION_ID = "MAX_PARTITIONED_REGION_ID";
    public static final int DEFAULT_WAIT_PER_RETRY_ITERATION = 100;
    public static final int DEFAULT_TOTAL_WAIT_RETRY_ITERATION = 3600000;
    public static final DataPolicy DEFAULT_DATA_POLICY = DataPolicy.PARTITION;
    public static final Set ALLOWED_DATA_POLICIES;
    static final Object dlockMonitor;
    private static final String BUCKET_FULL_PATH_PREFIX = "__PR/_B_";
    public static String TWO_SEPARATORS;

    static void removeGlobalMetadataForFailedNode(Node failedNode, String regionIdentifier, GemFireCacheImpl cache) {
        PartitionedRegionHelper.removeGlobalMetadataForFailedNode(failedNode, regionIdentifier, cache, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeGlobalMetadataForFailedNode(Node failedNode, String regionIdentifier, GemFireCacheImpl cache, boolean lock) {
        LocalRegion root = PartitionedRegionHelper.getPRRoot(cache, false);
        if (root == null) {
            return;
        }
        PartitionRegionConfig prConfig = (PartitionRegionConfig)root.get(regionIdentifier);
        if (null == prConfig || !prConfig.containsNode(failedNode)) {
            return;
        }
        PartitionedRegion.RegionLock rl = PartitionedRegion.getRegionLock(regionIdentifier, cache);
        try {
            if (lock) {
                rl.lock();
            }
            if ((prConfig = (PartitionRegionConfig)root.get(regionIdentifier)) != null && prConfig.containsNode(failedNode)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Cleaning up config for pr {} node {}", new Object[]{regionIdentifier, failedNode});
                }
                if (prConfig.getNumberOfNodes() - 1 <= 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("No nodes left but failed node {} destroying entry {} nodes {}", new Object[]{failedNode, regionIdentifier, prConfig.getNodes()});
                    }
                    try {
                        root.destroy(regionIdentifier);
                    }
                    catch (EntryNotFoundException e) {
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegionHelper_GOT_ENTRYNOTFOUNDEXCEPTION_IN_DESTROY_OP_FOR_ALLPRREGION_KEY_0, regionIdentifier), (Throwable)e);
                    }
                } else {
                    prConfig.removeNode(failedNode);
                    if (prConfig.getNumberOfNodes() == 0) {
                        root.destroy(regionIdentifier);
                    } else {
                        root.put(regionIdentifier, prConfig);
                    }
                }
            }
        }
        finally {
            if (lock) {
                rl.unlock();
            }
        }
    }

    public static LocalRegion getPRRoot(Cache cache) {
        return PartitionedRegionHelper.getPRRoot(cache, true);
    }

    public static LocalRegion getPRRoot(final Cache cache, boolean createIfAbsent) {
        GemFireCacheImpl gemCache = (GemFireCacheImpl)cache;
        DistributedRegion root = (DistributedRegion)gemCache.getRegion(PR_ROOT_REGION_NAME, true);
        if (root == null) {
            if (!createIfAbsent) {
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Creating root Partitioned Admin Region {}", new Object[]{PR_ROOT_REGION_NAME});
            }
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(DataPolicy.REPLICATE);
            factory.addCacheListener(new FixedPartitionAttributesListener());
            if (Boolean.getBoolean("gemfire.PRDebug")) {
                factory.addCacheListener(new CacheListenerAdapter(){

                    @Override
                    public void afterCreate(EntryEvent event) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Create Event for allPR: key = {} oldVal = {} newVal = {} Op = {} origin = {} isNetSearch = {}", new Object[]{event.getKey(), event.getOldValue(), event.getNewValue(), event.getOperation(), event.getDistributedMember(), event.getOperation().isNetSearch()});
                        }
                    }

                    @Override
                    public void afterUpdate(EntryEvent event) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Update Event for allPR: key = {} oldVal = {} newVal = {} Op = {} origin = {} isNetSearch = {}", new Object[]{event.getKey(), event.getOldValue(), event.getNewValue(), event.getOperation(), event.getDistributedMember(), event.getOperation().isNetSearch()});
                        }
                    }

                    @Override
                    public void afterDestroy(EntryEvent event) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Destroy Event for allPR: key = {} oldVal = {} newVal = {} Op = {} origin = {} isNetSearch = {}", new Object[]{event.getKey(), event.getOldValue(), event.getNewValue(), event.getOperation(), event.getDistributedMember(), event.getOperation().isNetSearch()});
                        }
                    }
                });
                factory.setCacheWriter(new CacheWriterAdapter(){

                    @Override
                    public void beforeUpdate(EntryEvent event) throws CacheWriterException {
                        PartitionRegionConfig oldConf;
                        PartitionRegionConfig newConf = (PartitionRegionConfig)event.getNewValue();
                        if (newConf != (oldConf = (PartitionRegionConfig)event.getOldValue()) && !newConf.isGreaterNodeListVersion(oldConf)) {
                            throw new CacheWriterException(LocalizedStrings.PartitionedRegionHelper_NEW_PARTITIONEDREGIONCONFIG_0_DOES_NOT_HAVE_NEWER_VERSION_THAN_PREVIOUS_1.toLocalizedString(newConf, oldConf));
                        }
                    }
                });
            }
            RegionAttributes ra = factory.create();
            HasCachePerfStats prMetaStatsHolder = new HasCachePerfStats(){

                @Override
                public CachePerfStats getCachePerfStats() {
                    return new CachePerfStats(cache.getDistributedSystem(), "partitionMetaData");
                }
            };
            try {
                root = (DistributedRegion)gemCache.createVMRegion(PR_ROOT_REGION_NAME, ra, new InternalRegionArguments().setIsUsedForPartitionedRegionAdmin(true).setCachePerfStatsHolder(prMetaStatsHolder));
                root.getDistributionAdvisor().addMembershipListener(new MemberFailureListener());
            }
            catch (RegionExistsException silly) {
                root = (DistributedRegion)gemCache.getRegion(PR_ROOT_REGION_NAME, true);
            }
            catch (IOException ieo) {
                Assert.assertTrue(false, "IOException creating Partitioned Region root: " + ieo);
            }
            catch (ClassNotFoundException cne) {
                Assert.assertTrue(false, "ClassNotFoundExcpetion creating Partitioned Region root: " + cne);
            }
        }
        Assert.assertTrue(root != null, "Can not obtain internal Partitioned Region configuration root");
        return root;
    }

    public static void cleanUpMetaDataOnNodeFailure(DistributedMember failedMemId) {
        try {
            LocalRegion rootReg;
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache == null || cache.getCancelCriterion().cancelInProgress() != null) {
                return;
            }
            DM dm = cache.getDistributedSystem().getDistributionManager();
            if (logger.isDebugEnabled()) {
                logger.debug("Cleaning PartitionedRegion meta data for memberId={}", new Object[]{failedMemId});
            }
            if ((rootReg = PartitionedRegionHelper.getPRRoot(cache, false)) == null) {
                return;
            }
            ArrayList ks = new ArrayList(rootReg.keySet());
            if (ks.size() > 1) {
                Collections.shuffle(ks, PartitionedRegion.rand);
            }
            for (String prName : ks) {
                try {
                    PartitionedRegionHelper.cleanUpMetaDataForRegion(cache, prName, failedMemId, null);
                }
                catch (CancelException cancelException) {
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Got exception in cleaning up metadata. {}", new Object[]{e.getMessage(), e});
                }
            }
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpMetaDataForRegion(final GemFireCacheImpl cache, final String prName, DistributedMember failedMemId, final Runnable postCleanupTask) {
        boolean runPostCleanUp = true;
        try {
            PartitionRegionConfig prConf;
            LocalRegion rootReg = PartitionedRegionHelper.getPRRoot(cache, false);
            if (rootReg == null) {
                return;
            }
            try {
                prConf = (PartitionRegionConfig)rootReg.get(prName);
            }
            catch (EntryDestroyedException ede) {
                if (runPostCleanUp && postCleanupTask != null) {
                    postCleanupTask.run();
                }
                return;
            }
            if (prConf == null) {
                return;
            }
            Set<Node> nodeList = prConf.getNodes();
            if (nodeList == null) {
                return;
            }
            for (final Node node1 : nodeList) {
                if (cache.getCancelCriterion().cancelInProgress() != null) {
                    return;
                }
                if (!node1.getMemberId().equals(failedMemId)) continue;
                cache.getDistributionManager().getPrMetaDataCleanupThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        PartitionedRegionHelper.cleanPartitionedRegionMetaDataForNode(cache, node1, prConf, prName);
                        if (postCleanupTask != null) {
                            postCleanupTask.run();
                        }
                    }
                });
                runPostCleanUp = false;
                return;
            }
        }
        finally {
            if (runPostCleanUp && postCleanupTask != null) {
                postCleanupTask.run();
            }
        }
    }

    private static void cleanPartitionedRegionMetaDataForNode(GemFireCacheImpl cache, Node node, PartitionRegionConfig prConf, String regionIdentifier) {
        if (logger.isDebugEnabled()) {
            logger.debug("Cleaning PartitionedRegion meta data for node={} for Partitioned Region={} configuration={}", new Object[]{node, regionIdentifier, prConf});
        }
        PartitionedRegionHelper.removeGlobalMetadataForFailedNode(node, regionIdentifier, cache);
        if (logger.isDebugEnabled()) {
            logger.debug("Done Cleaning PartitionedRegion meta data for memberId={} for {}", new Object[]{node, regionIdentifier});
        }
    }

    private static PartitionResolver getResolver(PartitionedRegion pr, Object key, Object callbackArgument) {
        PartitionResolver result = pr.getPartitionResolver();
        if (result != null) {
            return result;
        }
        if (key != null && key instanceof PartitionResolver) {
            return (PartitionResolver)key;
        }
        if (callbackArgument != null && callbackArgument instanceof PartitionResolver) {
            return (PartitionResolver)callbackArgument;
        }
        return null;
    }

    public static int getHashKey(PartitionedRegion pr, Operation operation, Object key, Object value, Object callbackArgument) {
        try {
            return PartitionedRegionHelper.getHashKey(null, pr, operation, key, value, callbackArgument);
        }
        catch (IllegalStateException e) {
            pr.getCache().getCancelCriterion().checkCancelInProgress(e);
            throw e;
        }
    }

    public static int getHashKey(EntryOperation event) {
        return PartitionedRegionHelper.getHashKey(event, null, null, null, null, null);
    }

    private static int getHashKey(EntryOperation event, PartitionedRegion pr, Operation operation, Object key, Object value, Object callbackArgument) {
        if (event != null) {
            pr = (PartitionedRegion)event.getRegion();
            key = event.getKey();
            callbackArgument = event.getCallbackArgument();
        }
        PartitionResolver resolver = PartitionedRegionHelper.getResolver(pr, key, callbackArgument);
        Object resolveKey = null;
        if (pr.isFixedPartitionedRegion()) {
            String partition = null;
            if (resolver instanceof FixedPartitionResolver) {
                ConcurrentMap<String, Integer[]> partitionMap = pr.getPartitionsMap();
                if (event == null) {
                    event = new EntryOperationImpl(pr, operation, key, value, callbackArgument);
                }
                if ((partition = ((FixedPartitionResolver)resolver).getPartitionName(event, partitionMap.keySet())) == null) {
                    Object[] prms = new Object[]{pr.getName(), resolver};
                    throw new IllegalStateException(LocalizedStrings.PartitionedRegionHelper_FOR_REGION_0_PARTITIONRESOLVER_1_RETURNED_PARTITION_NAME_NULL.toLocalizedString(prms));
                }
                Integer[] bucketArray = (Integer[])partitionMap.get(partition);
                if (bucketArray == null) {
                    Object[] prms = new Object[]{pr.getName(), partition};
                    throw new PartitionNotAvailableException(LocalizedStrings.PartitionedRegionHelper_FOR_FIXED_PARTITIONED_REGION_0_FIXED_PARTITION_1_IS_NOT_AVAILABLE_ON_ANY_DATASTORE.toLocalizedString(prms));
                }
                int numBukets = bucketArray[1];
                resolveKey = numBukets == 1 ? partition : resolver.getRoutingObject(event);
            } else {
                if (resolver == null) {
                    throw new IllegalStateException(LocalizedStrings.PartitionedRegionHelper_FOR_FIXED_PARTITIONED_REGION_0_FIXED_PARTITION_RESOLVER_IS_NOT_AVAILABLE.toString(pr.getName()));
                }
                if (!(resolver instanceof FixedPartitionResolver)) {
                    Object[] prms = new Object[]{pr.getName(), resolver};
                    throw new IllegalStateException(LocalizedStrings.PartitionedRegionHelper_FOR_FIXED_PARTITIONED_REGION_0_RESOLVER_DEFINED_1_IS_NOT_AN_INSTANCE_OF_FIXEDPARTITIONRESOLVER.toLocalizedString(prms));
                }
            }
            return PartitionedRegionHelper.assignFixedBucketId(pr, partition, resolveKey);
        }
        if (resolver == null) {
            resolveKey = key;
            if (resolveKey == null) {
                throw new IllegalStateException("attempting to hash null");
            }
        } else {
            if (event == null) {
                event = new EntryOperationImpl(pr, operation, key, value, callbackArgument);
            }
            if ((resolveKey = resolver.getRoutingObject(event)) == null) {
                throw new IllegalStateException(LocalizedStrings.PartitionedRegionHelper_THE_ROUTINGOBJECT_RETURNED_BY_PARTITIONRESOLVER_IS_NULL.toLocalizedString());
            }
        }
        return PartitionedRegionHelper.getHashKey(pr, resolveKey);
    }

    private static int assignFixedBucketId(PartitionedRegion pr, String partition, Object resolveKey) {
        Object[] prms;
        int startingBucketID = 0;
        int partitionNumBuckets = 0;
        boolean isPartitionAvailable = pr.getPartitionsMap().containsKey(partition);
        Integer[] partitionDeatils = (Integer[])pr.getPartitionsMap().get(partition);
        if (isPartitionAvailable) {
            startingBucketID = partitionDeatils[0];
            partitionNumBuckets = partitionDeatils[1];
            int hc = resolveKey.hashCode();
            int bucketId = Math.abs(hc % partitionNumBuckets);
            int n = bucketId + startingBucketID;
            assert (n != -1);
            return n;
        }
        List<FixedPartitionAttributesImpl> localFPAs = pr.getFixedPartitionAttributesImpl();
        if (localFPAs != null) {
            for (FixedPartitionAttributesImpl fixedPartitionAttributesImpl : localFPAs) {
                if (!fixedPartitionAttributesImpl.getPartitionName().equals(partition)) continue;
                isPartitionAvailable = true;
                partitionNumBuckets = fixedPartitionAttributesImpl.getNumBuckets();
                startingBucketID = fixedPartitionAttributesImpl.getStartingBucketID();
                break;
            }
        }
        if (!isPartitionAvailable) {
            List<FixedPartitionAttributesImpl> remoteFPAs = pr.getRegionAdvisor().adviseAllFixedPartitionAttributes();
            for (FixedPartitionAttributesImpl fpa : remoteFPAs) {
                if (!fpa.getPartitionName().equals(partition)) continue;
                isPartitionAvailable = true;
                partitionNumBuckets = fpa.getNumBuckets();
                startingBucketID = fpa.getStartingBucketID();
                break;
            }
        }
        if (partitionNumBuckets == 0 && isPartitionAvailable) {
            prms = new Object[]{pr.getName(), partition};
            throw new IllegalStateException(LocalizedStrings.PartitionedRegionHelper_FOR_REGION_0_FOR_PARTITION_1_PARTITIION_NUM_BUCKETS_ARE_SET_TO_0_BUCKETS_CANNOT_BE_CREATED_ON_THIS_MEMBER.toLocalizedString(prms));
        }
        if (!isPartitionAvailable) {
            prms = new Object[]{pr.getName(), partition};
            throw new PartitionNotAvailableException(LocalizedStrings.PartitionedRegionHelper_FOR_REGION_0_PARTITION_NAME_1_IS_NOT_AVAILABLE_ON_ANY_DATASTORE.toLocalizedString(prms));
        }
        int hc = resolveKey.hashCode();
        int n = Math.abs(hc % partitionNumBuckets);
        int partitionBucketID = n + startingBucketID;
        assert (partitionBucketID != -1);
        return partitionBucketID;
    }

    public static int getHashKey(PartitionedRegion pr, Object routingObject) {
        return PartitionedRegionHelper.getHashKey(routingObject, pr.getTotalNumberOfBuckets());
    }

    public static int getHashKey(Object routingObject, int totalNumBuckets) {
        int hc = routingObject.hashCode();
        int bucketId = hc % totalNumBuckets;
        return Math.abs(bucketId);
    }

    public static PartitionedRegion getPartitionedRegion(String prName, Cache cache) {
        Region region = cache.getRegion(prName);
        if (region != null && region instanceof PartitionedRegion) {
            return (PartitionedRegion)region;
        }
        return null;
    }

    public static boolean isBucketRegion(String fullPath) {
        return PartitionedRegionHelper.getBucketName(fullPath) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bucket getProxyBucketRegion(Cache cache, String fullPath, boolean postInit) throws PRLocallyDestroyedException {
        Region region;
        if (cache == null) {
            return null;
        }
        String bucketName = PartitionedRegionHelper.getBucketName(fullPath);
        if (bucketName == null) {
            return null;
        }
        String prid = PartitionedRegionHelper.getPRPath(bucketName);
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
        try {
            region = cache.getRegion(prid);
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
        if (region == null || !(region instanceof PartitionedRegion)) {
            return null;
        }
        PartitionedRegion pr = (PartitionedRegion)region;
        int bid = PartitionedRegionHelper.getBucketId(bucketName);
        RegionAdvisor ra = (RegionAdvisor)pr.getDistributionAdvisor();
        if (postInit) {
            return ra.getBucketPostInit(bid);
        }
        if (!ra.areBucketsInitialized()) {
            return null;
        }
        return ra.getBucket(bid);
    }

    public static String getBucketName(String bucketFullPath) {
        if (bucketFullPath == null || bucketFullPath.length() == 0) {
            return null;
        }
        int idxStartRoot = bucketFullPath.indexOf(BUCKET_FULL_PATH_PREFIX);
        if (idxStartRoot != -1) {
            int idxEndRoot = idxStartRoot + PR_ROOT_REGION_NAME.length() + "/".length();
            return bucketFullPath.substring(idxEndRoot);
        }
        InternalDistributedSystem ids = InternalDistributedSystem.getAnyInstance();
        if (ids != null && logger.isDebugEnabled()) {
            logger.debug("getBucketString no match fullPath={}", new Object[]{bucketFullPath});
        }
        return null;
    }

    public static String getBucketFullPath(String prFullPath, int bucketId) {
        String name = PartitionedRegionHelper.getBucketName(prFullPath, bucketId);
        if (name != null) {
            return "/__PR/" + name;
        }
        return null;
    }

    public static String escapePRPath(String prFullPath) {
        String escaped = prFullPath.replace("_", "__");
        escaped = escaped.replace('/', '_');
        return escaped;
    }

    public static String unescapePRPath(String escapedPath) {
        String path = escapedPath.replace('_', '/');
        path = path.replace(TWO_SEPARATORS, "_");
        return path;
    }

    public static String getBucketName(String prPath, int bucketId) {
        return BUCKET_REGION_PREFIX + PartitionedRegionHelper.escapePRPath(prPath) + "_" + bucketId;
    }

    public static String getPRPath(String bucketName) {
        int pridIdx = BUCKET_REGION_PREFIX.length();
        int bidSepIdx = bucketName.lastIndexOf("_");
        Assert.assertTrue(bidSepIdx > -1, "getProxyBucketRegion failed on " + bucketName);
        return PartitionedRegionHelper.unescapePRPath(bucketName.substring(pridIdx, bidSepIdx));
    }

    public static int getBucketId(String bucketName) {
        int bidSepIdx = bucketName.lastIndexOf("_");
        String bid = bucketName.substring(bidSepIdx + 1);
        return Integer.parseInt(bid);
    }

    public static boolean isSubRegion(String fullPath) {
        int idx;
        boolean isSubRegion = false;
        if (null != fullPath && (idx = fullPath.indexOf("/", "/".length())) >= 0) {
            isSubRegion = true;
        }
        return isSubRegion;
    }

    public static boolean isMemberAlive(DistributedMember mem, GemFireCacheImpl cache) {
        return PartitionedRegionHelper.getMembershipSet(cache).contains(mem);
    }

    public static Set getMembershipSet(GemFireCacheImpl cache) {
        return cache.getDistributedSystem().getDistributionManager().getDistributionManagerIds();
    }

    public static void logForDataLoss(PartitionedRegion partitionedRegion, int bucketId, String callingMethod) {
        if (!Boolean.getBoolean("gemfire.PRDebug")) {
            return;
        }
        LocalRegion root = PartitionedRegionHelper.getPRRoot(partitionedRegion.getCache());
        PartitionRegionConfig prConfig = (PartitionRegionConfig)root.get(partitionedRegion.getRegionIdentifier());
        if (prConfig == null) {
            return;
        }
        Set members = partitionedRegion.getDistributionManager().getDistributionManagerIds();
        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegionHelper_DATALOSS___0____SIZE_OF_NODELIST_AFTER_VERIFYBUCKETNODES_FOR_BUKID___1__IS_0, new Object[]{callingMethod, bucketId}));
        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegionHelper_DATALOSS___0____NODELIST_FROM_PRCONFIG___1, new Object[]{callingMethod, PartitionedRegionHelper.printCollection(prConfig.getNodes())}));
        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PartitionedRegionHelper_DATALOSS___0____CURRENT_MEMBERSHIP_LIST___1, new Object[]{callingMethod, PartitionedRegionHelper.printCollection(members)}));
    }

    public static String printCollection(Collection c) {
        if (c != null) {
            StringBuffer sb = new StringBuffer("[");
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                sb.append(itr.next());
                if (!itr.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
            return sb.toString();
        }
        return "[null]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroyLockService() {
        DistributedLockService dls = null;
        Object object = dlockMonitor;
        synchronized (object) {
            dls = DistributedLockService.getServiceNamed(PARTITION_LOCK_SERVICE_NAME);
        }
        if (dls != null) {
            try {
                DistributedLockService.destroy(PARTITION_LOCK_SERVICE_NAME);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static boolean isBucketPrimary(Bucket buk) {
        return buk.getBucketAdvisor().isPrimary();
    }

    public static boolean isRemotePrimaryAvailable(PartitionedRegion region, FixedPartitionAttributesImpl fpa) {
        List<FixedPartitionAttributesImpl> fpaList = region.getRegionAdvisor().adviseSameFPAs(fpa);
        for (FixedPartitionAttributes fixedPartitionAttributes : fpaList) {
            if (!fixedPartitionAttributes.isPrimary()) continue;
            return true;
        }
        return false;
    }

    public static FixedPartitionAttributesImpl getFixedPartitionAttributesForBucket(PartitionedRegion pr, int bucketId) {
        List<FixedPartitionAttributesImpl> localFPAs = pr.getFixedPartitionAttributesImpl();
        if (localFPAs != null) {
            for (FixedPartitionAttributesImpl fixedPartitionAttributesImpl : localFPAs) {
                if (!fixedPartitionAttributesImpl.hasBucket(bucketId)) continue;
                return fixedPartitionAttributesImpl;
            }
        }
        List<FixedPartitionAttributesImpl> remoteFPAs = pr.getRegionAdvisor().adviseAllFixedPartitionAttributes();
        for (FixedPartitionAttributesImpl fpa : remoteFPAs) {
            if (!fpa.hasBucket(bucketId)) continue;
            return fpa;
        }
        Object[] objectArray = new Object[]{pr.getName(), bucketId};
        throw new PartitionNotAvailableException(LocalizedStrings.PartitionedRegionHelper_FOR_FIXED_PARTITIONED_REGION_0_FIXED_PARTITION_IS_NOT_AVAILABLE_FOR_BUCKET_1_ON_ANY_DATASTORE.toLocalizedString(objectArray));
    }

    private static Set<String> getAllAvailablePartitions(PartitionedRegion region) {
        HashSet<String> partitionSet = new HashSet<String>();
        List<FixedPartitionAttributesImpl> localFPAs = region.getFixedPartitionAttributesImpl();
        if (localFPAs != null) {
            for (FixedPartitionAttributesImpl fpa : localFPAs) {
                partitionSet.add(fpa.getPartitionName());
            }
        }
        List<FixedPartitionAttributesImpl> remoteFPAs = region.getRegionAdvisor().adviseAllFixedPartitionAttributes();
        for (FixedPartitionAttributes fixedPartitionAttributes : remoteFPAs) {
            partitionSet.add(fixedPartitionAttributes.getPartitionName());
        }
        return Collections.unmodifiableSet(partitionSet);
    }

    public static Set<FixedPartitionAttributes> getAllFixedPartitionAttributes(PartitionedRegion region) {
        HashSet<FixedPartitionAttributes> fpaSet = new HashSet<FixedPartitionAttributes>();
        List<FixedPartitionAttributesImpl> localFPAs = region.getFixedPartitionAttributesImpl();
        if (localFPAs != null) {
            fpaSet.addAll(localFPAs);
        }
        List<FixedPartitionAttributesImpl> remoteFPAs = region.getRegionAdvisor().adviseAllFixedPartitionAttributes();
        fpaSet.addAll(remoteFPAs);
        return fpaSet;
    }

    static {
        dlockMonitor = new Object();
        HashSet<DataPolicy> policies = new HashSet<DataPolicy>();
        policies.add(DEFAULT_DATA_POLICY);
        policies.add(DataPolicy.PERSISTENT_PARTITION);
        ALLOWED_DATA_POLICIES = Collections.unmodifiableSet(policies);
        TWO_SEPARATORS = "//";
    }

    private static class MemberFailureListener
    implements MembershipListener {
        private MemberFailureListener() {
        }

        @Override
        public void memberJoined(InternalDistributedMember id) {
        }

        @Override
        public void memberDeparted(InternalDistributedMember id, boolean crashed) {
            PartitionedRegionHelper.cleanUpMetaDataOnNodeFailure(id);
        }

        @Override
        public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        }

        @Override
        public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }
    }
}

