/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.delta.Delta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ListOfDeltas
implements Delta {
    private List<Delta> listOfDeltas;
    private transient int deltaAppliedIndex = 0;

    public ListOfDeltas(int size) {
        this.listOfDeltas = new ArrayList<Delta>(size);
    }

    public ListOfDeltas(Delta deltaObj) {
        this.listOfDeltas = new ArrayList<Delta>();
        this.listOfDeltas.add(deltaObj);
    }

    public ListOfDeltas() {
    }

    public Object apply(EntryEvent ev) {
        if (ev != null && ev instanceof EntryEventImpl) {
            EntryEventImpl putEvent = (EntryEventImpl)ev;
            int last = this.listOfDeltas.size() - 1;
            for (int i = this.deltaAppliedIndex; i < this.listOfDeltas.size(); ++i) {
                Object o = this.listOfDeltas.get(i).apply(putEvent);
                if (i < last) {
                    putEvent.setOldValue(o);
                    continue;
                }
                putEvent.setNewValue(o);
            }
            return putEvent.getNewValue();
        }
        throw new InternalGemFireException("ListOfDeltas.apply: putEvent is either null or is not of type EntryEventImpl");
    }

    @Override
    public Object merge(Object toMerge, boolean isCreate) {
        throw new UnsupportedOperationException("Invocation not expected");
    }

    @Override
    public Object merge(Object toMerge) {
        this.listOfDeltas.add((Delta)toMerge);
        return this;
    }

    @Override
    public Object getResultantValue() {
        return this;
    }

    public int getNumDeltas() {
        return this.listOfDeltas.size();
    }

    public void setDeltaAppliedIndex(int deltaApplied) {
        this.deltaAppliedIndex = deltaApplied;
    }

    public List<Delta> getListOfDeltas() {
        return Collections.unmodifiableList(this.listOfDeltas);
    }
}

