/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReliableReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXMessage;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class JtaBeforeCompletionMessage
extends TXMessage {
    private static final Logger logger = LogService.getLogger();

    public JtaBeforeCompletionMessage() {
    }

    public JtaBeforeCompletionMessage(int txUniqId, InternalDistributedMember onBehalfOfClientMember, ReplyProcessor21 processor) {
        super(txUniqId, onBehalfOfClientMember, processor);
    }

    public static ReliableReplyProcessor21 send(Cache cache, int txUniqId, InternalDistributedMember onBehalfOfClientMember, DistributedMember recipient) {
        InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        ReliableReplyProcessor21 response = new ReliableReplyProcessor21(system, recipients);
        JtaBeforeCompletionMessage msg = new JtaBeforeCompletionMessage(txUniqId, onBehalfOfClientMember, response);
        msg.setRecipients(recipients);
        system.getDistributionManager().putOutgoing(msg);
        return response;
    }

    @Override
    protected boolean operateOnTx(TXId txId, DistributionManager dm) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        TXManagerImpl txMgr = cache.getTXMgr();
        if (logger.isDebugEnabled()) {
            logger.debug("JTA: Calling beforeCompletion for :{}", new Object[]{txId});
        }
        txMgr.getTXState().beforeCompletion();
        return true;
    }

    @Override
    public int getDSFID() {
        return -114;
    }
}

