/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;

public class InterestEvent {
    private Object key;
    private Object value;
    private boolean isDeserialized = false;

    public InterestEvent(Object key, Object value, boolean isDeserialized) {
        this.key = key;
        this.value = value;
        this.isDeserialized = isDeserialized;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        if (this.isDeserialized || this.value == null) {
            return this.value;
        }
        try {
            this.value = CacheServerHelper.deserialize((byte[])this.value);
        }
        catch (IOException ioe) {
            throw new RuntimeException(LocalizedStrings.InterestEvent_IOEXCEPTION_DESERIALIZING_VALUE.toLocalizedString(), ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(LocalizedStrings.InterestEvent_CLASSNOTFOUNDEXCEPTION_DESERIALIZING_VALUE.toLocalizedString(), cnfe);
        }
        this.isDeserialized = true;
        return this.value;
    }
}

